/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.parser.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.toml.internal.parser.tree.STNodeTransformer;
import io.ballerina.toml.internal.parser.tree.STNodeVisitor;
import io.ballerina.toml.internal.parser.tree.STValueNode;
import io.ballerina.toml.syntax.tree.ArrayNode;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STArrayNode
extends STValueNode {
    public final STNode openBracket;
    public final STNode value;
    public final STNode closeBracket;

    STArrayNode(STNode openBracket, STNode value2, STNode closeBracket) {
        this(openBracket, value2, closeBracket, Collections.emptyList());
    }

    STArrayNode(STNode openBracket, STNode value2, STNode closeBracket, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ARRAY, diagnostics);
        this.openBracket = openBracket;
        this.value = value2;
        this.closeBracket = closeBracket;
        this.addChildren(openBracket, value2, closeBracket);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STArrayNode(this.openBracket, this.value, this.closeBracket, diagnostics);
    }

    public STArrayNode modify(STNode openBracket, STNode value2, STNode closeBracket) {
        if (this.checkForReferenceEquality(openBracket, value2, closeBracket)) {
            return this;
        }
        return new STArrayNode(openBracket, value2, closeBracket, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ArrayNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

