/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.parser.tree;

import io.ballerina.toml.internal.parser.tree.STArrayNode;
import io.ballerina.toml.internal.parser.tree.STBoolLiteralNode;
import io.ballerina.toml.internal.parser.tree.STDocumentNode;
import io.ballerina.toml.internal.parser.tree.STIdentifierLiteralNode;
import io.ballerina.toml.internal.parser.tree.STIdentifierToken;
import io.ballerina.toml.internal.parser.tree.STInlineTableNode;
import io.ballerina.toml.internal.parser.tree.STKeyNode;
import io.ballerina.toml.internal.parser.tree.STKeyValueNode;
import io.ballerina.toml.internal.parser.tree.STLiteralStringLiteralNode;
import io.ballerina.toml.internal.parser.tree.STLiteralValueToken;
import io.ballerina.toml.internal.parser.tree.STMissingToken;
import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.parser.tree.STNodeFactory;
import io.ballerina.toml.internal.parser.tree.STNodeList;
import io.ballerina.toml.internal.parser.tree.STNodeTransformer;
import io.ballerina.toml.internal.parser.tree.STNumericLiteralNode;
import io.ballerina.toml.internal.parser.tree.STStringLiteralNode;
import io.ballerina.toml.internal.parser.tree.STTableArrayNode;
import io.ballerina.toml.internal.parser.tree.STTableNode;
import io.ballerina.toml.internal.parser.tree.STToken;

public abstract class STTreeModifier
extends STNodeTransformer<STNode> {
    @Override
    public STDocumentNode transform(STDocumentNode documentNode) {
        STNode members = this.modifyNode(documentNode.members);
        STNode eofToken = this.modifyNode(documentNode.eofToken);
        return documentNode.modify(members, eofToken);
    }

    @Override
    public STTableNode transform(STTableNode tableNode) {
        STNode openBracket = this.modifyNode(tableNode.openBracket);
        STNode identifier = this.modifyNode(tableNode.identifier);
        STNode closeBracket = this.modifyNode(tableNode.closeBracket);
        STNode fields = this.modifyNode(tableNode.fields);
        return tableNode.modify(openBracket, identifier, closeBracket, fields);
    }

    @Override
    public STTableArrayNode transform(STTableArrayNode tableArrayNode) {
        STNode firstOpenBracket = this.modifyNode(tableArrayNode.firstOpenBracket);
        STNode secondOpenBracket = this.modifyNode(tableArrayNode.secondOpenBracket);
        STNode identifier = this.modifyNode(tableArrayNode.identifier);
        STNode firstCloseBracket = this.modifyNode(tableArrayNode.firstCloseBracket);
        STNode secondCloseBracket = this.modifyNode(tableArrayNode.secondCloseBracket);
        STNode fields = this.modifyNode(tableArrayNode.fields);
        return tableArrayNode.modify(firstOpenBracket, secondOpenBracket, identifier, firstCloseBracket, secondCloseBracket, fields);
    }

    @Override
    public STKeyValueNode transform(STKeyValueNode keyValueNode) {
        STNode identifier = this.modifyNode(keyValueNode.identifier);
        STNode assign = this.modifyNode(keyValueNode.assign);
        STNode value2 = this.modifyNode(keyValueNode.value);
        return keyValueNode.modify(identifier, assign, value2);
    }

    @Override
    public STArrayNode transform(STArrayNode arrayNode) {
        STNode openBracket = this.modifyNode(arrayNode.openBracket);
        STNode value2 = this.modifyNode(arrayNode.value);
        STNode closeBracket = this.modifyNode(arrayNode.closeBracket);
        return arrayNode.modify(openBracket, value2, closeBracket);
    }

    @Override
    public STInlineTableNode transform(STInlineTableNode inlineTableNode) {
        STNode openBrace = this.modifyNode(inlineTableNode.openBrace);
        STNode values = this.modifyNode(inlineTableNode.values);
        STNode closeBrace = this.modifyNode(inlineTableNode.closeBrace);
        return inlineTableNode.modify(openBrace, values, closeBrace);
    }

    @Override
    public STStringLiteralNode transform(STStringLiteralNode stringLiteralNode) {
        STNode startDoubleQuote = this.modifyNode(stringLiteralNode.startDoubleQuote);
        STNode content = this.modifyNode(stringLiteralNode.content);
        STNode endDoubleQuote = this.modifyNode(stringLiteralNode.endDoubleQuote);
        return stringLiteralNode.modify(startDoubleQuote, content, endDoubleQuote);
    }

    @Override
    public STLiteralStringLiteralNode transform(STLiteralStringLiteralNode literalStringLiteralNode) {
        STNode startSingleQuote = this.modifyNode(literalStringLiteralNode.startSingleQuote);
        STNode content = this.modifyNode(literalStringLiteralNode.content);
        STNode endSingleQuote = this.modifyNode(literalStringLiteralNode.endSingleQuote);
        return literalStringLiteralNode.modify(startSingleQuote, content, endSingleQuote);
    }

    @Override
    public STNumericLiteralNode transform(STNumericLiteralNode numericLiteralNode) {
        STNode sign = this.modifyNode(numericLiteralNode.sign);
        STNode value2 = this.modifyNode(numericLiteralNode.value);
        return numericLiteralNode.modify(numericLiteralNode.kind, sign, value2);
    }

    @Override
    public STBoolLiteralNode transform(STBoolLiteralNode boolLiteralNode) {
        STNode value2 = this.modifyNode(boolLiteralNode.value);
        return boolLiteralNode.modify(value2);
    }

    @Override
    public STIdentifierLiteralNode transform(STIdentifierLiteralNode identifierLiteralNode) {
        STNode value2 = this.modifyNode(identifierLiteralNode.value);
        return identifierLiteralNode.modify(value2);
    }

    @Override
    public STKeyNode transform(STKeyNode keyNode) {
        STNode value2 = this.modifyNode(keyNode.value);
        return keyNode.modify(value2);
    }

    @Override
    public STToken transform(STToken token) {
        return token;
    }

    @Override
    public STIdentifierToken transform(STIdentifierToken identifier) {
        return identifier;
    }

    @Override
    public STLiteralValueToken transform(STLiteralValueToken literalValueToken) {
        return literalValueToken;
    }

    @Override
    public STMissingToken transform(STMissingToken missingToken) {
        return missingToken;
    }

    @Override
    public STNode transform(STNodeList nodeList) {
        if (nodeList.isEmpty()) {
            return nodeList;
        }
        boolean nodeModified = false;
        STNode[] newSTNodes = new STNode[nodeList.size()];
        for (int index = 0; index < nodeList.size(); ++index) {
            STNode newNode;
            STNode oldNode = nodeList.get(index);
            if (oldNode != (newNode = this.modifyNode(oldNode))) {
                nodeModified = true;
            }
            newSTNodes[index] = newNode;
        }
        if (!nodeModified) {
            return nodeList;
        }
        return STNodeFactory.createNodeList(newSTNodes);
    }

    @Override
    protected STNode transformSyntaxNode(STNode node) {
        return node;
    }

    protected <T extends STNode> T modifyNode(T node) {
        if (node == null) {
            return null;
        }
        return (T)node.apply(this);
    }
}

