/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.semantic.ast;

import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlKeyNode;
import io.ballerina.toml.semantic.ast.TomlNodeVisitor;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.toml.syntax.tree.KeyValueNode;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.Set;

public class TomlKeyValueNode
extends TopLevelNode {
    private final TomlValueNode value;

    public TomlKeyValueNode(KeyValueNode kvNode, TomlKeyNode key, TomlValueNode value2, TomlNodeLocation location) {
        super(kvNode, key, TomlType.KEY_VALUE, location);
        this.value = value2;
    }

    public TomlValueNode value() {
        return this.value;
    }

    @Override
    public Set<Diagnostic> diagnostics() {
        Set tomlDiagnostics = this.diagnostics;
        tomlDiagnostics.addAll(this.value.diagnostics());
        return tomlDiagnostics;
    }

    @Override
    public void clearDiagnostics() {
        this.diagnostics.clear();
        this.value.clearDiagnostics();
    }

    public String toString() {
        return "TomlKeyValue{key=" + this.key().name() + ", value=" + String.valueOf(this.value) + "}";
    }

    @Override
    public void accept(TomlNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object toNativeObject() {
        return this.value.toNativeValue();
    }
}

