/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.semantic.ast;

import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlBasicValueNode;
import io.ballerina.toml.semantic.ast.TomlNodeVisitor;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.toml.syntax.tree.LiteralStringLiteralNode;
import io.ballerina.toml.syntax.tree.StringLiteralNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;

public class TomlStringValueNode
extends TomlBasicValueNode<String> {
    public TomlStringValueNode(StringLiteralNode stringLiteralNode, String value2, TomlNodeLocation location) {
        super(stringLiteralNode, value2, TomlType.STRING, location);
    }

    public TomlStringValueNode(LiteralStringLiteralNode literalStringNode, String value2, TomlNodeLocation location) {
        super(literalStringNode, value2, TomlType.STRING, location);
    }

    @Override
    public void accept(TomlNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isMissingNode() {
        if (this.externalTreeNode().kind() == SyntaxKind.STRING_LITERAL) {
            StringLiteralNode stringLiteralNode = (StringLiteralNode)this.externalTreeNode();
            if (stringLiteralNode.isMissing()) {
                return true;
            }
            return stringLiteralNode.startDoubleQuote().isMissing() || stringLiteralNode.endDoubleQuote().isMissing();
        }
        if (this.externalTreeNode().kind() == SyntaxKind.LITERAL_STRING) {
            LiteralStringLiteralNode literalStringNode = (LiteralStringLiteralNode)this.externalTreeNode();
            if (literalStringNode.isMissing()) {
                return true;
            }
            return literalStringNode.startSingleQuote().isMissing() || literalStringNode.startSingleQuote().isMissing();
        }
        return false;
    }
}

