/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.toml.syntax.tree.NodeTransformer;
import io.ballerina.toml.syntax.tree.NodeVisitor;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.toml.syntax.tree.ValueNode;
import java.util.Objects;

public class BoolLiteralNode
extends ValueNode {
    public BoolLiteralNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token value() {
        return (Token)this.childInBucket(0);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"value"};
    }

    public BoolLiteralNode modify(Token value2) {
        if (this.checkForReferenceEquality(value2)) {
            return this;
        }
        return NodeFactory.createBoolLiteralNode(value2);
    }

    public BoolLiteralNodeModifier modify() {
        return new BoolLiteralNodeModifier(this);
    }

    public static class BoolLiteralNodeModifier {
        private final BoolLiteralNode oldNode;
        private Token value;

        public BoolLiteralNodeModifier(BoolLiteralNode oldNode) {
            this.oldNode = oldNode;
            this.value = oldNode.value();
        }

        public BoolLiteralNodeModifier withValue(Token value2) {
            Objects.requireNonNull(value2, "value must not be null");
            this.value = value2;
            return this;
        }

        public BoolLiteralNode apply() {
            return this.oldNode.modify(this.value);
        }
    }
}

