/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.syntax.tree.IdentifierToken;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.toml.syntax.tree.NodeTransformer;
import io.ballerina.toml.syntax.tree.NodeVisitor;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.ValueNode;
import java.util.Objects;

public class IdentifierLiteralNode
extends ValueNode {
    public IdentifierLiteralNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public IdentifierToken value() {
        return (IdentifierToken)this.childInBucket(0);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"value"};
    }

    public IdentifierLiteralNode modify(IdentifierToken value2) {
        if (this.checkForReferenceEquality(value2)) {
            return this;
        }
        return NodeFactory.createIdentifierLiteralNode(value2);
    }

    public IdentifierLiteralNodeModifier modify() {
        return new IdentifierLiteralNodeModifier(this);
    }

    public static class IdentifierLiteralNodeModifier {
        private final IdentifierLiteralNode oldNode;
        private IdentifierToken value;

        public IdentifierLiteralNodeModifier(IdentifierLiteralNode oldNode) {
            this.oldNode = oldNode;
            this.value = oldNode.value();
        }

        public IdentifierLiteralNodeModifier withValue(IdentifierToken value2) {
            Objects.requireNonNull(value2, "value must not be null");
            this.value = value2;
            return this;
        }

        public IdentifierLiteralNode apply() {
            return this.oldNode.modify(this.value);
        }
    }
}

