/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.KeyNode;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.toml.syntax.tree.NodeTransformer;
import io.ballerina.toml.syntax.tree.NodeVisitor;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.toml.syntax.tree.ValueNode;
import java.util.Objects;

public class KeyValueNode
extends DocumentMemberDeclarationNode {
    public KeyValueNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public KeyNode identifier() {
        return (KeyNode)this.childInBucket(0);
    }

    public Token assign() {
        return (Token)this.childInBucket(1);
    }

    public ValueNode value() {
        return (ValueNode)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"identifier", "assign", "value"};
    }

    public KeyValueNode modify(KeyNode identifier, Token assign, ValueNode value2) {
        if (this.checkForReferenceEquality(identifier, assign, value2)) {
            return this;
        }
        return NodeFactory.createKeyValueNode(identifier, assign, value2);
    }

    public KeyValueNodeModifier modify() {
        return new KeyValueNodeModifier(this);
    }

    public static class KeyValueNodeModifier {
        private final KeyValueNode oldNode;
        private KeyNode identifier;
        private Token assign;
        private ValueNode value;

        public KeyValueNodeModifier(KeyValueNode oldNode) {
            this.oldNode = oldNode;
            this.identifier = oldNode.identifier();
            this.assign = oldNode.assign();
            this.value = oldNode.value();
        }

        public KeyValueNodeModifier withIdentifier(KeyNode identifier) {
            Objects.requireNonNull(identifier, "identifier must not be null");
            this.identifier = identifier;
            return this;
        }

        public KeyValueNodeModifier withAssign(Token assign) {
            Objects.requireNonNull(assign, "assign must not be null");
            this.assign = assign;
            return this;
        }

        public KeyValueNodeModifier withValue(ValueNode value2) {
            Objects.requireNonNull(value2, "value must not be null");
            this.value = value2;
            return this;
        }

        public KeyValueNode apply() {
            return this.oldNode.modify(this.identifier, this.assign, this.value);
        }
    }
}

