/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.KeyNode;
import io.ballerina.toml.syntax.tree.KeyValueNode;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.toml.syntax.tree.NodeList;
import io.ballerina.toml.syntax.tree.NodeTransformer;
import io.ballerina.toml.syntax.tree.NodeVisitor;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.Token;
import java.util.Objects;

public class TableArrayNode
extends DocumentMemberDeclarationNode {
    public TableArrayNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token firstOpenBracket() {
        return (Token)this.childInBucket(0);
    }

    public Token secondOpenBracket() {
        return (Token)this.childInBucket(1);
    }

    public KeyNode identifier() {
        return (KeyNode)this.childInBucket(2);
    }

    public Token firstCloseBracket() {
        return (Token)this.childInBucket(3);
    }

    public Token secondCloseBracket() {
        return (Token)this.childInBucket(4);
    }

    public NodeList<KeyValueNode> fields() {
        return new NodeList<KeyValueNode>((NonTerminalNode)this.childInBucket(5));
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"firstOpenBracket", "secondOpenBracket", "identifier", "firstCloseBracket", "secondCloseBracket", "fields"};
    }

    public TableArrayNode modify(Token firstOpenBracket, Token secondOpenBracket, KeyNode identifier, Token firstCloseBracket, Token secondCloseBracket, NodeList<KeyValueNode> fields) {
        if (this.checkForReferenceEquality(firstOpenBracket, secondOpenBracket, identifier, firstCloseBracket, secondCloseBracket, fields.underlyingListNode())) {
            return this;
        }
        return NodeFactory.createTableArrayNode(firstOpenBracket, secondOpenBracket, identifier, firstCloseBracket, secondCloseBracket, fields);
    }

    public TableArrayNodeModifier modify() {
        return new TableArrayNodeModifier(this);
    }

    public static class TableArrayNodeModifier {
        private final TableArrayNode oldNode;
        private Token firstOpenBracket;
        private Token secondOpenBracket;
        private KeyNode identifier;
        private Token firstCloseBracket;
        private Token secondCloseBracket;
        private NodeList<KeyValueNode> fields;

        public TableArrayNodeModifier(TableArrayNode oldNode) {
            this.oldNode = oldNode;
            this.firstOpenBracket = oldNode.firstOpenBracket();
            this.secondOpenBracket = oldNode.secondOpenBracket();
            this.identifier = oldNode.identifier();
            this.firstCloseBracket = oldNode.firstCloseBracket();
            this.secondCloseBracket = oldNode.secondCloseBracket();
            this.fields = oldNode.fields();
        }

        public TableArrayNodeModifier withFirstOpenBracket(Token firstOpenBracket) {
            Objects.requireNonNull(firstOpenBracket, "firstOpenBracket must not be null");
            this.firstOpenBracket = firstOpenBracket;
            return this;
        }

        public TableArrayNodeModifier withSecondOpenBracket(Token secondOpenBracket) {
            Objects.requireNonNull(secondOpenBracket, "secondOpenBracket must not be null");
            this.secondOpenBracket = secondOpenBracket;
            return this;
        }

        public TableArrayNodeModifier withIdentifier(KeyNode identifier) {
            Objects.requireNonNull(identifier, "identifier must not be null");
            this.identifier = identifier;
            return this;
        }

        public TableArrayNodeModifier withFirstCloseBracket(Token firstCloseBracket) {
            Objects.requireNonNull(firstCloseBracket, "firstCloseBracket must not be null");
            this.firstCloseBracket = firstCloseBracket;
            return this;
        }

        public TableArrayNodeModifier withSecondCloseBracket(Token secondCloseBracket) {
            Objects.requireNonNull(secondCloseBracket, "secondCloseBracket must not be null");
            this.secondCloseBracket = secondCloseBracket;
            return this;
        }

        public TableArrayNodeModifier withFields(NodeList<KeyValueNode> fields) {
            Objects.requireNonNull(fields, "fields must not be null");
            this.fields = fields;
            return this;
        }

        public TableArrayNode apply() {
            return this.oldNode.modify(this.firstOpenBracket, this.secondOpenBracket, this.identifier, this.firstCloseBracket, this.secondCloseBracket, this.fields);
        }
    }
}

