/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types;

import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;

public final class BasicTypeBitSet
implements SemType {
    public final int bitset;

    private BasicTypeBitSet(int bitset) {
        this.bitset = bitset;
    }

    public static BasicTypeBitSet from(int bitset) {
        if (bitset == 0) {
            return BitSetCache.ZERO;
        }
        if (Integer.bitCount(bitset) == 1) {
            return BitSetCache.CACHE[Integer.numberOfTrailingZeros(bitset)];
        }
        return new BasicTypeBitSet(bitset);
    }

    public static BasicTypeBitSet union(BasicTypeBitSet t1, BasicTypeBitSet t2) {
        return BasicTypeBitSet.from(t1.bitset | t2.bitset);
    }

    public String toString() {
        return PredefinedType.toString(this.bitset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BasicTypeBitSet) {
            BasicTypeBitSet b = (BasicTypeBitSet)o;
            return b.bitset == this.bitset;
        }
        return false;
    }

    public int hashCode() {
        return this.bitset;
    }

    @Override
    public int all() {
        return this.bitset;
    }

    private static final class BitSetCache {
        private static final int SIZE = 20;
        private static final BasicTypeBitSet[] CACHE = new BasicTypeBitSet[20];
        private static final BasicTypeBitSet ZERO = new BasicTypeBitSet(0);

        private BitSetCache() {
        }

        static {
            for (int i = 0; i < 20; ++i) {
                BitSetCache.CACHE[i] = new BasicTypeBitSet(1 << i);
            }
        }
    }
}

