/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types;

import io.ballerina.types.Atom;
import io.ballerina.types.Bdd;
import io.ballerina.types.BddMemo;
import io.ballerina.types.Env;
import io.ballerina.types.FunctionAtomicType;
import io.ballerina.types.ListAtomicType;
import io.ballerina.types.MappingAtomicType;
import io.ballerina.types.RecAtom;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypePair;
import io.ballerina.types.TypeAtom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Context {
    public final Env env;
    public final Map<Bdd, BddMemo> functionMemo = new HashMap<Bdd, BddMemo>();
    public final Map<Bdd, BddMemo> listMemo = new HashMap<Bdd, BddMemo>();
    public final Map<Bdd, BddMemo> mappingMemo = new HashMap<Bdd, BddMemo>();
    public final Map<SemTypePair, Boolean> comparableMemo = new HashMap<SemTypePair, Boolean>();
    final List<BddMemo> memoStack = new ArrayList<BddMemo>();
    private static volatile Context instance;
    SemType anydataMemo;
    SemType jsonMemo;
    SemType cloneableMemo;
    SemType isolatedObjectMemo;
    SemType serviceObjectMemo;

    private Context(Env env) {
        this.env = env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Context from(Env env) {
        if (instance == null) {
            Class<Context> clazz = Context.class;
            // MONITORENTER : io.ballerina.types.Context.class
            if (instance == null) {
                instance = new Context(env);
            }
            // MONITOREXIT : clazz
        }
        if (Context.instance.env == env) {
            return instance;
        }
        instance = new Context(env);
        return instance;
    }

    public ListAtomicType listAtomType(Atom atom) {
        if (atom instanceof RecAtom) {
            RecAtom recAtom = (RecAtom)atom;
            return this.env.getRecListAtomType(recAtom);
        }
        return (ListAtomicType)((TypeAtom)atom).atomicType();
    }

    public MappingAtomicType mappingAtomType(Atom atom) {
        if (atom instanceof RecAtom) {
            RecAtom recAtom = (RecAtom)atom;
            return this.env.getRecMappingAtomType(recAtom);
        }
        return (MappingAtomicType)((TypeAtom)atom).atomicType();
    }

    public FunctionAtomicType functionAtomType(Atom atom) {
        if (atom instanceof RecAtom) {
            RecAtom recAtom = (RecAtom)atom;
            return this.env.getRecFunctionAtomType(recAtom);
        }
        return (FunctionAtomicType)((TypeAtom)atom).atomicType();
    }
}

