/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types;

import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.Context;
import io.ballerina.types.Core;
import io.ballerina.types.Env;
import io.ballerina.types.Error;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.definition.ObjectDefinition;
import io.ballerina.types.subtypedata.BooleanSubtype;
import io.ballerina.types.subtypedata.DecimalSubtype;
import io.ballerina.types.subtypedata.FloatSubtype;
import io.ballerina.types.subtypedata.FutureSubtype;
import io.ballerina.types.subtypedata.IntSubtype;
import io.ballerina.types.subtypedata.StringSubtype;
import io.ballerina.types.subtypedata.TableSubtype;
import io.ballerina.types.subtypedata.TypedescSubtype;
import io.ballerina.types.subtypedata.XmlSubtype;
import io.ballerina.types.typeops.ListProj;
import java.math.BigDecimal;

public final class SemTypes {
    public static final SemType SINT8 = IntSubtype.intWidthSigned(8L);
    public static final SemType SINT16 = IntSubtype.intWidthSigned(16L);
    public static final SemType SINT32 = IntSubtype.intWidthSigned(32L);
    public static final SemType UINT8 = PredefinedType.BYTE;
    public static final SemType UINT16 = IntSubtype.intWidthUnsigned(16);
    public static final SemType UINT32 = IntSubtype.intWidthUnsigned(32);
    public static final SemType CHAR = PredefinedType.STRING_CHAR;
    public static final SemType XML_ELEMENT = PredefinedType.XML_ELEMENT;
    public static final SemType XML_COMMENT = PredefinedType.XML_COMMENT;
    public static final SemType XML_TEXT = PredefinedType.XML_TEXT;
    public static final SemType XML_PI = PredefinedType.XML_PI;

    public static SemType floatConst(double v) {
        return FloatSubtype.floatConst(v);
    }

    public static SemType intConst(long value2) {
        return IntSubtype.intConst(value2);
    }

    public static SemType stringConst(String value2) {
        return StringSubtype.stringConst(value2);
    }

    public static SemType booleanConst(boolean value2) {
        return BooleanSubtype.booleanConst(value2);
    }

    public static SemType decimalConst(String value2) {
        if (value2.contains("d") || value2.contains("D")) {
            value2 = value2.substring(0, value2.length() - 1);
        }
        BigDecimal d = new BigDecimal(value2);
        return DecimalSubtype.decimalConst(d);
    }

    public static SemType union(SemType t1, SemType t2) {
        return Core.union(t1, t2);
    }

    public static SemType union(SemType first, SemType second, SemType ... rest) {
        SemType u = Core.union(first, second);
        for (SemType s : rest) {
            u = Core.union(u, s);
        }
        return u;
    }

    public static SemType intersect(SemType t1, SemType t2) {
        return Core.intersect(t1, t2);
    }

    public static SemType intersect(SemType first, SemType second, SemType ... rest) {
        SemType i = Core.intersect(first, second);
        for (SemType s : rest) {
            i = Core.intersect(i, s);
        }
        return i;
    }

    public static boolean isSubtype(Context context, SemType t1, SemType t2) {
        return Core.isSubtype(context, t1, t2);
    }

    public static boolean isSubtypeSimple(SemType t1, BasicTypeBitSet t2) {
        return Core.isSubtypeSimple(t1, t2);
    }

    public static boolean isSubtypeSimpleNotNever(SemType t1, BasicTypeBitSet t2) {
        return !Core.isNever(t1) && Core.isSubtypeSimple(t1, t2);
    }

    public static boolean containsBasicType(SemType t1, BasicTypeBitSet t2) {
        return (Core.widenToBasicTypes((SemType)t1).bitset & t2.bitset) != 0;
    }

    public static boolean containsType(Context context, SemType type, SemType typeToBeContained) {
        return Core.isSameType(context, Core.intersect(type, typeToBeContained), typeToBeContained);
    }

    public static boolean isSameType(Context context, SemType t1, SemType t2) {
        return Core.isSameType(context, t1, t2);
    }

    public static SemType errorDetail(SemType detail) {
        return Error.errorDetail(detail);
    }

    public static SemType errorDistinct(int distinctId) {
        return Error.errorDistinct(distinctId);
    }

    public static SemType objectDistinct(int distinctId) {
        return ObjectDefinition.distinct(distinctId);
    }

    public static SemType tableContaining(Env env, SemType tableConstraint) {
        return TableSubtype.tableContaining(env, tableConstraint);
    }

    public static SemType tableContainingKeySpecifier(Context cx, SemType tableConstraint, String[] fieldNames) {
        return TableSubtype.tableContainingKeySpecifier(cx, tableConstraint, fieldNames);
    }

    public static SemType tableContainingKeyConstraint(Context cx, SemType tableConstraint, SemType keyConstraint) {
        return TableSubtype.tableContainingKeyConstraint(cx, tableConstraint, keyConstraint);
    }

    public static SemType futureContaining(Env env, SemType constraint) {
        return FutureSubtype.futureContaining(env, constraint);
    }

    public static SemType typedescContaining(Env env, SemType constraint) {
        return TypedescSubtype.typedescContaining(env, constraint);
    }

    public static SemType mappingMemberTypeInnerVal(Context context, SemType t, SemType m) {
        return Core.mappingMemberTypeInnerVal(context, t, m);
    }

    public static SemType listProj(Context context, SemType t, SemType key) {
        return ListProj.listProjInnerVal(context, t, key);
    }

    public static SemType listMemberType(Context context, SemType t, SemType key) {
        return Core.listMemberTypeInnerVal(context, t, key);
    }

    public static SemType xmlSequence(SemType t) {
        return XmlSubtype.xmlSequence(t);
    }
}

