/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.definition;

import io.ballerina.types.Atom;
import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.CellAtomicType;
import io.ballerina.types.CellSemType;
import io.ballerina.types.ComplexSemType;
import io.ballerina.types.Core;
import io.ballerina.types.Definition;
import io.ballerina.types.Env;
import io.ballerina.types.MappingAtomicType;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.RecAtom;
import io.ballerina.types.SemType;
import io.ballerina.types.definition.CellField;
import io.ballerina.types.definition.Field;
import io.ballerina.types.definition.SplitField;
import io.ballerina.types.subtypedata.BddNode;
import io.ballerina.types.subtypedata.CellSubtype;
import io.ballerina.types.typeops.BddCommonOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class MappingDefinition
implements Definition {
    private RecAtom rec = null;
    private SemType semType = null;

    @Override
    public SemType getSemType(Env env) {
        SemType s = this.semType;
        if (s == null) {
            RecAtom rec;
            this.rec = rec = env.recMappingAtom();
            return this.createSemType(env, rec);
        }
        return s;
    }

    public void setSemTypeToNever() {
        this.semType = PredefinedType.NEVER;
    }

    public SemType define(Env env, List<CellField> fields, CellSemType rest) {
        Atom atom;
        SplitField sfh = this.splitFields(fields);
        MappingAtomicType atomicType = MappingAtomicType.from((String[])sfh.names.toArray(String[]::new), (CellSemType[])sfh.types.toArray(CellSemType[]::new), rest);
        RecAtom rec = this.rec;
        if (rec != null) {
            atom = rec;
            env.setRecMappingAtomType(rec, atomicType);
        } else {
            atom = env.mappingAtom(atomicType);
        }
        return this.createSemType(env, atom);
    }

    public SemType defineMappingTypeWrapped(Env env, List<Field> fields, SemType rest) {
        return this.defineMappingTypeWrapped(env, fields, rest, CellAtomicType.CellMutability.CELL_MUT_LIMITED);
    }

    public SemType defineMappingTypeWrapped(Env env, List<Field> fields, SemType rest, CellAtomicType.CellMutability mut) {
        ArrayList<CellField> cellFields = new ArrayList<CellField>(fields.size());
        for (Field field : fields) {
            SemType ty = field.ty();
            cellFields.add(CellField.from(field.name(), CellSubtype.cellContaining(env, field.opt() ? Core.union(ty, PredefinedType.UNDEF) : ty, field.ro() ? CellAtomicType.CellMutability.CELL_MUT_NONE : mut)));
        }
        CellSemType restCell = CellSubtype.cellContaining(env, Core.union(rest, PredefinedType.UNDEF), Core.isNever(rest) ? CellAtomicType.CellMutability.CELL_MUT_NONE : mut);
        return this.define(env, cellFields, restCell);
    }

    private SemType createSemType(Env env, Atom atom) {
        BddNode bdd = BddCommonOps.bddAtom(atom);
        ComplexSemType s = PredefinedType.basicSubtype(BasicTypeCode.BT_MAPPING, bdd);
        this.semType = s;
        return s;
    }

    private SplitField splitFields(List<CellField> fields) {
        CellField[] sortedFields = (CellField[])fields.toArray(CellField[]::new);
        Arrays.sort(sortedFields, Comparator.comparing(MappingDefinition::fieldName));
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<CellSemType> types2 = new ArrayList<CellSemType>();
        for (CellField field : sortedFields) {
            names.add(field.name());
            types2.add(field.type());
        }
        return SplitField.from(names, types2);
    }

    private static String fieldName(CellField f) {
        return f.name();
    }
}

