/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.definition;

import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.Bdd;
import io.ballerina.types.CellAtomicType;
import io.ballerina.types.CellSemType;
import io.ballerina.types.Core;
import io.ballerina.types.Definition;
import io.ballerina.types.Env;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.RecAtom;
import io.ballerina.types.SemType;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.definition.CellField;
import io.ballerina.types.definition.Field;
import io.ballerina.types.definition.MappingDefinition;
import io.ballerina.types.definition.Member;
import io.ballerina.types.definition.ObjectQualifiers;
import io.ballerina.types.subtypedata.BddNode;
import io.ballerina.types.subtypedata.CellSubtype;
import io.ballerina.types.typeops.BddCommonOps;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

public final class ObjectDefinition
implements Definition {
    private final MappingDefinition mappingDefinition = new MappingDefinition();

    public static SemType distinct(int distinctId) {
        assert (distinctId >= 0);
        BddNode bdd = BddCommonOps.bddAtom(RecAtom.createDistinctRecAtom(-distinctId - 1));
        return PredefinedType.basicSubtype(BasicTypeCode.BT_OBJECT, bdd);
    }

    public SemType define(Env env, ObjectQualifiers qualifiers, Collection<Member> members) {
        assert (ObjectDefinition.validataMembers(members));
        CellAtomicType.CellMutability mut = qualifiers.readonly() ? CellAtomicType.CellMutability.CELL_MUT_NONE : CellAtomicType.CellMutability.CELL_MUT_LIMITED;
        Stream<CellField> memberStream = members.stream().map(member -> ObjectDefinition.memberField(env, member, mut));
        Stream<CellField> qualifierStream = Stream.of(qualifiers.field(env));
        SemType mappingType = this.mappingDefinition.define(env, Stream.concat(memberStream, qualifierStream).toList(), this.restMemberType(env, mut, qualifiers.readonly()));
        return this.objectContaining(mappingType);
    }

    private static boolean validataMembers(Collection<Member> members) {
        return members.stream().map(Member::name).distinct().count() == (long)members.size();
    }

    private SemType objectContaining(SemType mappingType) {
        SubtypeData bdd = Core.subtypeData(mappingType, BasicTypeCode.BT_MAPPING);
        assert (bdd instanceof Bdd);
        return Core.createBasicSemType(BasicTypeCode.BT_OBJECT, bdd);
    }

    private CellSemType restMemberType(Env env, CellAtomicType.CellMutability mut, boolean immutable) {
        MappingDefinition fieldDefn = new MappingDefinition();
        SemType fieldMemberType = fieldDefn.defineMappingTypeWrapped(env, List.of(new Field("value", immutable ? PredefinedType.VAL_READONLY : PredefinedType.VAL, immutable, false), Member.Kind.Field.field(), Member.Visibility.ALL), PredefinedType.NEVER);
        MappingDefinition methodDefn = new MappingDefinition();
        SemType methodMemberType = methodDefn.defineMappingTypeWrapped(env, List.of(new Field("value", PredefinedType.FUNCTION, true, false), Member.Kind.Method.field(), Member.Visibility.ALL), PredefinedType.NEVER);
        return CellSubtype.cellContaining(env, Core.union(fieldMemberType, methodMemberType), mut);
    }

    private static CellField memberField(Env env, Member member, CellAtomicType.CellMutability mut) {
        MappingDefinition md = new MappingDefinition();
        CellAtomicType.CellMutability fieldMut = member.immutable() ? CellAtomicType.CellMutability.CELL_MUT_NONE : mut;
        SemType semtype = md.defineMappingTypeWrapped(env, List.of(new Field("value", member.valueTy(), member.immutable(), false), member.kind().field(), member.visibility().field()), PredefinedType.NEVER);
        return CellField.from(member.name(), CellSubtype.cellContaining(env, semtype, fieldMut));
    }

    @Override
    public SemType getSemType(Env env) {
        return this.objectContaining(this.mappingDefinition.getSemType(env));
    }
}

