/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.definition;

import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.Bdd;
import io.ballerina.types.Core;
import io.ballerina.types.Definition;
import io.ballerina.types.Env;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.definition.ListDefinition;

public final class StreamDefinition
implements Definition {
    private final ListDefinition listDefinition = new ListDefinition();

    @Override
    public SemType getSemType(Env env) {
        return StreamDefinition.streamContaining(this.listDefinition.getSemType(env));
    }

    public SemType define(Env env, SemType valueTy, SemType completionTy) {
        if (PredefinedType.VAL.equals(completionTy) && PredefinedType.VAL.equals(valueTy)) {
            return PredefinedType.STREAM;
        }
        SemType tuple = this.listDefinition.tupleTypeWrapped(env, valueTy, completionTy);
        return StreamDefinition.streamContaining(tuple);
    }

    private static SemType streamContaining(SemType tupleType) {
        SubtypeData bdd = Core.subtypeData(tupleType, BasicTypeCode.BT_LIST);
        assert (bdd instanceof Bdd);
        return Core.createBasicSemType(BasicTypeCode.BT_STREAM, bdd);
    }
}

