/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.subtypedata;

import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.EnumerableDecimal;
import io.ballerina.types.EnumerableSubtype;
import io.ballerina.types.EnumerableType;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.ProperSubtypeData;
import io.ballerina.types.SemType;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.subtypedata.AllOrNothingSubtype;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.StringJoiner;

public class DecimalSubtype
extends EnumerableSubtype
implements ProperSubtypeData {
    public boolean allowed;
    public EnumerableDecimal[] values;

    private DecimalSubtype(boolean allowed, EnumerableDecimal value2) {
        this(allowed, new EnumerableDecimal[]{value2});
    }

    private DecimalSubtype(boolean allowed, EnumerableDecimal[] values) {
        this.allowed = allowed;
        this.values = values;
    }

    public static SemType decimalConst(BigDecimal value2) {
        return PredefinedType.basicSubtype(BasicTypeCode.BT_DECIMAL, new DecimalSubtype(true, EnumerableDecimal.from(value2)));
    }

    public static Optional<BigDecimal> decimalSubtypeSingleValue(SubtypeData d) {
        if (d instanceof AllOrNothingSubtype) {
            return Optional.empty();
        }
        DecimalSubtype f = (DecimalSubtype)d;
        if (!f.allowed) {
            return Optional.empty();
        }
        EnumerableDecimal[] values = f.values;
        if (values.length != 1) {
            return Optional.empty();
        }
        return Optional.of(values[0].value);
    }

    public static boolean decimalSubtypeContains(SubtypeData d, EnumerableDecimal f) {
        if (d instanceof AllOrNothingSubtype) {
            AllOrNothingSubtype allOrNothingSubtype = (AllOrNothingSubtype)d;
            return allOrNothingSubtype.isAllSubtype();
        }
        DecimalSubtype v = (DecimalSubtype)d;
        for (EnumerableDecimal val2 : v.values) {
            if (!((Object)val2).equals(f)) continue;
            return v.allowed;
        }
        return !v.allowed;
    }

    public static SubtypeData createDecimalSubtype(boolean allowed, EnumerableDecimal[] values) {
        if (values.length == 0) {
            return allowed ? AllOrNothingSubtype.createNothing() : AllOrNothingSubtype.createAll();
        }
        return new DecimalSubtype(allowed, values);
    }

    @Override
    public boolean allowed() {
        return this.allowed;
    }

    @Override
    public EnumerableType[] values() {
        return this.values;
    }

    public String toString() {
        StringJoiner j = new StringJoiner(", ", "DecimalSubtype:" + (this.allowed ? "allowed[" : "disallowed["), "]");
        for (EnumerableDecimal value2 : this.values) {
            j.add(String.valueOf(value2.value));
        }
        return j.toString();
    }
}

