/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.subtypedata;

import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.EnumerableFloat;
import io.ballerina.types.EnumerableSubtype;
import io.ballerina.types.EnumerableType;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.ProperSubtypeData;
import io.ballerina.types.SemType;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.subtypedata.AllOrNothingSubtype;
import java.util.Optional;
import java.util.StringJoiner;

public class FloatSubtype
extends EnumerableSubtype
implements ProperSubtypeData {
    public boolean allowed;
    public EnumerableFloat[] values;

    private FloatSubtype(boolean allowed, EnumerableFloat value2) {
        this(allowed, new EnumerableFloat[]{value2});
    }

    private FloatSubtype(boolean allowed, EnumerableFloat[] values) {
        this.allowed = allowed;
        this.values = values;
    }

    public static SemType floatConst(double value2) {
        return PredefinedType.basicSubtype(BasicTypeCode.BT_FLOAT, new FloatSubtype(true, EnumerableFloat.from(value2)));
    }

    public static Optional<Double> floatSubtypeSingleValue(SubtypeData d) {
        if (d instanceof AllOrNothingSubtype) {
            return Optional.empty();
        }
        FloatSubtype f = (FloatSubtype)d;
        if (!f.allowed) {
            return Optional.empty();
        }
        EnumerableFloat[] values = f.values;
        if (values.length != 1) {
            return Optional.empty();
        }
        return Optional.of(values[0].value);
    }

    public static boolean floatSubtypeContains(SubtypeData d, EnumerableFloat f) {
        if (d instanceof AllOrNothingSubtype) {
            AllOrNothingSubtype allOrNothingSubtype = (AllOrNothingSubtype)d;
            return allOrNothingSubtype.isAllSubtype();
        }
        FloatSubtype v = (FloatSubtype)d;
        for (EnumerableFloat val2 : v.values) {
            if (!((Object)val2).equals(f)) continue;
            return v.allowed;
        }
        return !v.allowed;
    }

    public static SubtypeData createFloatSubtype(boolean allowed, EnumerableFloat[] values) {
        if (values.length == 0) {
            return allowed ? AllOrNothingSubtype.createNothing() : AllOrNothingSubtype.createAll();
        }
        return new FloatSubtype(allowed, values);
    }

    @Override
    public boolean allowed() {
        return this.allowed;
    }

    @Override
    public EnumerableType[] values() {
        return this.values;
    }

    public String toString() {
        StringJoiner j = new StringJoiner(", ", "FloatSubtype:" + (this.allowed ? "allowed[" : "disallowed["), "]");
        for (EnumerableFloat value2 : this.values) {
            j.add(String.valueOf(value2.value));
        }
        return j.toString();
    }
}

