/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.subtypedata;

import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.EnumerableCharString;
import io.ballerina.types.EnumerableString;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.ProperSubtypeData;
import io.ballerina.types.SemType;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.subtypedata.AllOrNothingSubtype;
import io.ballerina.types.subtypedata.CharStringSubtype;
import io.ballerina.types.subtypedata.NonCharStringSubtype;
import java.util.Arrays;
import java.util.Optional;

public class StringSubtype
implements ProperSubtypeData {
    private static final EnumerableString[] EMPTY_STRING_ARR = new EnumerableString[0];
    private static final EnumerableCharString[] EMPTY_CHAR_ARR = new EnumerableCharString[0];
    CharStringSubtype charData;
    NonCharStringSubtype nonCharData;

    public CharStringSubtype getChar() {
        return this.charData;
    }

    public NonCharStringSubtype getNonChar() {
        return this.nonCharData;
    }

    private StringSubtype(CharStringSubtype charData, NonCharStringSubtype nonCharData) {
        this.charData = charData;
        this.nonCharData = nonCharData;
    }

    public static StringSubtype from(CharStringSubtype chara, NonCharStringSubtype nonChar) {
        return new StringSubtype(chara, nonChar);
    }

    public static boolean stringSubtypeContains(SubtypeData d, String s) {
        if (d instanceof AllOrNothingSubtype) {
            AllOrNothingSubtype allOrNothingSubtype = (AllOrNothingSubtype)d;
            return allOrNothingSubtype.isAllSubtype();
        }
        StringSubtype st = (StringSubtype)d;
        CharStringSubtype chara = st.charData;
        NonCharStringSubtype nonChar = st.nonCharData;
        if (s.length() == 1) {
            return Arrays.asList(chara.values).contains(EnumerableCharString.from(s)) == chara.allowed;
        }
        return Arrays.asList(nonChar.values).contains(EnumerableString.from(s)) == nonChar.allowed;
    }

    public static SubtypeData createStringSubtype(CharStringSubtype chara, NonCharStringSubtype nonChar) {
        if (chara.values.length == 0 && nonChar.values.length == 0) {
            if (!chara.allowed && !nonChar.allowed) {
                return AllOrNothingSubtype.createAll();
            }
            if (chara.allowed && nonChar.allowed) {
                return AllOrNothingSubtype.createNothing();
            }
        }
        return StringSubtype.from(chara, nonChar);
    }

    public static Optional<String> stringSubtypeSingleValue(SubtypeData d) {
        int nonCharCount;
        if (d instanceof AllOrNothingSubtype) {
            return Optional.empty();
        }
        StringSubtype st = (StringSubtype)d;
        CharStringSubtype chara = st.charData;
        NonCharStringSubtype nonChar = st.nonCharData;
        int charCount = chara.allowed ? chara.values.length : 2;
        int n = nonCharCount = nonChar.allowed ? nonChar.values.length : 2;
        if (charCount + nonCharCount == 1) {
            return charCount != 0 ? Optional.of(chara.values[0].value) : Optional.of(nonChar.values[0].value);
        }
        return Optional.empty();
    }

    public static SemType stringConst(String value2) {
        NonCharStringSubtype nonChar;
        CharStringSubtype chara;
        if (value2.codePointCount(0, value2.length()) == 1) {
            chara = CharStringSubtype.from(true, new EnumerableCharString[]{EnumerableCharString.from(value2)});
            nonChar = NonCharStringSubtype.from(true, EMPTY_STRING_ARR);
        } else {
            chara = CharStringSubtype.from(true, EMPTY_CHAR_ARR);
            nonChar = NonCharStringSubtype.from(true, new EnumerableString[]{EnumerableString.from(value2)});
        }
        return PredefinedType.basicSubtype(BasicTypeCode.BT_STRING, new StringSubtype(chara, nonChar));
    }

    public static SemType stringChar() {
        StringSubtype st = new StringSubtype(CharStringSubtype.from(false, EMPTY_CHAR_ARR), NonCharStringSubtype.from(true, EMPTY_STRING_ARR));
        return PredefinedType.basicSubtype(BasicTypeCode.BT_STRING, st);
    }

    public static class StringSubtypeListCoverage {
        public final boolean isSubtype;
        public final int[] indices;

        public StringSubtypeListCoverage(boolean isSubtype, int[] indices) {
            this.isSubtype = isSubtype;
            this.indices = indices;
        }

        public static StringSubtypeListCoverage from(boolean isSubtype, int[] indices) {
            return new StringSubtypeListCoverage(isSubtype, indices);
        }
    }
}

