/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.subtypedata;

import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.Bdd;
import io.ballerina.types.ComplexSemType;
import io.ballerina.types.Core;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.ProperSubtypeData;
import io.ballerina.types.RecAtom;
import io.ballerina.types.SemType;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.subtypedata.AllOrNothingSubtype;
import io.ballerina.types.subtypedata.BddAllOrNothing;
import io.ballerina.types.typeops.BddCommonOps;

public class XmlSubtype
implements ProperSubtypeData {
    public final int primitives;
    public final Bdd sequence;
    public static final int XML_PRIMITIVE_NEVER = 1;
    public static final int XML_PRIMITIVE_TEXT = 2;
    public static final int XML_PRIMITIVE_ELEMENT_RO = 4;
    public static final int XML_PRIMITIVE_PI_RO = 8;
    public static final int XML_PRIMITIVE_COMMENT_RO = 16;
    public static final int XML_PRIMITIVE_ELEMENT_RW = 32;
    public static final int XML_PRIMITIVE_PI_RW = 64;
    public static final int XML_PRIMITIVE_COMMENT_RW = 128;
    public static final int XML_PRIMITIVE_RO_SINGLETON = 30;
    public static final int XML_PRIMITIVE_RO_MASK = 31;
    public static final int XML_PRIMITIVE_RW_MASK = 224;
    public static final int XML_PRIMITIVE_SINGLETON = 254;
    public static final int XML_PRIMITIVE_ALL_MASK = 255;

    private XmlSubtype(int primitives, Bdd sequence) {
        this.primitives = primitives;
        this.sequence = sequence;
    }

    public static XmlSubtype from(int primitives, Bdd sequence) {
        return new XmlSubtype(primitives, sequence);
    }

    public static SemType xmlSingleton(int primitives) {
        return XmlSubtype.createXmlSemtype(XmlSubtype.createXmlSubtype(primitives, BddAllOrNothing.bddNothing()));
    }

    public static SemType xmlSequence(SemType constituentType) {
        assert (Core.isSubtypeSimple(constituentType, PredefinedType.XML));
        if (Core.isNever(constituentType)) {
            return XmlSubtype.xmlSequence(XmlSubtype.xmlSingleton(1));
        }
        if (constituentType instanceof BasicTypeBitSet) {
            return constituentType;
        }
        ComplexSemType cct = (ComplexSemType)constituentType;
        SubtypeData xmlSubtype = Core.getComplexSubtypeData(cct, BasicTypeCode.BT_XML);
        xmlSubtype = xmlSubtype instanceof AllOrNothingSubtype ? xmlSubtype : XmlSubtype.makeXmlSequence((XmlSubtype)xmlSubtype);
        return XmlSubtype.createXmlSemtype(xmlSubtype);
    }

    private static SubtypeData makeXmlSequence(XmlSubtype d) {
        int primitives = 1 | d.primitives;
        int atom = d.primitives & 0xFE;
        Bdd sequence = BddCommonOps.bddUnion(BddCommonOps.bddAtom(RecAtom.createXMLRecAtom(atom)), d.sequence);
        return XmlSubtype.createXmlSubtype(primitives, sequence);
    }

    public static SemType createXmlSemtype(SubtypeData xmlSubtype) {
        if (xmlSubtype instanceof AllOrNothingSubtype) {
            AllOrNothingSubtype allOrNothingSubtype = (AllOrNothingSubtype)xmlSubtype;
            return allOrNothingSubtype.isAllSubtype() ? PredefinedType.XML : PredefinedType.NEVER;
        }
        return PredefinedType.basicSubtype(BasicTypeCode.BT_XML, (ProperSubtypeData)xmlSubtype);
    }

    public static SubtypeData createXmlSubtype(int primitives, Bdd sequence) {
        BddAllOrNothing allOrNothing;
        int p = primitives & 0xFF;
        if (sequence instanceof BddAllOrNothing && (allOrNothing = (BddAllOrNothing)sequence).isAll() && p == 255) {
            return AllOrNothingSubtype.createAll();
        }
        return XmlSubtype.createXmlSubtypeOrEmpty(p, sequence);
    }

    public static SubtypeData createXmlSubtypeOrEmpty(int primitives, Bdd sequence) {
        BddAllOrNothing allOrNothing;
        if (sequence instanceof BddAllOrNothing && (allOrNothing = (BddAllOrNothing)sequence).isNothing() && primitives == 0) {
            return AllOrNothingSubtype.createNothing();
        }
        return XmlSubtype.from(primitives, sequence);
    }
}

