/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.typeops;

import io.ballerina.types.Atom;
import io.ballerina.types.Bdd;
import io.ballerina.types.RecAtom;
import io.ballerina.types.subtypedata.BddAllOrNothing;
import io.ballerina.types.subtypedata.BddNode;
import java.util.HashMap;
import java.util.Map;

public abstract class BddCommonOps {
    public static BddNode bddAtom(Atom atom) {
        return BddNode.create(atom, BddAllOrNothing.bddAll(), BddAllOrNothing.bddNothing(), BddAllOrNothing.bddNothing());
    }

    public static Bdd bddUnion(Bdd b1, Bdd b2) {
        return BddCommonOps.bddUnionWithMemo(BddOpMemo.create(), b1, b2);
    }

    private static Bdd bddUnionWithMemo(BddOpMemo memoTable, Bdd b1, Bdd b2) {
        BddOpMemoKey key = new BddOpMemoKey(b1, b2);
        Bdd memoized = memoTable.unionMemo.get(key);
        if (memoized != null) {
            return memoized;
        }
        memoized = BddCommonOps.bddUnionInner(memoTable, b1, b2);
        memoTable.unionMemo.put(key, memoized);
        return memoized;
    }

    private static Bdd bddUnionInner(BddOpMemo memo, Bdd b1, Bdd b2) {
        if (b1 == b2) {
            return b1;
        }
        if (b1 instanceof BddAllOrNothing) {
            return ((BddAllOrNothing)b1).isAll() ? BddAllOrNothing.bddAll() : b2;
        }
        if (b2 instanceof BddAllOrNothing) {
            return ((BddAllOrNothing)b2).isAll() ? BddAllOrNothing.bddAll() : b1;
        }
        BddNode b1Bdd = (BddNode)b1;
        BddNode b2Bdd = (BddNode)b2;
        long cmp = BddCommonOps.atomCmp(b1Bdd.atom(), b2Bdd.atom());
        if (cmp < 0L) {
            return BddCommonOps.bddCreate(b1Bdd.atom(), b1Bdd.left(), BddCommonOps.bddUnionWithMemo(memo, b1Bdd.middle(), b2), b1Bdd.right());
        }
        if (cmp > 0L) {
            return BddCommonOps.bddCreate(b2Bdd.atom(), b2Bdd.left(), BddCommonOps.bddUnionWithMemo(memo, b1, b2Bdd.middle()), b2Bdd.right());
        }
        return BddCommonOps.bddCreate(b1Bdd.atom(), BddCommonOps.bddUnionWithMemo(memo, b1Bdd.left(), b2Bdd.left()), BddCommonOps.bddUnionWithMemo(memo, b1Bdd.middle(), b2Bdd.middle()), BddCommonOps.bddUnionWithMemo(memo, b1Bdd.right(), b2Bdd.right()));
    }

    public static Bdd bddIntersect(Bdd b1, Bdd b2) {
        return BddCommonOps.bddIntersectWithMemo(BddOpMemo.create(), b1, b2);
    }

    private static Bdd bddIntersectWithMemo(BddOpMemo memo, Bdd b1, Bdd b2) {
        BddOpMemoKey key = new BddOpMemoKey(b1, b2);
        Bdd memoized = memo.intersectionMemo.get(key);
        if (memoized != null) {
            return memoized;
        }
        memoized = BddCommonOps.bddIntersectInner(memo, b1, b2);
        memo.intersectionMemo.put(key, memoized);
        return memoized;
    }

    private static Bdd bddIntersectInner(BddOpMemo memo, Bdd b1, Bdd b2) {
        if (b1 == b2) {
            return b1;
        }
        if (b1 instanceof BddAllOrNothing) {
            return ((BddAllOrNothing)b1).isAll() ? b2 : BddAllOrNothing.bddNothing();
        }
        if (b2 instanceof BddAllOrNothing) {
            return ((BddAllOrNothing)b2).isAll() ? b1 : BddAllOrNothing.bddNothing();
        }
        BddNode b1Bdd = (BddNode)b1;
        BddNode b2Bdd = (BddNode)b2;
        long cmp = BddCommonOps.atomCmp(b1Bdd.atom(), b2Bdd.atom());
        if (cmp < 0L) {
            return BddCommonOps.bddCreate(b1Bdd.atom(), BddCommonOps.bddIntersectWithMemo(memo, b1Bdd.left(), b2), BddCommonOps.bddIntersectWithMemo(memo, b1Bdd.middle(), b2), BddCommonOps.bddIntersectWithMemo(memo, b1Bdd.right(), b2));
        }
        if (cmp > 0L) {
            return BddCommonOps.bddCreate(b2Bdd.atom(), BddCommonOps.bddIntersectWithMemo(memo, b1, b2Bdd.left()), BddCommonOps.bddIntersectWithMemo(memo, b1, b2Bdd.middle()), BddCommonOps.bddIntersectWithMemo(memo, b1, b2Bdd.right()));
        }
        return BddCommonOps.bddCreate(b1Bdd.atom(), BddCommonOps.bddIntersectWithMemo(memo, BddCommonOps.bddUnionWithMemo(memo, b1Bdd.left(), b1Bdd.middle()), BddCommonOps.bddUnionWithMemo(memo, b2Bdd.left(), b2Bdd.middle())), BddAllOrNothing.bddNothing(), BddCommonOps.bddIntersectWithMemo(memo, BddCommonOps.bddUnionWithMemo(memo, b1Bdd.right(), b1Bdd.middle()), BddCommonOps.bddUnionWithMemo(memo, b2Bdd.right(), b2Bdd.middle())));
    }

    public static Bdd bddDiff(Bdd b1, Bdd b2) {
        return BddCommonOps.bddDiffWithMemo(BddOpMemo.create(), b1, b2);
    }

    private static Bdd bddDiffWithMemo(BddOpMemo memo, Bdd b1, Bdd b2) {
        BddOpMemoKey key = new BddOpMemoKey(b1, b2);
        Bdd memoized = memo.diffMemo.get(key);
        if (memoized != null) {
            return memoized;
        }
        memoized = BddCommonOps.bddDiffInner(memo, b1, b2);
        memo.diffMemo.put(key, memoized);
        return memoized;
    }

    private static Bdd bddDiffInner(BddOpMemo memo, Bdd b1, Bdd b2) {
        if (b1 == b2) {
            return BddAllOrNothing.bddNothing();
        }
        if (b2 instanceof BddAllOrNothing) {
            BddAllOrNothing allOrNothing = (BddAllOrNothing)b2;
            return allOrNothing.isAll() ? BddAllOrNothing.bddNothing() : b1;
        }
        if (b1 instanceof BddAllOrNothing) {
            BddAllOrNothing allOrNothing = (BddAllOrNothing)b1;
            return allOrNothing.isAll() ? BddCommonOps.bddComplement(b2) : BddAllOrNothing.bddNothing();
        }
        BddNode b1Bdd = (BddNode)b1;
        BddNode b2Bdd = (BddNode)b2;
        long cmp = BddCommonOps.atomCmp(b1Bdd.atom(), b2Bdd.atom());
        if (cmp < 0L) {
            return BddCommonOps.bddCreate(b1Bdd.atom(), BddCommonOps.bddDiffWithMemo(memo, BddCommonOps.bddUnionWithMemo(memo, b1Bdd.left(), b1Bdd.middle()), b2), BddAllOrNothing.bddNothing(), BddCommonOps.bddDiffWithMemo(memo, BddCommonOps.bddUnionWithMemo(memo, b1Bdd.right(), b1Bdd.middle()), b2));
        }
        if (cmp > 0L) {
            return BddCommonOps.bddCreate(b2Bdd.atom(), BddCommonOps.bddDiffWithMemo(memo, b1, BddCommonOps.bddUnionWithMemo(memo, b2Bdd.left(), b2Bdd.middle())), BddAllOrNothing.bddNothing(), BddCommonOps.bddDiffWithMemo(memo, b1, BddCommonOps.bddUnionWithMemo(memo, b2Bdd.right(), b2Bdd.middle())));
        }
        return BddCommonOps.bddCreate(b1Bdd.atom(), BddCommonOps.bddDiffWithMemo(memo, BddCommonOps.bddUnionWithMemo(memo, b1Bdd.left(), b1Bdd.middle()), BddCommonOps.bddUnionWithMemo(memo, b2Bdd.left(), b2Bdd.middle())), BddAllOrNothing.bddNothing(), BddCommonOps.bddDiffWithMemo(memo, BddCommonOps.bddUnionWithMemo(memo, b1Bdd.right(), b1Bdd.middle()), BddCommonOps.bddUnionWithMemo(memo, b2Bdd.right(), b2Bdd.middle())));
    }

    public static Bdd bddComplement(Bdd b) {
        if (b instanceof BddAllOrNothing) {
            return ((BddAllOrNothing)b).complement();
        }
        return BddCommonOps.bddNodeComplement((BddNode)b);
    }

    public static Bdd bddNodeComplement(BddNode b) {
        BddAllOrNothing bddNothing = BddAllOrNothing.bddNothing();
        if (b.right().equals(bddNothing)) {
            return BddCommonOps.bddCreate(b.atom(), bddNothing, BddCommonOps.bddComplement(BddCommonOps.bddUnion(b.left(), b.middle())), BddCommonOps.bddComplement(b.middle()));
        }
        if (b.left().equals(bddNothing)) {
            return BddCommonOps.bddCreate(b.atom(), BddCommonOps.bddComplement(b.middle()), BddCommonOps.bddComplement(BddCommonOps.bddUnion(b.right(), b.middle())), bddNothing);
        }
        if (b.middle().equals(bddNothing)) {
            return BddCommonOps.bddCreate(b.atom(), BddCommonOps.bddComplement(b.left()), BddCommonOps.bddComplement(BddCommonOps.bddUnion(b.left(), b.right())), BddCommonOps.bddComplement(b.right()));
        }
        return BddCommonOps.bddCreate(b.atom(), BddCommonOps.bddComplement(BddCommonOps.bddUnion(b.left(), b.middle())), bddNothing, BddCommonOps.bddComplement(BddCommonOps.bddUnion(b.right(), b.middle())));
    }

    public static Bdd bddCreate(Atom atom, Bdd left, Bdd middle, Bdd right) {
        if (middle instanceof BddAllOrNothing && ((BddAllOrNothing)middle).isAll()) {
            return middle;
        }
        if (left.equals(right)) {
            return BddCommonOps.bddUnion(left, right);
        }
        return BddNode.create(atom, left, middle, right);
    }

    public static long atomCmp(Atom a1, Atom a2) {
        if (a1 instanceof RecAtom) {
            RecAtom r1 = (RecAtom)a1;
            if (a2 instanceof RecAtom) {
                RecAtom r2 = (RecAtom)a2;
                return r1.index() - r2.index();
            }
            return -1L;
        }
        if (a2 instanceof RecAtom) {
            return 1L;
        }
        return a1.index() - a2.index();
    }

    public static String bddToString(Bdd b, boolean inner) {
        if (b instanceof BddAllOrNothing) {
            return ((BddAllOrNothing)b).isAll() ? "1" : "0";
        }
        BddNode bdd = (BddNode)b;
        Atom a = bdd.atom();
        String str = a instanceof RecAtom ? "r" + String.valueOf(a) : "a" + a.index();
        str = str + "?" + BddCommonOps.bddToString(bdd.left(), true) + ":" + BddCommonOps.bddToString(bdd.middle(), true) + ":" + BddCommonOps.bddToString(bdd.right(), true);
        if (inner) {
            str = "(" + str + ")";
        }
        return str;
    }

    private record BddOpMemo(Map<BddOpMemoKey, Bdd> unionMemo, Map<BddOpMemoKey, Bdd> intersectionMemo, Map<BddOpMemoKey, Bdd> diffMemo) {
        static BddOpMemo create() {
            return new BddOpMemo(new HashMap<BddOpMemoKey, Bdd>(), new HashMap<BddOpMemoKey, Bdd>(), new HashMap<BddOpMemoKey, Bdd>());
        }
    }

    private record BddOpMemoKey(Bdd b1, Bdd b2) {
    }
}

