/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.typeops;

import io.ballerina.types.BasicTypeOps;
import io.ballerina.types.Bdd;
import io.ballerina.types.CellAtomicType;
import io.ballerina.types.Common;
import io.ballerina.types.Conjunction;
import io.ballerina.types.Context;
import io.ballerina.types.Core;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.ProperSubtypeData;
import io.ballerina.types.SemType;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.TypeAtom;
import io.ballerina.types.subtypedata.AllOrNothingSubtype;
import io.ballerina.types.typeops.BddCommonOps;
import io.ballerina.types.typeops.CommonOps;
import java.util.Collections;
import java.util.EnumSet;

public class CellOps
extends CommonOps
implements BasicTypeOps {
    private static boolean cellFormulaIsEmpty(Context cx, SubtypeData t) {
        return Common.bddEvery(cx, (Bdd)t, null, null, CellOps::cellFormulaIsEmpty);
    }

    private static boolean cellFormulaIsEmpty(Context cx, Conjunction posList, Conjunction negList) {
        CellAtomicType combined;
        if (posList == null) {
            combined = CellAtomicType.from(PredefinedType.VAL, CellAtomicType.CellMutability.CELL_MUT_UNLIMITED);
        } else {
            combined = Core.cellAtomType(posList.atom);
            Conjunction p = posList.next;
            while (p != null) {
                combined = CellOps.intersectCellAtomicType(combined, Core.cellAtomType(p.atom));
                p = p.next;
            }
        }
        return !CellOps.cellInhabited(cx, combined, negList);
    }

    private static boolean cellInhabited(Context cx, CellAtomicType posCell, Conjunction negList) {
        SemType pos = posCell.ty();
        if (Core.isEmpty(cx, pos)) {
            return false;
        }
        return switch (posCell.mut()) {
            case CellAtomicType.CellMutability.CELL_MUT_NONE -> CellOps.cellMutNoneInhabited(cx, pos, negList);
            case CellAtomicType.CellMutability.CELL_MUT_LIMITED -> CellOps.cellMutLimitedInhabited(cx, pos, negList);
            default -> CellOps.cellMutUnlimitedInhabited(cx, pos, negList);
        };
    }

    private static boolean cellMutNoneInhabited(Context cx, SemType pos, Conjunction negList) {
        SemType negListUnionResult = CellOps.cellNegListUnion(negList);
        return Core.isNever(negListUnionResult) || !Core.isEmpty(cx, Core.diff(pos, negListUnionResult));
    }

    private static SemType cellNegListUnion(Conjunction negList) {
        SemType negUnion = PredefinedType.NEVER;
        Conjunction neg = negList;
        while (neg != null) {
            negUnion = Core.union(negUnion, Core.cellAtomType(neg.atom).ty());
            neg = neg.next;
        }
        return negUnion;
    }

    private static boolean cellMutLimitedInhabited(Context cx, SemType pos, Conjunction negList) {
        if (negList == null) {
            return true;
        }
        CellAtomicType negAtomicCell = Core.cellAtomType(negList.atom);
        if (negAtomicCell.mut().compareTo(CellAtomicType.CellMutability.CELL_MUT_LIMITED) >= 0 && Core.isEmpty(cx, Core.diff(pos, negAtomicCell.ty()))) {
            return false;
        }
        return CellOps.cellMutLimitedInhabited(cx, pos, negList.next);
    }

    private static boolean cellMutUnlimitedInhabited(Context cx, SemType pos, Conjunction negList) {
        Conjunction neg = negList;
        while (neg != null) {
            if (Core.cellAtomType(neg.atom).mut() == CellAtomicType.CellMutability.CELL_MUT_LIMITED && Core.isSameType(cx, PredefinedType.VAL, Core.cellAtomType(neg.atom).ty())) {
                return false;
            }
            neg = neg.next;
        }
        SemType negListUnionResult = CellOps.cellNegListUnlimitedUnion(negList);
        return Core.isNever(negListUnionResult) || !Core.isEmpty(cx, Core.diff(pos, negListUnionResult));
    }

    private static SemType cellNegListUnlimitedUnion(Conjunction negList) {
        SemType negUnion = PredefinedType.NEVER;
        Conjunction neg = negList;
        while (neg != null) {
            if (Core.cellAtomType(neg.atom).mut() == CellAtomicType.CellMutability.CELL_MUT_UNLIMITED) {
                negUnion = Core.union(negUnion, Core.cellAtomType(neg.atom).ty());
            }
            neg = neg.next;
        }
        return negUnion;
    }

    public static CellAtomicType intersectCellAtomicType(CellAtomicType c1, CellAtomicType c2) {
        SemType ty = Core.intersect(c1.ty(), c2.ty());
        CellAtomicType.CellMutability mut = Collections.min(EnumSet.of(c1.mut(), c2.mut()));
        return CellAtomicType.from(ty, mut);
    }

    private static ProperSubtypeData cellSubtypeUnion(SubtypeData t1, SubtypeData t2) {
        return CellOps.cellSubtypeDataEnsureProper(Common.bddSubtypeUnion(t1, t2));
    }

    private static ProperSubtypeData cellSubtypeIntersect(SubtypeData t1, SubtypeData t2) {
        return CellOps.cellSubtypeDataEnsureProper(Common.bddSubtypeIntersect(t1, t2));
    }

    private static ProperSubtypeData cellSubtypeDiff(SubtypeData t1, SubtypeData t2) {
        return CellOps.cellSubtypeDataEnsureProper(Common.bddSubtypeDiff(t1, t2));
    }

    private static ProperSubtypeData cellSubtypeComplement(SubtypeData t) {
        return CellOps.cellSubtypeDataEnsureProper(Common.bddSubtypeComplement(t));
    }

    private static ProperSubtypeData cellSubtypeDataEnsureProper(SubtypeData subtypeData) {
        if (subtypeData instanceof AllOrNothingSubtype) {
            AllOrNothingSubtype allOrNothingSubtype = (AllOrNothingSubtype)subtypeData;
            TypeAtom atom = allOrNothingSubtype.isAllSubtype() ? PredefinedType.ATOM_CELL_VAL : PredefinedType.ATOM_CELL_NEVER;
            return BddCommonOps.bddAtom(atom);
        }
        return (ProperSubtypeData)subtypeData;
    }

    @Override
    public SubtypeData union(SubtypeData t1, SubtypeData t2) {
        return CellOps.cellSubtypeUnion(t1, t2);
    }

    @Override
    public SubtypeData intersect(SubtypeData t1, SubtypeData t2) {
        return CellOps.cellSubtypeIntersect(t1, t2);
    }

    @Override
    public SubtypeData diff(SubtypeData t1, SubtypeData t2) {
        return CellOps.cellSubtypeDiff(t1, t2);
    }

    @Override
    public SubtypeData complement(SubtypeData t) {
        return CellOps.cellSubtypeComplement(t);
    }

    @Override
    public boolean isEmpty(Context cx, SubtypeData t) {
        return CellOps.cellFormulaIsEmpty(cx, t);
    }
}

