/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.typeops;

import io.ballerina.types.CellSemType;
import io.ballerina.types.Common;
import io.ballerina.types.MappingAtomicType;
import io.ballerina.types.typeops.FieldPair;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;

public class MappingPairIterator
implements Iterator<FieldPair> {
    private final String[] names1;
    private final String[] names2;
    private final CellSemType[] types1;
    private final CellSemType[] types2;
    private final int len1;
    private final int len2;
    private int i1 = 0;
    private int i2 = 0;
    private final CellSemType rest1;
    private final CellSemType rest2;
    private boolean doneIteration = false;
    private boolean shouldCalculate = true;
    private FieldPair cache = null;

    public MappingPairIterator(MappingAtomicType m1, MappingAtomicType m2) {
        this.names1 = m1.names();
        this.len1 = this.names1.length;
        this.types1 = m1.types();
        this.rest1 = m1.rest();
        this.names2 = m2.names();
        this.len2 = this.names2.length;
        this.types2 = m2.types();
        this.rest2 = m2.rest();
    }

    @Override
    public boolean hasNext() {
        if (this.doneIteration) {
            return false;
        }
        if (this.shouldCalculate) {
            FieldPair cache = this.internalNext();
            if (cache == null) {
                this.doneIteration = true;
            }
            this.cache = cache;
            this.shouldCalculate = false;
        }
        return !this.doneIteration;
    }

    @Override
    public FieldPair next() {
        if (this.doneIteration) {
            throw new NoSuchElementException("Exhausted iterator");
        }
        if (this.shouldCalculate) {
            FieldPair cache = this.internalNext();
            if (cache == null) {
                throw new IllegalStateException();
            }
            this.cache = cache;
        }
        this.shouldCalculate = true;
        return this.cache;
    }

    private FieldPair internalNext() {
        FieldPair p;
        if (this.i1 >= this.len1) {
            if (this.i2 >= this.len2) {
                return null;
            }
            p = FieldPair.create(this.curName2(), this.rest1, this.curType2(), null, this.i2);
            ++this.i2;
        } else if (this.i2 >= this.len2) {
            p = FieldPair.create(this.curName1(), this.curType1(), this.rest2, this.i1, null);
            ++this.i1;
        } else {
            String name2;
            String name1 = this.curName1();
            if (Common.codePointCompare(name1, name2 = this.curName2())) {
                p = FieldPair.create(name1, this.curType1(), this.rest2, this.i1, null);
                ++this.i1;
            } else if (Common.codePointCompare(name2, name1)) {
                p = FieldPair.create(name2, this.rest1, this.curType2(), null, this.i2);
                ++this.i2;
            } else {
                p = FieldPair.create(name1, this.curType1(), this.curType2(), this.i1, this.i2);
                ++this.i1;
                ++this.i2;
            }
        }
        return p;
    }

    private CellSemType curType1() {
        return this.types1[this.i1];
    }

    private String curName1() {
        return this.names1[this.i1];
    }

    private CellSemType curType2() {
        return this.types2[this.i2];
    }

    private String curName2() {
        return this.names2[this.i2];
    }

    public void reset() {
        this.i1 = 0;
        this.i2 = 0;
    }

    public Optional<Integer> index1(String name) {
        int i1Prev = this.i1 - 1;
        return i1Prev >= 0 && Objects.equals(this.names1[i1Prev], name) ? Optional.of(i1Prev) : Optional.empty();
    }
}

