/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.typeops;

import io.ballerina.types.BasicTypeOps;
import io.ballerina.types.Common;
import io.ballerina.types.Context;
import io.ballerina.types.EnumerableCharString;
import io.ballerina.types.EnumerableString;
import io.ballerina.types.EnumerableSubtype;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.subtypedata.AllOrNothingSubtype;
import io.ballerina.types.subtypedata.CharStringSubtype;
import io.ballerina.types.subtypedata.NonCharStringSubtype;
import io.ballerina.types.subtypedata.StringSubtype;
import java.util.ArrayList;
import java.util.List;

public class StringOps
implements BasicTypeOps {
    @Override
    public SubtypeData union(SubtypeData d1, SubtypeData d2) {
        StringSubtype sd1 = (StringSubtype)d1;
        StringSubtype sd2 = (StringSubtype)d2;
        ArrayList chars = new ArrayList();
        ArrayList nonChars = new ArrayList();
        boolean charsAllowed = EnumerableSubtype.enumerableSubtypeUnion(sd1.getChar(), sd2.getChar(), chars);
        boolean nonCharsAllowed = EnumerableSubtype.enumerableSubtypeUnion(sd1.getNonChar(), sd2.getNonChar(), nonChars);
        return StringSubtype.createStringSubtype(CharStringSubtype.from(charsAllowed, chars.toArray(new EnumerableCharString[0])), NonCharStringSubtype.from(nonCharsAllowed, nonChars.toArray(new EnumerableString[0])));
    }

    @Override
    public SubtypeData intersect(SubtypeData d1, SubtypeData d2) {
        if (d1 instanceof AllOrNothingSubtype) {
            return ((AllOrNothingSubtype)d1).isAllSubtype() ? d2 : AllOrNothingSubtype.createNothing();
        }
        if (d2 instanceof AllOrNothingSubtype) {
            return ((AllOrNothingSubtype)d2).isAllSubtype() ? d1 : AllOrNothingSubtype.createNothing();
        }
        StringSubtype sd1 = (StringSubtype)d1;
        StringSubtype sd2 = (StringSubtype)d2;
        ArrayList chars = new ArrayList();
        ArrayList nonChars = new ArrayList();
        boolean charsAllowed = EnumerableSubtype.enumerableSubtypeIntersect(sd1.getChar(), sd2.getChar(), chars);
        boolean nonCharsAllowed = EnumerableSubtype.enumerableSubtypeIntersect(sd1.getNonChar(), sd2.getNonChar(), nonChars);
        return StringSubtype.createStringSubtype(CharStringSubtype.from(charsAllowed, chars.toArray(new EnumerableCharString[0])), NonCharStringSubtype.from(nonCharsAllowed, nonChars.toArray(new EnumerableString[0])));
    }

    @Override
    public SubtypeData diff(SubtypeData d1, SubtypeData d2) {
        return this.intersect(d1, this.complement(d2));
    }

    @Override
    public SubtypeData complement(SubtypeData d) {
        StringSubtype st = (StringSubtype)d;
        if (st.getChar().values.length == 0 && st.getNonChar().values.length == 0) {
            if (st.getChar().allowed && st.getNonChar().allowed) {
                return AllOrNothingSubtype.createAll();
            }
            if (!st.getChar().allowed && !st.getNonChar().allowed) {
                return AllOrNothingSubtype.createNothing();
            }
        }
        return StringSubtype.createStringSubtype(CharStringSubtype.from(!st.getChar().allowed, st.getChar().values), NonCharStringSubtype.from(!st.getNonChar().allowed, st.getNonChar().values));
    }

    @Override
    public boolean isEmpty(Context cx, SubtypeData t) {
        return Common.notIsEmpty(cx, t);
    }

    static StringSubtype.StringSubtypeListCoverage stringSubtypeListCoverage(StringSubtype subtype, String[] values) {
        int i2;
        ArrayList<Integer> indices = new ArrayList<Integer>();
        CharStringSubtype ch = subtype.getChar();
        NonCharStringSubtype nonChar = subtype.getNonChar();
        int stringConsts = 0;
        if (ch.allowed) {
            StringOps.stringListIntersect(values, StringOps.toStringArray(ch.values), indices);
            stringConsts = ch.values.length;
        } else if (ch.values.length == 0) {
            for (i2 = 0; i2 < values.length; ++i2) {
                if (values[i2].length() != 1) continue;
                indices.add(i2);
            }
        }
        if (nonChar.allowed) {
            StringOps.stringListIntersect(values, StringOps.toStringArray(nonChar.values), indices);
            stringConsts += nonChar.values.length;
        } else if (nonChar.values.length == 0) {
            for (i2 = 0; i2 < values.length; ++i2) {
                if (values[i2].length() == 1) continue;
                indices.add(i2);
            }
        }
        int[] inds = indices.stream().mapToInt(i -> i).toArray();
        return StringSubtype.StringSubtypeListCoverage.from(stringConsts == indices.size(), inds);
    }

    private static String[] toStringArray(EnumerableCharString[] ar) {
        String[] strings = new String[ar.length];
        for (int i = 0; i < ar.length; ++i) {
            strings[i] = ar[i].value;
        }
        return strings;
    }

    private static String[] toStringArray(EnumerableString[] ar) {
        String[] strings = new String[ar.length];
        for (int i = 0; i < ar.length; ++i) {
            strings[i] = ar[i].value;
        }
        return strings;
    }

    static void stringListIntersect(String[] values, String[] target, List<Integer> indices) {
        int i1 = 0;
        int i2 = 0;
        int len1 = values.length;
        int len2 = target.length;
        block5: while (i1 < len1 && i2 < len2) {
            int comp = EnumerableSubtype.compareEnumerable(EnumerableString.from(values[i1]), EnumerableString.from(target[i2]));
            switch (comp) {
                case 0: {
                    indices.add(i1);
                    ++i1;
                    ++i2;
                    continue block5;
                }
                case -1: {
                    ++i1;
                    continue block5;
                }
                case 1: {
                    ++i2;
                    continue block5;
                }
            }
            throw new AssertionError((Object)"Invalid comparison value!");
        }
    }
}

