/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.typeops;

import io.ballerina.types.BasicSubtype;
import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.ComplexSemType;
import io.ballerina.types.ProperSubtypeData;
import io.ballerina.types.SemType;
import io.ballerina.types.typeops.SubtypePair;
import io.ballerina.types.typeops.UnpackComplexSemType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class SubtypePairIterator
implements Iterator<SubtypePair> {
    private int i1 = 0;
    private int i2 = 0;
    private final List<BasicSubtype> t1;
    private final List<BasicSubtype> t2;
    private final BasicTypeBitSet bits;
    private boolean doneIteration = false;
    private boolean shouldCalculate = true;
    private SubtypePair cache = null;

    public SubtypePairIterator(SemType t1, SemType t2, BasicTypeBitSet bits) {
        this.t1 = this.unpackToBasicSubtypes(t1);
        this.t2 = this.unpackToBasicSubtypes(t2);
        this.bits = bits;
    }

    private List<BasicSubtype> unpackToBasicSubtypes(SemType type) {
        if (type instanceof BasicTypeBitSet) {
            return new ArrayList<BasicSubtype>();
        }
        return UnpackComplexSemType.unpack((ComplexSemType)type);
    }

    private boolean include(BasicTypeCode code) {
        return (this.bits.bitset & 1 << code.code) != 0;
    }

    private BasicSubtype get1() {
        return this.t1.get(this.i1);
    }

    private BasicSubtype get2() {
        return this.t2.get(this.i2);
    }

    @Override
    public boolean hasNext() {
        if (this.doneIteration) {
            return false;
        }
        if (this.shouldCalculate) {
            SubtypePair cache = this.internalNext();
            if (cache == null) {
                this.doneIteration = true;
            }
            this.cache = cache;
            this.shouldCalculate = false;
        }
        return !this.doneIteration;
    }

    @Override
    public SubtypePair next() {
        if (this.doneIteration) {
            throw new NoSuchElementException("Exhausted iterator");
        }
        if (this.shouldCalculate) {
            SubtypePair cache = this.internalNext();
            if (cache == null) {
                throw new IllegalStateException();
            }
            this.cache = cache;
        }
        this.shouldCalculate = true;
        return this.cache;
    }

    private SubtypePair internalNext() {
        block6: {
            ProperSubtypeData data2;
            BasicTypeCode code2;
            while (true) {
                ProperSubtypeData data1;
                BasicTypeCode code;
                BasicSubtype t;
                if (this.i1 >= this.t1.size()) {
                    if (this.i2 < this.t2.size()) {
                        t = this.get2();
                        code = t.basicTypeCode;
                        ProperSubtypeData data22 = t.subtypeData;
                        ++this.i2;
                        if (!this.include(code)) continue;
                        return SubtypePair.create(code, null, data22);
                    }
                    break block6;
                }
                if (this.i2 >= this.t2.size()) {
                    t = this.get1();
                    ++this.i1;
                    code = t.basicTypeCode;
                    data1 = t.subtypeData;
                    if (!this.include(code)) continue;
                    return SubtypePair.create(code, data1, null);
                }
                BasicSubtype t1 = this.get1();
                BasicTypeCode code1 = t1.basicTypeCode;
                data1 = t1.subtypeData;
                BasicSubtype t2 = this.get2();
                code2 = t2.basicTypeCode;
                data2 = t2.subtypeData;
                if (code1.code == code2.code) {
                    ++this.i1;
                    ++this.i2;
                    if (!this.include(code1)) continue;
                    return SubtypePair.create(code1, data1, data2);
                }
                if (code1.code < code2.code) {
                    ++this.i1;
                    if (!this.include(code1)) continue;
                    return SubtypePair.create(code1, data1, null);
                }
                ++this.i2;
                if (this.include(code2)) break;
            }
            return SubtypePair.create(code2, null, data2);
        }
        return null;
    }
}

