/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.c14n;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.c14n.CanonicalizerSpi;
import org.apache.axiom.c14n.exceptions.AlgorithmAlreadyRegisteredException;
import org.apache.axiom.c14n.exceptions.CanonicalizationException;
import org.apache.axiom.c14n.exceptions.InvalidCanonicalizerException;
import org.apache.axiom.c14n.omwrapper.factory.WrapperFactory;
import org.apache.axiom.om.OMElement;

public class Canonicalizer {
    public static final String ALGO_ID_C14N_OMIT_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String ALGO_ID_C14N_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String ALGO_ID_C14N_EXCL_OMIT_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String ALGO_ID_C14N_EXCL_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    static boolean _alreadyInitialized = false;
    static Map _canonicalizerHash = null;
    protected CanonicalizerSpi canonicalizerSpi = null;

    public static synchronized void init() {
        if (!_alreadyInitialized) {
            _canonicalizerHash = new HashMap(10);
            _alreadyInitialized = true;
        }
    }

    private Canonicalizer(String algorithmURI) throws InvalidCanonicalizerException {
        try {
            Class implementingClass = Canonicalizer.getImplementingClass(algorithmURI);
            this.canonicalizerSpi = (CanonicalizerSpi)implementingClass.newInstance();
            this.canonicalizerSpi.reset = true;
        }
        catch (Exception e) {
            Object[] exArgs = new Object[]{algorithmURI};
            throw new InvalidCanonicalizerException("c14n.Canonicalizer.UnknownCanonicalizer", exArgs);
        }
    }

    public static final synchronized Canonicalizer getInstance(String algorithmURI) throws InvalidCanonicalizerException {
        Canonicalizer canonicalizer = new Canonicalizer(algorithmURI);
        return canonicalizer;
    }

    public static synchronized void register(String algorithmURI, String implementingClass) throws AlgorithmAlreadyRegisteredException {
        Class registeredClass = Canonicalizer.getImplementingClass(algorithmURI);
        if (registeredClass != null) {
            Object[] exArgs = new Object[]{algorithmURI, registeredClass};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", exArgs);
        }
        try {
            _canonicalizerHash.put(algorithmURI, Class.forName(implementingClass));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(implementingClass + " not found");
        }
    }

    public final String getURI() {
        return this.canonicalizerSpi.engineGetURI();
    }

    public boolean getIncludeComments() {
        return this.canonicalizerSpi.engineGetIncludeComments();
    }

    public byte[] canonicalize(byte[] inputBytes) throws CanonicalizationException {
        return this.canonicalizerSpi.engineCanonicalize(inputBytes);
    }

    public byte[] canonicalizeSubtree(OMElement element) throws CanonicalizationException {
        return this.canonicalizerSpi.engineCanonicalizeSubTree(new WrapperFactory().getNode(element));
    }

    public byte[] canonicalizeSubtree(OMElement element, String inclusiveNamespaces) throws CanonicalizationException {
        return this.canonicalizerSpi.engineCanonicalizeSubTree(new WrapperFactory().getNode(element), inclusiveNamespaces);
    }

    public void setWriter(OutputStream os) {
        this.canonicalizerSpi.setWriter(os);
    }

    public String getImplementingCanonicalizerClass() {
        return this.canonicalizerSpi.getClass().getName();
    }

    private static Class getImplementingClass(String URI2) {
        return (Class)_canonicalizerHash.get(URI2);
    }

    public void notReset() {
        this.canonicalizerSpi.reset = false;
    }
}

