/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.stream;

import org.apache.axiom.core.stream.ConflictingNamespaceDeclarationException;
import org.apache.axiom.core.stream.NamespaceContextProvider;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.XmlHandlerWrapper;

public final class NamespaceRepairingFilterHandler
extends XmlHandlerWrapper {
    private final NamespaceContextProvider parentNamespaceContext;
    private final boolean removeRedundantDeclarations;
    private String[] namespaceStack = new String[32];
    private int bindings;
    private int[] scopeStack = new int[8];
    private int scopes;

    public NamespaceRepairingFilterHandler(XmlHandler parent, NamespaceContextProvider parentNamespaceContext, boolean removeRedundantDeclarations) {
        super(parent);
        this.parentNamespaceContext = parentNamespaceContext;
        this.removeRedundantDeclarations = removeRedundantDeclarations;
    }

    private void setPrefix(String prefix, String namespaceURI) {
        if (this.bindings * 2 == this.namespaceStack.length) {
            int len = this.namespaceStack.length;
            String[] newNamespaceStack = new String[len * 2];
            System.arraycopy(this.namespaceStack, 0, newNamespaceStack, 0, len);
            this.namespaceStack = newNamespaceStack;
        }
        this.namespaceStack[this.bindings * 2] = prefix;
        this.namespaceStack[this.bindings * 2 + 1] = namespaceURI;
        ++this.bindings;
    }

    private void ensureNamespaceDeclared(String prefix, String namespaceURI) throws StreamException {
        if (prefix.equals("xml") && namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return;
        }
        boolean prefixFound = false;
        for (int i = (this.bindings - 1) * 2; i >= 0; i -= 2) {
            if (!prefix.equals(this.namespaceStack[i])) continue;
            if (namespaceURI.equals(this.namespaceStack[i + 1])) {
                return;
            }
            prefixFound = true;
            break;
        }
        if (!prefixFound && this.parentNamespaceContext != null) {
            if (!this.parentNamespaceContext.isBound(prefix, namespaceURI)) {
                super.processNamespaceDeclaration(prefix, namespaceURI);
            }
            this.setPrefix(prefix, namespaceURI);
        } else if (prefixFound || !prefix.isEmpty() || !namespaceURI.isEmpty()) {
            super.processNamespaceDeclaration(prefix, namespaceURI);
            this.setPrefix(prefix, namespaceURI);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String prefix) throws StreamException {
        super.startElement(namespaceURI, localName, prefix);
        if (this.scopes == this.scopeStack.length) {
            int[] newScopeStack = new int[this.scopeStack.length * 2];
            System.arraycopy(this.scopeStack, 0, newScopeStack, 0, this.scopeStack.length);
            this.scopeStack = newScopeStack;
        }
        this.scopeStack[this.scopes++] = this.bindings;
        this.ensureNamespaceDeclared(prefix, namespaceURI);
    }

    @Override
    public void endElement() throws StreamException {
        this.bindings = this.scopeStack[--this.scopes];
        super.endElement();
    }

    @Override
    public void processAttribute(String namespaceURI, String localName, String prefix, String value2, String type, boolean specified) throws StreamException {
        super.processAttribute(namespaceURI, localName, prefix, value2, type, specified);
        if (!namespaceURI.isEmpty()) {
            this.ensureNamespaceDeclared(prefix, namespaceURI);
        }
    }

    @Override
    public void processNamespaceDeclaration(String prefix, String namespaceURI) throws StreamException {
        if (this.removeRedundantDeclarations) {
            this.ensureNamespaceDeclared(prefix, namespaceURI);
        } else {
            for (int i = this.scopeStack[this.scopes - 1]; i < this.bindings; ++i) {
                if (!this.namespaceStack[i * 2].equals(prefix)) continue;
                if (this.namespaceStack[i * 2 + 1].equals(namespaceURI)) {
                    return;
                }
                throw new ConflictingNamespaceDeclarationException("The same prefix cannot be bound to two different namespaces");
            }
            super.processNamespaceDeclaration(prefix, namespaceURI);
            this.setPrefix(prefix, namespaceURI);
        }
    }
}

