/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.stream.sax.input;

import java.io.IOException;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.XmlReader;
import org.apache.axiom.core.stream.sax.input.XmlHandlerContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class SAXReader
implements XmlReader {
    private final XmlHandler handler;
    private final boolean expandEntityReferences;
    private final SAXSource source;

    SAXReader(XmlHandler handler, SAXSource source, boolean expandEntityReferences) {
        this.handler = handler;
        this.expandEntityReferences = expandEntityReferences;
        this.source = source;
    }

    @Override
    public boolean proceed() throws StreamException {
        XMLReader reader = this.source.getXMLReader();
        XmlHandlerContentHandler contentHandler = new XmlHandlerContentHandler(this.handler, this.expandEntityReferences);
        reader.setContentHandler(contentHandler);
        reader.setDTDHandler(contentHandler);
        try {
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", contentHandler);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        try {
            reader.setProperty("http://xml.org/sax/properties/declaration-handler", contentHandler);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        try {
            reader.parse(this.source.getInputSource());
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
        catch (SAXException ex) {
            throw new StreamException(ex);
        }
        return true;
    }

    @Override
    public void dispose() {
    }
}

