/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.dom.impl.mixin;

import org.apache.axiom.core.AttributeMatcher;
import org.apache.axiom.core.CoreAttribute;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNSAwareAttribute;
import org.apache.axiom.core.CoreNamespaceDeclaration;
import org.apache.axiom.core.CoreTypedAttribute;
import org.apache.axiom.core.ElementAction;
import org.apache.axiom.dom.AttributesNamedNodeMap;
import org.apache.axiom.dom.DOMAttribute;
import org.apache.axiom.dom.DOMElement;
import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.dom.DOMSemantics;
import org.apache.axiom.dom.ElementsByTagName;
import org.apache.axiom.dom.ElementsByTagNameNS;
import org.apache.axiom.dom.NSUtil;
import org.apache.axiom.weaver.annotation.Mixin;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

@Mixin
public abstract class DOMElementMixin
implements DOMElement {
    @Override
    public final Document getOwnerDocument() {
        return (Document)((Object)this.coreGetOwnerDocument(true));
    }

    @Override
    public final short getNodeType() {
        return 1;
    }

    @Override
    public final String getNodeName() {
        return this.getTagName();
    }

    @Override
    public final String getNodeValue() {
        return null;
    }

    @Override
    public final void setNodeValue(String nodeValue) {
    }

    @Override
    public final String getTagName() {
        return this.internalGetName();
    }

    @Override
    public final TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final CoreElement getNamespaceContext() {
        return this;
    }

    @Override
    public final boolean hasAttributes() {
        return this.coreGetFirstAttribute() != null;
    }

    @Override
    public final NamedNodeMap getAttributes() {
        return new AttributesNamedNodeMap(this);
    }

    @Override
    public final Attr getAttributeNode(String name) {
        return (DOMAttribute)this.coreGetAttribute(DOMSemantics.DOM1_ATTRIBUTE_MATCHER, null, name);
    }

    @Override
    public final Attr getAttributeNodeNS(String namespaceURI, String localName) {
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            return (DOMAttribute)this.coreGetAttribute(DOMSemantics.NAMESPACE_DECLARATION_MATCHER, null, localName.equals("xmlns") ? "" : localName);
        }
        return (DOMAttribute)this.coreGetAttribute(DOMSemantics.DOM2_ATTRIBUTE_MATCHER, namespaceURI == null ? "" : namespaceURI, localName);
    }

    @Override
    public final String getAttribute(String name) {
        Attr attr = this.getAttributeNode(name);
        return attr != null ? attr.getValue() : "";
    }

    @Override
    public final String getAttributeNS(String namespaceURI, String localName) {
        Attr attr = this.getAttributeNodeNS(namespaceURI, localName);
        return attr != null ? attr.getValue() : "";
    }

    @Override
    public final boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    @Override
    public final boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.getAttributeNodeNS(namespaceURI, localName) != null;
    }

    @Override
    public final void setAttribute(String name, String value2) {
        try {
            NSUtil.validateName(name);
            this.coreSetAttribute(DOMSemantics.DOM1_ATTRIBUTE_MATCHER, null, name, null, value2);
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final void setAttributeNS(String namespaceURI, String qualifiedName, String value2) throws DOMException {
        try {
            String localName;
            String prefix;
            int i = NSUtil.validateQualifiedName(qualifiedName);
            if (i == -1) {
                prefix = "";
                localName = qualifiedName;
            } else {
                prefix = qualifiedName.substring(0, i);
                localName = qualifiedName.substring(i + 1);
            }
            if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
                this.coreSetAttribute(DOMSemantics.NAMESPACE_DECLARATION_MATCHER, null, NSUtil.getDeclaredPrefix(localName, prefix), null, value2);
            } else {
                namespaceURI = NSUtil.normalizeNamespaceURI(namespaceURI);
                NSUtil.validateAttributeName(namespaceURI, localName, prefix);
                this.coreSetAttribute(DOMSemantics.DOM2_ATTRIBUTE_MATCHER, namespaceURI, localName, prefix, value2);
            }
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final Attr setAttributeNode(Attr newAttr) throws DOMException {
        return this.setAttributeNodeNS(newAttr);
    }

    @Override
    public final Attr setAttributeNodeNS(Attr _newAttr) throws DOMException {
        if (!(_newAttr instanceof DOMAttribute)) {
            throw DOMExceptionUtil.newDOMException((short)4);
        }
        DOMAttribute newAttr = (DOMAttribute)_newAttr;
        CoreElement owner = newAttr.coreGetOwnerElement();
        if (owner == this) {
            return newAttr;
        }
        if (owner != null) {
            throw DOMExceptionUtil.newDOMException((short)10);
        }
        if (!this.coreHasSameOwnerDocument(newAttr)) {
            throw DOMExceptionUtil.newDOMException((short)4);
        }
        AttributeMatcher matcher = newAttr instanceof CoreNSAwareAttribute ? DOMSemantics.DOM2_ATTRIBUTE_MATCHER : (newAttr instanceof CoreNamespaceDeclaration ? DOMSemantics.NAMESPACE_DECLARATION_MATCHER : DOMSemantics.DOM1_ATTRIBUTE_MATCHER);
        return (DOMAttribute)this.coreSetAttribute(matcher, newAttr, DOMSemantics.INSTANCE);
    }

    @Override
    public final Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        if (oldAttr instanceof DOMAttribute) {
            DOMAttribute attr = (DOMAttribute)oldAttr;
            if (attr.coreGetOwnerElement() != this) {
                throw DOMExceptionUtil.newDOMException((short)8);
            }
            attr.coreRemove(DOMSemantics.INSTANCE);
            return attr;
        }
        throw DOMExceptionUtil.newDOMException((short)8);
    }

    @Override
    public final void removeAttribute(String name) throws DOMException {
        this.coreRemoveAttribute(DOMSemantics.DOM1_ATTRIBUTE_MATCHER, null, name, DOMSemantics.INSTANCE);
    }

    @Override
    public final void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            this.coreRemoveAttribute(DOMSemantics.NAMESPACE_DECLARATION_MATCHER, null, localName.equals("xmlns") ? "" : localName, DOMSemantics.INSTANCE);
        } else {
            this.coreRemoveAttribute(DOMSemantics.DOM2_ATTRIBUTE_MATCHER, namespaceURI == null ? "" : namespaceURI, localName, DOMSemantics.INSTANCE);
        }
    }

    @Override
    public final String getTextContent() {
        try {
            return this.coreGetCharacterData(ElementAction.RECURSE).toString();
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final void setTextContent(String textContent) {
        try {
            this.coreSetCharacterData(textContent, DOMSemantics.INSTANCE);
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final NodeList getElementsByTagName(String tagname) {
        return new ElementsByTagName(this, tagname);
    }

    @Override
    public final NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return new ElementsByTagNameNS(this, namespaceURI, localName);
    }

    @Override
    public final void setIdAttribute(String name, boolean isId) throws DOMException {
        CoreAttribute attr = this.coreGetAttribute(DOMSemantics.DOM1_ATTRIBUTE_MATCHER, null, name);
        if (attr == null) {
            throw DOMExceptionUtil.newDOMException((short)8);
        }
        ((CoreTypedAttribute)attr).coreSetType(isId ? "ID" : "CDATA");
    }

    @Override
    public final void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        CoreAttribute attr = this.coreGetAttribute(DOMSemantics.DOM2_ATTRIBUTE_MATCHER, NSUtil.normalizeNamespaceURI(namespaceURI), localName);
        if (attr == null) {
            throw DOMExceptionUtil.newDOMException((short)8);
        }
        ((CoreTypedAttribute)attr).coreSetType(isId ? "ID" : "CDATA");
    }

    @Override
    public final void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        if (idAttr.getOwnerElement() != this) {
            throw DOMExceptionUtil.newDOMException((short)8);
        }
        ((CoreTypedAttribute)((Object)idAttr)).coreSetType(isId ? "ID" : "CDATA");
    }
}

