/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.ds;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMOutputFormat;

public abstract class AbstractOMDataSource
implements OMDataSourceExt {
    private Map<String, Object> properties;

    @Override
    public final Object getProperty(String key) {
        return this.properties == null ? null : this.properties.get(key);
    }

    @Override
    public final boolean hasProperty(String key) {
        return this.properties != null && this.properties.containsKey(key);
    }

    @Override
    public final Object setProperty(String key, Object value2) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties.put(key, value2);
    }

    @Override
    public final void serialize(OutputStream out, OMOutputFormat format) throws XMLStreamException {
        OMAbstractFactory.getOMFactory().createOMElement(this).serializeAndConsume(out, format);
    }

    @Override
    public final void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        OMAbstractFactory.getOMFactory().createOMElement(this).serializeAndConsume(writer, format);
    }

    @Override
    public final byte[] getXMLBytes(String encoding) throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OMOutputFormat format = new OMOutputFormat();
        format.setCharSetEncoding(encoding);
        try {
            this.serialize(baos, format);
        }
        catch (XMLStreamException ex) {
            throw new OMException(ex);
        }
        return baos.toByteArray();
    }

    @Override
    public final InputStream getXMLInputStream(String encoding) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(this.getXMLBytes(encoding));
    }

    @Override
    public Object getObject() {
        return null;
    }

    @Override
    public void close() {
    }

    @Override
    public OMDataSourceExt copy() {
        return null;
    }
}

