/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.runtime;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.ErrorType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BMapInitialValueEntry;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BValue;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.api.values.BXmlSequence;
import io.ballerina.runtime.internal.BalRuntime;
import io.ballerina.runtime.internal.scheduling.ClassloaderRuntime;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.internal.types.BAnnotatableType;
import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.internal.values.ObjectValue;
import io.ballerina.runtime.internal.values.StringValue;
import io.ballerina.runtime.internal.values.TypedescValue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.ballerinalang.langlib.internal.GetElements;
import org.ballerinalang.langlib.internal.GetFilteredChildrenFlat;
import org.ballerinalang.langlib.internal.SelectDescendants;

public final class DebuggerRuntime {
    private static final String EVALUATOR_STRAND_NAME = "evaluator-strand";
    private static final String XML_STEP_SEPARATOR = "/";
    private static final String XML_ALL_CHILDREN_STEP = "\\*";
    private static final String XML_DESCENDANT_STEP_PREFIX = "**";
    private static final String XML_NAME_PATTERN_SEPARATOR = "\\|";
    private static final String MODULE_INIT_CLASS_NAME = "$_init";
    private static final String CONFIGURE_INIT_CLASS_NAME = "$configurationMapper";
    private static final String MODULE_INIT_METHOD_NAME = "$moduleInit";
    private static final String MODULE_START_METHOD_NAME = "$moduleStart";
    private static final String CONFIGURE_INIT_METHOD_NAME = "$configureInit";

    public static Object invokeObjectMethod(BObject bObject, String methodName, Object ... args) {
        try {
            Strand s;
            Object[] paramValues = args[0] instanceof Strand ? Arrays.copyOfRange(args, 1, args.length) : args;
            Object object = args[0];
            Strand strand = object instanceof Strand ? (s = (Strand)object) : Scheduler.getStrand();
            return ((ObjectValue)bObject).call(strand, methodName, paramValues);
        }
        catch (Exception e) {
            throw ErrorCreator.createError(StringUtils.fromString("invocation failed: " + e.getMessage()));
        }
    }

    public static Object invokeFunction(ClassLoader classLoader, String className, String methodName, Object ... paramValues) {
        try {
            Class<?> clazz = classLoader.loadClass(className);
            Method method = DebuggerRuntime.getMethod(methodName, clazz);
            try {
                return method.invoke(null, paramValues);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw ErrorCreator.createError(StringUtils.fromString("'" + methodName + "' function invocation failed: " + e.getMessage()));
            }
        }
        catch (Exception e) {
            throw ErrorCreator.createError(StringUtils.fromString("'" + methodName + "' function invocation failed: " + e.getMessage()));
        }
    }

    public static Object createObjectValue(String pkgOrg, String pkgName, String pkgVersion, String objectTypeName, Object ... fieldValues) {
        Module packageId = new Module(pkgOrg, pkgName, pkgVersion);
        return ValueCreator.createObjectValue(packageId, objectTypeName, fieldValues);
    }

    public static Object getRestArgArray(Type arrayElementType, BValue ... values) {
        ArrayType arrayType = TypeCreator.createArrayType(arrayElementType);
        if (values.length == 0) {
            return ValueCreator.createArrayValue(arrayType);
        }
        if (values.length == 1 && values[0].getType().equals(arrayType)) {
            return values[0];
        }
        return ValueCreator.createArrayValue(values, arrayType);
    }

    public static Object createErrorValue(Object message, Object cause, Object ... details) {
        if (!(message instanceof BString)) {
            return "incompatible types: expected 'string', found '" + DebuggerRuntime.getBTypeName(message) + "' for error message";
        }
        if (cause != null && !(cause instanceof BError)) {
            return "incompatible types: expected 'error?', found '" + DebuggerRuntime.getBTypeName(cause) + "' for error cause";
        }
        ArrayList<BMapInitialValueEntry> errorDetailEntries = new ArrayList<BMapInitialValueEntry>();
        for (int i = 0; i < details.length; i += 2) {
            errorDetailEntries.add(ValueCreator.createKeyFieldEntry(details[i], details[i + 1]));
        }
        ErrorType bErrorType = TypeCreator.createErrorType("error", PredefinedTypes.TYPE_ERROR.getPackage());
        BMap<BString, Object> errorDetailsMap = ValueCreator.createMapValue((MapType)PredefinedTypes.TYPE_ERROR_DETAIL, errorDetailEntries.toArray(errorDetailEntries.toArray(new BMapInitialValueEntry[0])));
        return ErrorCreator.createError(bErrorType, (StringValue)message, (ErrorValue)cause, errorDetailsMap);
    }

    public static Object getAnnotationValue(Object typedescValue, String annotationName) {
        if (!(typedescValue instanceof TypedescValue)) {
            return ErrorCreator.createError(StringUtils.fromString("Incompatible types: expected 'typedesc`, found '" + typedescValue.toString() + "'."));
        }
        Type type = ((TypedescValue)typedescValue).getDescribingType();
        if (type instanceof BAnnotatableType) {
            BAnnotatableType bAnnotatableType = (BAnnotatableType)type;
            return bAnnotatableType.getAnnotations().entrySet().stream().filter(annotationEntry -> ((BString)annotationEntry.getKey()).getValue().endsWith(annotationName)).findFirst().map(Map.Entry::getValue).orElse(null);
        }
        return ErrorCreator.createError(StringUtils.fromString("type: '" + String.valueOf(TypeUtils.getType(type.getEmptyValue())) + "' does not support annotation access."));
    }

    private static Method getMethod(String functionName, Class<?> funcClass) throws NoSuchMethodException {
        Method declaredMethod = Arrays.stream(funcClass.getDeclaredMethods()).filter(method -> functionName.equals(method.getName())).findAny().orElse(null);
        if (declaredMethod != null) {
            return declaredMethod;
        }
        throw new NoSuchMethodException(functionName + " is not found");
    }

    private static String getBTypeName(Object value2) {
        if (value2 instanceof Boolean) {
            return "boolean";
        }
        if (value2 instanceof Integer || value2 instanceof Long) {
            return "int";
        }
        if (value2 instanceof Float || value2 instanceof Double) {
            return "float";
        }
        if (value2 instanceof BValue) {
            BValue bValue = (BValue)value2;
            return bValue.getType().getName();
        }
        return "unknown";
    }

    public static Object getXmlChildrenInRange(BXmlSequence xmlSequence, int start, int count) {
        try {
            if (count > 0) {
                return xmlSequence.getChildrenList().subList(start, start + count).toArray(new BXml[0]);
            }
            return xmlSequence.getChildrenList().toArray(new BXml[0]);
        }
        catch (Exception e) {
            return e;
        }
    }

    public static BXml getXMLFilterResult(BXml xmlVal, BString ... xmlPatternChainList) {
        return GetElements.getElements(xmlVal, xmlPatternChainList);
    }

    public static Object getXMLStepResult(BXml xmlVal, String xmlStepPattern) {
        try {
            if (xmlStepPattern.startsWith(XML_STEP_SEPARATOR)) {
                xmlStepPattern = xmlStepPattern.substring(1);
            }
            if (xmlStepPattern.equals(XML_ALL_CHILDREN_STEP)) {
                BString[] elementNames = new BString[]{StringUtils.fromString(xmlStepPattern)};
                return GetFilteredChildrenFlat.getFilteredChildrenFlat(xmlVal, -1L, elementNames);
            }
            if (xmlStepPattern.startsWith(XML_DESCENDANT_STEP_PREFIX)) {
                String[] namePatternParts = xmlStepPattern.split(XML_STEP_SEPARATOR);
                xmlStepPattern = namePatternParts[namePatternParts.length - 1];
                BString[] elementNames = DebuggerRuntime.processXMLNamePattern(xmlStepPattern);
                return SelectDescendants.selectDescendants(xmlVal, elementNames);
            }
            BString[] elementNames = DebuggerRuntime.processXMLNamePattern(xmlStepPattern);
            return GetFilteredChildrenFlat.getFilteredChildrenFlat(xmlVal, -1L, elementNames);
        }
        catch (Exception e) {
            return ErrorCreator.createError(StringUtils.fromString(e.getMessage()));
        }
    }

    private static BString[] processXMLNamePattern(String xmlNamePattern) {
        if ((xmlNamePattern = xmlNamePattern.replace("<", "").replace(">", "")).contains(XML_STEP_SEPARATOR)) {
            String[] stepParts = xmlNamePattern.split(XML_ALL_CHILDREN_STEP);
            xmlNamePattern = stepParts[stepParts.length - 1];
        }
        return (BString[])Arrays.stream(xmlNamePattern.split(XML_NAME_PATTERN_SEPARATOR)).map(entry -> StringUtils.fromString(entry.trim())).toArray(BString[]::new);
    }

    public static Object classloadAndInvokeFunction(String executablePath, String mainClass, String functionName, Object ... userArgs) {
        try {
            URL pathUrl = Path.of(executablePath, new String[0]).toUri().toURL();
            URLClassLoader classLoader = AccessController.doPrivileged(() -> new URLClassLoader(new URL[]{pathUrl}, ClassLoader.getSystemClassLoader()));
            String[] mainClassNameParts = mainClass.split("\\.");
            String packageOrg = mainClassNameParts[0];
            String packageName = mainClassNameParts[1];
            String packageVersion = mainClassNameParts[2];
            Module module = new Module(packageOrg, packageName, packageVersion, false);
            return DebuggerRuntime.invokeBalRuntimeMethod(functionName, module, classLoader, userArgs);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private static Object invokeBalRuntimeMethod(String functionName, Module module, ClassLoader classLoader, Object[] paramValues) {
        Object result;
        ClassloaderRuntime runtime2 = new ClassloaderRuntime(module, classLoader);
        try {
            runtime2.init();
            runtime2.start();
            result = runtime2.callFunction(module, functionName, null, paramValues);
        }
        catch (Throwable throwable) {
            throw ErrorCreator.createError(StringUtils.fromString("'" + functionName + "' function invocation failed : " + throwable.getMessage()));
        }
        finally {
            try {
                ((BalRuntime)runtime2).stop();
            }
            catch (BError bError) {}
        }
        return result;
    }

    private DebuggerRuntime() {
    }
}

