/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array;

import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import java.util.ArrayList;
import org.ballerinalang.langlib.array.utils.ArrayUtils;

public final class Slice {
    private Slice() {
    }

    public static BArray slice(BArray arr, long startIndex, long endIndex) {
        BArray slicedArr;
        int size = arr.size();
        if (startIndex < 0L) {
            throw ErrorHelper.getRuntimeException(ErrorCodes.ARRAY_INDEX_OUT_OF_RANGE, startIndex, size);
        }
        if (endIndex > (long)size) {
            throw ErrorHelper.getRuntimeException(ErrorCodes.ARRAY_INDEX_OUT_OF_RANGE, endIndex, size);
        }
        long sliceSize = endIndex - startIndex;
        if (sliceSize < 0L) {
            throw ErrorHelper.getRuntimeException(ErrorCodes.ARRAY_INDEX_OUT_OF_RANGE, sliceSize, size);
        }
        Type arrType = TypeUtils.getImpliedType(arr.getType());
        switch (arrType.getTag()) {
            case 32: {
                slicedArr = arr.slice(startIndex, endIndex);
                break;
            }
            case 44: {
                TupleType tupleType = (TupleType)arrType;
                ArrayList<Type> memTypes = new ArrayList<Type>(tupleType.getTupleTypes());
                Type restType = tupleType.getRestType();
                if (restType != null) {
                    memTypes.add(restType);
                }
                UnionType unionType = TypeCreator.createUnionType(memTypes);
                ArrayType slicedArrType = TypeCreator.createArrayType(unionType);
                slicedArr = ValueCreator.createArrayValue(slicedArrType);
                long i = startIndex;
                long j = 0L;
                while (i < endIndex) {
                    slicedArr.add(j, arr.getRefValue(i));
                    ++i;
                    ++j;
                }
                break;
            }
            default: {
                throw ArrayUtils.createOpNotSupportedError(arrType, "slice()");
            }
        }
        return slicedArr;
    }
}

