/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.java;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BHandle;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;

public final class Cast {
    private static final String moduleName = "{ballerina/jballerina.java}";
    private static final String annotationName = "@java:Binding";
    private static final String annotationType = "ballerina/jballerina.java:0:Binding";
    private static final String classAttribute = "class";
    private static final String jObjField = "jObj";

    private Cast() {
    }

    public static Object cast(BObject value2, BTypedesc castType) {
        ObjectType objType = (ObjectType)TypeUtils.getImpliedType(value2.getType());
        String valueObjName = objType.getName();
        BHandle handleObj = (BHandle)value2.get(StringUtils.fromString(jObjField));
        Object jObj = handleObj.getValue();
        if (jObj == null) {
            return ErrorCreator.createError(StringUtils.fromString("{ballerina/jballerina.java} Empty handle reference found for `jObj` field in `" + valueObjName + "`"));
        }
        try {
            BString castObjClass;
            String castObjTypeName;
            ObjectType castObjType;
            BString objClass;
            try {
                BMap objAnnotation = (BMap)objType.getAnnotation(StringUtils.fromString(annotationType));
                objClass = objAnnotation.getStringValue(StringUtils.fromString(classAttribute));
            }
            catch (Exception e) {
                return ErrorCreator.createError(StringUtils.fromString("{ballerina/jballerina.java} Error while retrieving details of the `@java:Binding` annotation from `" + valueObjName + "` object: " + String.valueOf(e)));
            }
            Type describingBType = castType.getDescribingType();
            try {
                castObjType = (ObjectType)describingBType;
                castObjTypeName = castObjType.getName();
                Field objField = castObjType.getFields().get(jObjField);
                if (objField == null) {
                    return ErrorCreator.createError(StringUtils.fromString("{ballerina/jballerina.java} Handle reference field `jObj` not found in the typedesc object"));
                }
            }
            catch (Exception e) {
                return ErrorCreator.createError(StringUtils.fromString("{ballerina/jballerina.java} Error while processing the typedesc parameter: " + String.valueOf(e)));
            }
            try {
                BMap castObjAnnotation = (BMap)castObjType.getAnnotation(StringUtils.fromString(annotationType));
                castObjClass = castObjAnnotation.getStringValue(StringUtils.fromString(classAttribute));
            }
            catch (Exception e) {
                return ErrorCreator.createError(StringUtils.fromString("{ballerina/jballerina.java} Error while retrieving details of the `@java:Binding` annotation from `" + castObjTypeName + "` typedesc: " + String.valueOf(e)));
            }
            Class<?> objClassType = Class.forName(objClass.getValue());
            Class<?> castObjClassType = Class.forName(castObjClass.getValue());
            boolean isList = objClassType.isAssignableFrom(castObjClassType);
            if (isList) {
                BObject bObject;
                try {
                    bObject = ValueCreator.createObjectValue(castObjType.getPackage(), castObjType.getName(), ValueCreator.createHandleValue(jObj));
                }
                catch (Exception e) {
                    return ErrorCreator.createError(StringUtils.fromString("{ballerina/jballerina.java} Error while initializing the new object from `" + castObjTypeName + "` type: " + String.valueOf(e)));
                }
                return bObject;
            }
            return ErrorCreator.createError(StringUtils.fromString("{ballerina/jballerina.java} Cannot cast `" + valueObjName + "` to `" + castObjTypeName + "`"));
        }
        catch (ClassNotFoundException e) {
            return ErrorCreator.createError(StringUtils.fromString("{ballerina/jballerina.java} Error while casting `" + valueObjName + "` object to the typedesc provided: " + String.valueOf(e)));
        }
    }
}

