/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.map.util;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.utils.MapUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;

public final class MapLibUtils {
    private MapLibUtils() {
    }

    public static Type getFieldType(Type mapType, String funcName) {
        mapType = TypeUtils.getImpliedType(mapType);
        return switch (mapType.getTag()) {
            case 27 -> ((MapType)mapType).getConstrainedType();
            case 24 -> MapLibUtils.getCommonTypeForRecordField((RecordType)mapType);
            default -> throw MapUtils.createOpNotSupportedError(mapType, funcName);
        };
    }

    public static Type getCommonTypeForRecordField(RecordType recordType) {
        LinkedHashSet<Type> typeSet = new LinkedHashSet<Type>();
        Collection<Field> fields = recordType.getFields().values();
        for (Field f : fields) {
            typeSet.add(f.getFieldType());
        }
        if (recordType.getRestFieldType() != null) {
            typeSet.add(recordType.getRestFieldType());
        }
        return typeSet.size() == 1 ? (Type)typeSet.iterator().next() : TypeCreator.createUnionType(new ArrayList<Type>(typeSet));
    }

    public static void validateRecord(BMap<?, ?> m) {
        Type type = TypeUtils.getImpliedType(m.getType());
        if (type.getTag() != 24) {
            return;
        }
        Map<String, Field> fields = ((RecordType)type).getFields();
        for (String key : fields.keySet()) {
            if (!MapLibUtils.isRequiredField((RecordType)type, key)) continue;
            throw MapLibUtils.createOpNotSupportedErrorForRecord(type, key);
        }
    }

    private static boolean isRequiredField(RecordType type, String k) {
        Map<String, Field> fields = type.getFields();
        Field field = fields.get(k);
        return field != null && SymbolFlags.isFlagOn(field.getFlags(), 256L);
    }

    private static BError createOpNotSupportedErrorForRecord(Type type, String field) {
        return ErrorCreator.createError(ErrorReasons.getModulePrefixedReason("lang.map", "OperationNotSupported"), ErrorHelper.getErrorDetails(ErrorCodes.FIELD_REMOVAL_NOT_ALLOWED, field, type.getQualifiedName()));
    }

    public static void validateRequiredFieldForRecord(BMap<?, ?> m, String k) {
        Type type = TypeUtils.getImpliedType(m.getType());
        if (type.getTag() == 24 && MapLibUtils.isRequiredField((RecordType)type, k)) {
            throw MapLibUtils.createOpNotSupportedErrorForRecord(type, k);
        }
    }
}

