/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.string;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.errors.ErrorReasons;

public final class PadZero {
    private PadZero() {
    }

    public static BString padZero(BString str, long len, BString padChar) {
        int strLength = str.length();
        if (len <= (long)strLength) {
            return str;
        }
        if (len > Integer.MAX_VALUE) {
            throw ErrorCreator.createError(ErrorReasons.getModulePrefixedReason("lang.string", "length greater that '2147483647' not yet supported"));
        }
        int targetLen = (int)len;
        String pad = padChar.toString().repeat(targetLen - strLength);
        StringBuilder result = new StringBuilder();
        if (str.length() == 0) {
            return StringUtils.fromString(pad);
        }
        char firstChar = str.toString().charAt(0);
        if (firstChar == '+' || firstChar == '-') {
            result.append(str.toString().substring(0, 1)).append(pad).append(str.toString().substring(1));
        } else {
            result.append(pad).append(str);
        }
        return StringUtils.fromString(result.toString());
    }
}

