/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.constraint.annotations;

import io.ballerina.runtime.api.types.AnnotatableType;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.IdentifierUtils;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.constraint.ConstraintErrorInfo;
import io.ballerina.stdlib.constraint.annotations.AbstractAnnotations;
import io.ballerina.stdlib.constraint.annotations.TypeAnnotations;
import java.util.List;
import java.util.Map;

public class RecordFieldAnnotations
extends AbstractAnnotations {
    private final List<ConstraintErrorInfo> failedConstraintsInfo;

    public RecordFieldAnnotations(List<ConstraintErrorInfo> failedConstraintsInfo) {
        super(failedConstraintsInfo);
        this.failedConstraintsInfo = failedConstraintsInfo;
    }

    @Override
    public void validate(Object value, AnnotatableType type, String path, boolean isMemberValue) {
        BMap record = (BMap)value;
        BMap recordAnnotations = type.getAnnotations();
        super.validateAnnotations((BMap<BString, Object>)recordAnnotations, record, path, isMemberValue);
        for (Map.Entry entry : recordAnnotations.entrySet()) {
            if (!((BString)entry.getKey()).getValue().startsWith("$field$")) continue;
            String fieldName = IdentifierUtils.unescapeBallerina((String)((BString)entry.getKey()).getValue().substring("$field$".length() + 1));
            BMap recordFieldAnnotations = (BMap)entry.getValue();
            Object fieldValue = this.getFieldValue((BMap<BString, Object>)record, fieldName);
            if (fieldValue == null) continue;
            super.validateAnnotations((BMap<BString, Object>)recordFieldAnnotations, fieldValue, path + "." + fieldName, isMemberValue);
        }
        this.validateReferredType((BMap<BString, Object>)record, (RecordType)type, path, isMemberValue);
    }

    private Object getFieldValue(BMap<BString, Object> record, String fieldName) {
        Object obj = record.get((Object)StringUtils.fromString((String)fieldName));
        if (obj instanceof BDecimal) {
            return ((BDecimal)record.get((Object)StringUtils.fromString((String)fieldName))).value();
        }
        if (obj instanceof BString) {
            return ((BString)record.get((Object)StringUtils.fromString((String)fieldName))).getValue();
        }
        if (obj instanceof BArray) {
            return ((BArray)obj).getLength();
        }
        return obj;
    }

    private void validateReferredType(BMap<BString, Object> record, RecordType type, String path, boolean isMemberValue) {
        for (Field recordField : type.getFields().values()) {
            Type fieldType = recordField.getFieldType();
            String fieldName = recordField.getFieldName();
            Object fieldValue = record.get((Object)StringUtils.fromString((String)fieldName));
            if (fieldValue == null) continue;
            if (fieldType instanceof AnnotatableType) {
                if (fieldType instanceof RecordType) {
                    this.validate(fieldValue, (AnnotatableType)fieldType, path + "." + fieldName, isMemberValue);
                    continue;
                }
                TypeAnnotations typeAnnotations = new TypeAnnotations(this.failedConstraintsInfo);
                typeAnnotations.validate(fieldValue, (AnnotatableType)fieldType, path + "." + fieldName, isMemberValue);
                continue;
            }
            if (!(fieldType instanceof ArrayType)) continue;
            this.validateArrayType((ArrayType)fieldType, (BArray)fieldValue, path + "." + fieldName);
        }
    }

    private void validateArrayType(ArrayType fieldType, BArray fieldValue, String path) {
        block4: {
            Type elementType = fieldType.getElementType();
            if (!(elementType instanceof AnnotatableType)) break block4;
            if (elementType instanceof RecordType) {
                int i = 0;
                while ((long)i < fieldValue.getLength()) {
                    BMap map = (BMap)fieldValue.getRefValue((long)i);
                    this.validate(map, (AnnotatableType)elementType, path + "[" + i + "]", true);
                    ++i;
                }
            } else {
                TypeAnnotations typeAnnotations = new TypeAnnotations(this.failedConstraintsInfo);
                int i = 0;
                while ((long)i < fieldValue.getLength()) {
                    typeAnnotations.validate(fieldValue.getRefValue((long)i), (AnnotatableType)elementType, path + "[" + i + "]", true);
                    ++i;
                }
            }
        }
    }
}

