/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.constraint.validators;

import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.constraint.ConstraintErrorInfo;
import io.ballerina.stdlib.constraint.validators.interfaces.LengthValidator;
import java.util.List;
import java.util.Map;

public class ArrayConstraintValidator
implements LengthValidator {
    private final List<ConstraintErrorInfo> failedConstraintsInfo;

    public ArrayConstraintValidator(List<ConstraintErrorInfo> failedConstraintsInfo) {
        this.failedConstraintsInfo = failedConstraintsInfo;
    }

    public void validate(BMap<BString, Object> constraints, Long fieldValue, String path, boolean isMemberValue) {
        for (Map.Entry constraint : constraints.entrySet()) {
            LengthValidator.super.checkLengthConstraintValue(constraint, path);
            this.validate(constraint, fieldValue, isMemberValue, this.failedConstraintsInfo, path);
        }
    }

    @Override
    public boolean validateLength(Object fieldValue, long constraintValue) {
        return (Long)fieldValue == constraintValue;
    }

    @Override
    public boolean validateMinLength(Object fieldValue, long constraintValue) {
        return (Long)fieldValue >= constraintValue;
    }

    @Override
    public boolean validateMaxLength(Object fieldValue, long constraintValue) {
        return (Long)fieldValue <= constraintValue;
    }
}

