/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.constraint.validators.interfaces;

import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.constraint.Constants;
import io.ballerina.stdlib.constraint.ConstraintErrorInfo;
import java.util.List;
import java.util.Map;

public interface ValueValidator {
    default public void validate(Map.Entry<BString, Object> constraint, Object fieldValue, boolean isMemberValue, List<ConstraintErrorInfo> failedConstraints, String path) {
        Object constraintValue = constraint.getValue();
        String message = null;
        if (constraintValue instanceof BMap) {
            message = ((BMap)constraintValue).getStringValue(Constants.MESSAGE).getValue();
            constraintValue = ((BMap)constraintValue).get((Object)Constants.VALUE);
        }
        switch (constraint.getKey().getValue()) {
            case "minValue": {
                if (this.validateMinValue(fieldValue, constraintValue)) break;
                failedConstraints.add(new ConstraintErrorInfo(path, message, "minValue", isMemberValue));
                break;
            }
            case "maxValue": {
                if (this.validateMaxValue(fieldValue, constraintValue)) break;
                failedConstraints.add(new ConstraintErrorInfo(path, message, "maxValue", isMemberValue));
                break;
            }
            case "minValueExclusive": {
                if (this.validateMinValueExclusive(fieldValue, constraintValue)) break;
                failedConstraints.add(new ConstraintErrorInfo(path, message, "minValueExclusive", isMemberValue));
                break;
            }
            case "maxValueExclusive": {
                if (this.validateMaxValueExclusive(fieldValue, constraintValue)) break;
                failedConstraints.add(new ConstraintErrorInfo(path, message, "maxValueExclusive", isMemberValue));
                break;
            }
        }
    }

    public boolean validateMinValue(Object var1, Object var2);

    public boolean validateMaxValue(Object var1, Object var2);

    public boolean validateMinValueExclusive(Object var1, Object var2);

    public boolean validateMaxValueExclusive(Object var1, Object var2);
}

