/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime.entity;

import com.github.difflib.DiffUtils;
import com.github.difflib.algorithm.DiffException;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.DeltaType;
import com.github.difflib.patch.Patch;
import io.ballerina.identifier.Utils;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JarLibrary;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.PlatformLibrary;
import io.ballerina.projects.PlatformLibraryScope;
import io.ballerina.projects.ResolvedPackageDependency;
import io.ballerina.projects.internal.model.Target;
import io.ballerina.projects.util.ProjectUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.ballerinalang.test.runtime.entity.ModuleCoverage;
import org.ballerinalang.test.runtime.util.CodeCoverageUtils;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.IPackageCoverage;
import org.jacoco.core.analysis.ISourceFileCoverage;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.SessionInfo;
import org.jacoco.core.tools.ExecFileLoader;

public class CoverageReport {
    private final String title;
    private final Path coverageDir;
    private final Path executionDataFile;
    private final Path classesDirectory;
    private final ExecFileLoader execFileLoader;
    private final Module module;
    private final Map<String, ModuleCoverage> moduleCoverageMap;
    private final List<IClassCoverage> packageNativeClassCoverageList;
    private final List<IClassCoverage> packageBalClassCoverageList;
    private final List<ISourceFileCoverage> packageSourceCoverageList;
    private final List<ExecutionData> packageExecData;
    private final List<SessionInfo> sessionInfoList;

    public CoverageReport(Module module, Map<String, ModuleCoverage> moduleCoverageMap, List<IClassCoverage> packageNativeClassCoverageList, List<IClassCoverage> packageBalClassCoverageList, List<ISourceFileCoverage> packageSourceCoverageList, List<ExecutionData> packageExecData, List<SessionInfo> sessionInfoList) throws IOException {
        this.module = module;
        Target target = new Target(module.project().targetDir());
        this.coverageDir = target.getTestsCachePath().resolve("coverage");
        this.title = this.coverageDir.toFile().getName();
        this.classesDirectory = this.coverageDir.resolve("bin");
        this.executionDataFile = this.coverageDir.resolve("ballerina.exec");
        this.execFileLoader = new ExecFileLoader();
        this.moduleCoverageMap = moduleCoverageMap;
        this.packageNativeClassCoverageList = packageNativeClassCoverageList;
        this.packageBalClassCoverageList = packageBalClassCoverageList;
        this.packageSourceCoverageList = packageSourceCoverageList;
        this.packageExecData = packageExecData;
        this.sessionInfoList = sessionInfoList;
    }

    public void generateReport(JBallerinaBackend jBallerinaBackend, String includesInCoverage, String reportFormat, Module originalModule, Set<String> exclusionClassList) throws IOException {
        String orgName = this.module.packageInstance().packageOrg().toString();
        String packageName = this.module.packageInstance().packageName().toString();
        List<Path> filteredPathList = !this.module.testDocumentIds().isEmpty() ? this.filterPaths(jBallerinaBackend.jarResolver().getJarFilePathsRequiredForTestExecution(this.module.moduleName()), jBallerinaBackend, this.module.packageInstance()) : this.filterPaths(jBallerinaBackend.jarResolver().getJarFilePathsRequiredForExecution(), jBallerinaBackend, this.module.packageInstance());
        if (!filteredPathList.isEmpty()) {
            CoverageBuilder coverageBuilder = this.generateTesterinaCoverageReport(orgName, packageName, filteredPathList, originalModule, exclusionClassList);
            if (CodeCoverageUtils.isRequestedReportFormat(reportFormat, "xml")) {
                if (includesInCoverage != null) {
                    List<Path> dependencyPathList = this.getDependenciesForJacocoXML(jBallerinaBackend);
                    this.addCompiledSources(dependencyPathList, orgName, packageName, includesInCoverage, exclusionClassList);
                    this.execFileLoader.load(this.executionDataFile.toFile());
                    CoverageBuilder xmlCoverageBuilder = this.analyzeStructure();
                    this.updatePackageLevelCoverage(xmlCoverageBuilder);
                } else {
                    this.updatePackageLevelCoverage(coverageBuilder);
                }
            }
        } else {
            String msg = "Unable to generate code coverage for the module " + packageName + ". Jar files dont exist.";
            throw new NoSuchFileException(msg);
        }
        CodeCoverageUtils.deleteDirectory(this.coverageDir.resolve("bin").toFile());
    }

    private List<Path> getDependenciesForJacocoXML(JBallerinaBackend jBallerinaBackend) {
        List<Path> dependencyPathList = this.getDependencyJarList(jBallerinaBackend);
        List<Path> platformLibsList = this.getPlatformLibsList(jBallerinaBackend, this.module.packageInstance());
        for (Path otherDependencyPath : platformLibsList) {
            if (dependencyPathList.contains(otherDependencyPath)) continue;
            dependencyPathList.add(otherDependencyPath);
        }
        return dependencyPathList;
    }

    private CoverageBuilder generateTesterinaCoverageReport(String orgName, String packageName, List<Path> filteredPathList, Module originalModule, Set<String> exclusionClassList) throws IOException {
        this.addCompiledSources(filteredPathList, orgName, packageName, exclusionClassList);
        this.execFileLoader.load(this.executionDataFile.toFile());
        CoverageBuilder coverageBuilder = this.analyzeStructure();
        List<DocumentId> excludedFiles = this.getGeneratedFilesToExclude(originalModule);
        this.createReport(coverageBuilder.getBundle(this.title), this.moduleCoverageMap, excludedFiles, exclusionClassList);
        this.filterGeneratedCoverage(this.moduleCoverageMap, originalModule);
        return coverageBuilder;
    }

    private List<DocumentId> getGeneratedFilesToExclude(Module originalModules) {
        ArrayList<DocumentId> excludedDocumentIds = new ArrayList<DocumentId>(this.module.documentIds());
        ArrayList oldDocumentIds = new ArrayList(originalModules.documentIds());
        excludedDocumentIds.removeAll(oldDocumentIds);
        return excludedDocumentIds;
    }

    private void updatePackageLevelCoverage(CoverageBuilder coverageBuilder) {
        for (ISourceFileCoverage sourceFileCoverage : coverageBuilder.getSourceFiles()) {
            if (!sourceFileCoverage.getName().endsWith(".bal")) continue;
            this.packageSourceCoverageList.add(sourceFileCoverage);
        }
        for (IClassCoverage classCov : coverageBuilder.getClasses()) {
            if (classCov.getSourceFileName() != null && classCov.getSourceFileName().endsWith(".bal")) {
                this.packageBalClassCoverageList.add(classCov);
                continue;
            }
            this.removeFromCoverageList(classCov);
            this.packageNativeClassCoverageList.add(classCov);
        }
        for (SessionInfo sessionInfo : this.execFileLoader.getSessionInfoStore().getInfos()) {
            if (this.isExistingSessionInfo(sessionInfo)) continue;
            this.sessionInfoList.add(sessionInfo);
        }
        this.packageExecData.addAll(this.execFileLoader.getExecutionDataStore().getContents());
    }

    private boolean isExistingSessionInfo(SessionInfo sessionInfo) {
        for (SessionInfo existingSessionInfo : this.sessionInfoList) {
            if (existingSessionInfo.compareTo(sessionInfo) != 0) continue;
            return true;
        }
        return false;
    }

    private void removeFromCoverageList(IClassCoverage classCoverage) {
        boolean isExists = false;
        IClassCoverage coverageToRemove = null;
        for (IClassCoverage coverage : this.packageNativeClassCoverageList) {
            if (!classCoverage.getName().equals(coverage.getName())) continue;
            isExists = true;
            coverageToRemove = coverage;
        }
        if (isExists) {
            this.packageNativeClassCoverageList.remove(coverageToRemove);
        }
    }

    private void addCompiledSources(List<Path> pathList, String orgName, String packageName, Set<String> exclusionClassList) throws IOException {
        if (!pathList.isEmpty()) {
            for (Path jarPath : pathList) {
                try {
                    CodeCoverageUtils.unzipCompiledSource(jarPath, this.coverageDir.resolve("bin"), orgName, packageName, false, null, exclusionClassList);
                }
                catch (NoSuchFileException e) {
                    if (Files.exists(this.coverageDir.resolve("bin"), new LinkOption[0])) {
                        CodeCoverageUtils.deleteDirectory(this.coverageDir.resolve("bin").toFile());
                    }
                    return;
                }
            }
        }
    }

    private void addCompiledSources(List<Path> pathList, String orgName, String packageName, String includesInCoverage, Set<String> exclusionClassList) throws IOException {
        if (!pathList.isEmpty()) {
            for (Path jarPath : pathList) {
                try {
                    CodeCoverageUtils.unzipCompiledSource(jarPath, this.coverageDir.resolve("bin"), orgName, packageName, true, includesInCoverage, exclusionClassList);
                }
                catch (NoSuchFileException e) {
                    if (Files.exists(this.coverageDir.resolve("bin"), new LinkOption[0])) {
                        CodeCoverageUtils.deleteDirectory(this.coverageDir.resolve("bin").toFile());
                    }
                    return;
                }
            }
        }
    }

    private CoverageBuilder analyzeStructure() throws IOException {
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(this.execFileLoader.getExecutionDataStore(), (ICoverageVisitor)coverageBuilder);
        analyzer.analyzeAll(this.classesDirectory.toFile());
        return coverageBuilder;
    }

    private void createReport(IBundleCoverage bundleCoverage, Map<String, ModuleCoverage> moduleCoverageMap) {
        this.createReport(bundleCoverage, moduleCoverageMap, null, null);
    }

    private void createReport(IBundleCoverage bundleCoverage, Map<String, ModuleCoverage> moduleCoverageMap, List<DocumentId> exclusionList, Set<String> exclusionClassList) {
        boolean containsSourceFiles = true;
        for (IPackageCoverage packageCoverage : bundleCoverage.getPackages()) {
            if (".".equals(this.module.moduleName().toString())) {
                containsSourceFiles = packageCoverage.getName().isEmpty();
            }
            if (!containsSourceFiles) continue;
            for (ISourceFileCoverage sourceFileCoverage : packageCoverage.getSourceFiles()) {
                if (sourceFileCoverage.getPackageName().split("/").length <= 1) continue;
                String sourceFileModule = Utils.decodeIdentifier((String)sourceFileCoverage.getPackageName().split("/")[1]);
                ModuleCoverage moduleCoverage = moduleCoverageMap.containsKey(sourceFileModule) ? moduleCoverageMap.get(sourceFileModule) : new ModuleCoverage();
                Document document = this.getDocument(sourceFileModule, sourceFileCoverage.getName());
                if (document != null && exclusionList.contains(document.documentId()) || !sourceFileCoverage.getName().contains(".bal") || sourceFileCoverage.getName().contains("tests/")) continue;
                Object exclusionClassFileName = sourceFileCoverage.getPackageName() + "/" + sourceFileCoverage.getName().replace(".bal", "");
                if (exclusionClassList.contains(exclusionClassFileName = ((String)exclusionClassFileName).replace("/", "."))) continue;
                if (moduleCoverage.containsSourceFile(sourceFileCoverage.getName())) {
                    ILine line;
                    Optional<List<Integer>> missedLinesList = moduleCoverage.getMissedLinesList(sourceFileCoverage.getName());
                    Optional<List<Integer>> coveredLinesList = moduleCoverage.getCoveredLinesList(sourceFileCoverage.getName());
                    Optional<List<Integer>> emptyLinesList = moduleCoverage.getEmptyLinesList(sourceFileCoverage.getName());
                    if (!missedLinesList.isPresent() || !coveredLinesList.isPresent() || !emptyLinesList.isPresent()) continue;
                    List<Integer> missedLines = missedLinesList.get();
                    List<Integer> coveredLines = coveredLinesList.get();
                    List<Integer> emptyLines = emptyLinesList.get();
                    ArrayList<Integer> existingMissedLines = new ArrayList<Integer>(missedLines);
                    ArrayList<Integer> existingEmptyLines = new ArrayList<Integer>(emptyLines);
                    boolean isCoverageUpdated = false;
                    int coveredMissedLineCount = 0;
                    int coveredEmptyLineCount = 0;
                    int missedEmptyLineCount = 0;
                    for (Integer missedLine : existingMissedLines) {
                        line = sourceFileCoverage.getLine(missedLine.intValue());
                        if (line.getStatus() != 3 && line.getStatus() != 2) continue;
                        isCoverageUpdated = true;
                        missedLines.remove(missedLine);
                        coveredLines.add(missedLine);
                        ++coveredMissedLineCount;
                    }
                    for (Integer emptyLine : existingEmptyLines) {
                        line = sourceFileCoverage.getLine(emptyLine.intValue());
                        if (line.getStatus() == 3 || line.getStatus() == 2) {
                            isCoverageUpdated = true;
                            emptyLines.remove(emptyLine);
                            coveredLines.add(emptyLine);
                            ++coveredEmptyLineCount;
                            continue;
                        }
                        if (line.getStatus() != 1) continue;
                        isCoverageUpdated = true;
                        emptyLines.remove(emptyLine);
                        missedLines.add(emptyLine);
                        ++missedEmptyLineCount;
                    }
                    if (!isCoverageUpdated || document == null) continue;
                    Collections.sort(coveredLines);
                    Collections.sort(missedLines);
                    moduleCoverage.updateCoverage(document, coveredLines, missedLines, emptyLines, coveredMissedLineCount, coveredEmptyLineCount, missedEmptyLineCount);
                    continue;
                }
                ArrayList<Integer> coveredLines = new ArrayList<Integer>();
                ArrayList<Integer> missedLines = new ArrayList<Integer>();
                ArrayList<Integer> emptyLines = new ArrayList<Integer>();
                int firstLine = sourceFileCoverage.getFirstLine();
                int lastLine = sourceFileCoverage.getLastLine();
                for (int i = firstLine; i <= lastLine; ++i) {
                    ILine line = sourceFileCoverage.getLine(i);
                    if (line.getStatus() == 1) {
                        missedLines.add(i);
                        continue;
                    }
                    if (line.getStatus() == 3 || line.getStatus() == 2) {
                        coveredLines.add(i);
                        continue;
                    }
                    if (line.getStatus() != 0) continue;
                    emptyLines.add(i);
                }
                if (document != null && firstLine != -1) {
                    moduleCoverage.addSourceFileCoverage(document, coveredLines, missedLines, emptyLines);
                }
                moduleCoverageMap.put(sourceFileModule, moduleCoverage);
            }
        }
    }

    private void filterGeneratedCoverage(Map<String, ModuleCoverage> moduleCoverageMap, Module originalModule) {
        for (DocumentId documentId : originalModule.documentIds()) {
            Document modifiedDocument;
            Document originalDocument = originalModule.document(documentId);
            if (originalDocument.equals(modifiedDocument = this.module.document(originalDocument.documentId()))) continue;
            try {
                int i;
                Patch stringPatch = DiffUtils.diff((List)originalDocument.textDocument().textLines(), (List)modifiedDocument.textDocument().textLines());
                if (stringPatch.getDeltas().isEmpty()) continue;
                List patchDeltas = stringPatch.getDeltas();
                ArrayList<Integer> insertedLines = new ArrayList<Integer>();
                ArrayList<Integer> modifiedLines = new ArrayList<Integer>();
                ArrayList<Integer> deletedLines = new ArrayList<Integer>();
                for (AbstractDelta delta : patchDeltas) {
                    int size;
                    int lineNumber;
                    if (delta.getType().equals((Object)DeltaType.INSERT)) {
                        lineNumber = delta.getTarget().getPosition();
                        size = delta.getTarget().size();
                        for (i = lineNumber; i < lineNumber + size; ++i) {
                            insertedLines.add(i);
                        }
                        continue;
                    }
                    if (delta.getType().equals((Object)DeltaType.CHANGE)) {
                        lineNumber = delta.getTarget().getPosition();
                        if (!((String)delta.getSource().getLines().get(0)).isBlank()) continue;
                        modifiedLines.add(lineNumber);
                        continue;
                    }
                    if (!delta.getType().equals((Object)DeltaType.DELETE)) continue;
                    lineNumber = delta.getSource().getPosition();
                    size = delta.getSource().size();
                    for (i = lineNumber; i < lineNumber + size; ++i) {
                        deletedLines.add(i);
                    }
                }
                ModuleCoverage moduleCoverage = moduleCoverageMap.get(originalModule.moduleName().toString());
                List<Integer> coveredLinesList = moduleCoverage.getCoveredLinesList(modifiedDocument.name()).get();
                List<Integer> missedLinesList = moduleCoverage.getMissedLinesList(modifiedDocument.name()).get();
                ArrayList<Integer> modifiedDocLineStatus = new ArrayList<Integer>();
                for (i = 0; i < modifiedDocument.textDocument().textLines().size(); ++i) {
                    if (coveredLinesList.contains(i + 1)) {
                        modifiedDocLineStatus.add(2);
                        continue;
                    }
                    if (missedLinesList.contains(i + 1)) {
                        modifiedDocLineStatus.add(1);
                        continue;
                    }
                    modifiedDocLineStatus.add(0);
                }
                ArrayList<Integer> originalDocLineStatus = new ArrayList<Integer>();
                for (int i2 = 0; i2 < modifiedDocument.textDocument().textLines().size(); ++i2) {
                    while (deletedLines.contains(originalDocLineStatus.size() + 1)) {
                        originalDocLineStatus.add(0);
                    }
                    if (modifiedLines.contains(i2)) {
                        originalDocLineStatus.add(0);
                        continue;
                    }
                    if (insertedLines.contains(i2)) continue;
                    originalDocLineStatus.add((Integer)modifiedDocLineStatus.get(i2));
                }
                ArrayList<Integer> newCoveredLines = new ArrayList<Integer>();
                ArrayList<Integer> newMissedLines = new ArrayList<Integer>();
                ArrayList<Integer> newEmptyLines = new ArrayList<Integer>();
                for (int i3 = 0; i3 < originalDocLineStatus.size(); ++i3) {
                    if (((Integer)originalDocLineStatus.get(i3)).equals(2)) {
                        newCoveredLines.add(i3 + 1);
                        continue;
                    }
                    if (((Integer)originalDocLineStatus.get(i3)).equals(1)) {
                        newMissedLines.add(i3 + 1);
                        continue;
                    }
                    if (!((Integer)originalDocLineStatus.get(i3)).equals(0)) continue;
                    newEmptyLines.add(i3 + 1);
                }
                moduleCoverageMap.remove(originalModule.moduleName().toString());
                moduleCoverage.replaceCoverage(originalDocument, newCoveredLines, newMissedLines, newEmptyLines);
                moduleCoverageMap.put(originalModule.moduleName().toString(), moduleCoverage);
            }
            catch (DiffException | NullPointerException throwable) {}
        }
    }

    private List<Path> filterPaths(Collection<JarLibrary> pathCollection, JBallerinaBackend jBallerinaBackend, Package pkg) {
        ArrayList<Path> filteredPathList = new ArrayList<Path>();
        List<Path> exclusionPathList = this.getExclusionJarList(jBallerinaBackend, pkg);
        for (JarLibrary library : pathCollection) {
            Path path = library.path();
            if (exclusionPathList.contains(path)) continue;
            filteredPathList.add(path);
        }
        return filteredPathList;
    }

    private Document getDocument(String moduleName, String sourceFileName) {
        Module moduleInstance;
        Document document = null;
        Iterator iterator = this.module.packageInstance().modules().iterator();
        while (iterator.hasNext() && (!(moduleInstance = (Module)iterator.next()).moduleName().toString().equals(moduleName) || (document = this.getDocumentFromModule(moduleInstance, sourceFileName)) == null)) {
        }
        return document;
    }

    private Document getDocumentFromModule(Module moduleInstance, String sourceFileName) {
        Document document = null;
        for (DocumentId documentId : moduleInstance.documentIds()) {
            if (!moduleInstance.document(documentId).name().equals(sourceFileName)) continue;
            document = moduleInstance.document(documentId);
            break;
        }
        return document;
    }

    private List<Path> getExclusionJarList(JBallerinaBackend jBallerinaBackend, Package pkg) {
        ArrayList<Path> exclusionPathList = new ArrayList<Path>(this.getDependencyJarList(jBallerinaBackend));
        exclusionPathList.add(jBallerinaBackend.runtimeLibrary().path());
        for (JarLibrary library : ProjectUtils.testDependencies()) {
            exclusionPathList.add(library.path());
        }
        exclusionPathList.addAll(this.getPlatformLibsList(jBallerinaBackend, pkg));
        return exclusionPathList;
    }

    private List<Path> getPlatformLibsList(JBallerinaBackend jBallerinaBackend, Package pkg) {
        return Stream.concat(jBallerinaBackend.platformLibraryDependencies(pkg.packageId(), PlatformLibraryScope.DEFAULT).stream(), jBallerinaBackend.platformLibraryDependencies(pkg.packageId(), PlatformLibraryScope.PROVIDED).stream()).map(PlatformLibrary::path).distinct().toList();
    }

    private List<Path> getDependencyJarList(JBallerinaBackend jBallerinaBackend) {
        ArrayList<Path> dependencyPathList = new ArrayList<Path>();
        this.module.packageInstance().getResolution().allDependencies().stream().map(ResolvedPackageDependency::packageInstance).forEach(pkg -> {
            for (ModuleId dependencyModuleId : pkg.moduleIds()) {
                Module dependencyModule = pkg.module(dependencyModuleId);
                PlatformLibrary generatedJarLibrary = jBallerinaBackend.codeGeneratedLibrary(pkg.packageId(), dependencyModule.moduleName());
                if (dependencyPathList.contains(generatedJarLibrary.path())) continue;
                dependencyPathList.add(generatedJarLibrary.path());
            }
            List otherJarDependencies = Stream.concat(jBallerinaBackend.platformLibraryDependencies(pkg.packageId(), PlatformLibraryScope.DEFAULT).stream(), jBallerinaBackend.platformLibraryDependencies(pkg.packageId(), PlatformLibraryScope.PROVIDED).stream()).toList();
            for (PlatformLibrary otherJarDependency : otherJarDependencies) {
                if (dependencyPathList.contains(otherJarDependency.path())) continue;
                dependencyPathList.add(otherJarDependency.path());
            }
        });
        return dependencyPathList;
    }
}

