/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime.entity;

import org.jacoco.core.analysis.ICounter;

public class PartialCoverageModifiedCounter
implements ICounter {
    private int covered;
    private int missed;

    public PartialCoverageModifiedCounter(ICounter prevCounter) {
        if (prevCounter != null) {
            this.covered = prevCounter.getCoveredCount();
            this.missed = prevCounter.getMissedCount();
            this.modifyCoverageNumbers();
        } else {
            this.covered = 0;
            this.missed = 0;
        }
    }

    private void modifyCoverageNumbers() {
        if (this.getStatus() == 3) {
            this.covered += this.missed;
            this.missed = 0;
        }
    }

    public double getValue(ICounter.CounterValue value) {
        return switch (value) {
            default -> throw new MatchException(null, null);
            case ICounter.CounterValue.TOTALCOUNT -> this.getTotalCount();
            case ICounter.CounterValue.MISSEDCOUNT -> this.getMissedCount();
            case ICounter.CounterValue.COVEREDCOUNT -> this.getCoveredCount();
            case ICounter.CounterValue.MISSEDRATIO -> this.getMissedRatio();
            case ICounter.CounterValue.COVEREDRATIO -> this.getCoveredRatio();
        };
    }

    public int getTotalCount() {
        return this.covered + this.missed;
    }

    public int getCoveredCount() {
        return this.covered;
    }

    public int getMissedCount() {
        return this.missed;
    }

    public double getCoveredRatio() {
        return (double)this.covered / (double)(this.missed + this.covered);
    }

    public double getMissedRatio() {
        return (double)this.missed / (double)(this.missed + this.covered);
    }

    public int getStatus() {
        int status;
        int n = status = this.covered > 0 ? 2 : 0;
        if (this.missed > 0) {
            status |= 1;
        }
        return status;
    }
}

