/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.test.runtime.util;

import io.ballerina.identifier.Utils;
import io.ballerina.projects.Module;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.projects.internal.model.Target;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.ballerinalang.test.runtime.entity.NormalizedCoverageClass;
import org.ballerinalang.test.runtime.entity.PartialCoverageModifiedLine;
import org.ballerinalang.test.runtime.entity.PartialCoverageModifiedSourceFile;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.ISourceFileCoverage;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.SessionInfo;
import org.jacoco.core.internal.analysis.BundleCoverageImpl;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.xml.XMLFormatter;

public final class CodeCoverageUtils {
    private static final String REPORT_ZIP_DIRECTORY = Path.of(System.getProperty("ballerina.home"), new String[0]).resolve("lib").resolve("tools").resolve("coverage").resolve("report.zip").toString().replace("report.zip", "");
    private static final PrintStream errStream = System.err;

    private CodeCoverageUtils() {
    }

    public static boolean isRequestedReportFormat(String coverageReportFormat, String format) {
        boolean isRequested = false;
        if (coverageReportFormat != null) {
            isRequested = coverageReportFormat.equals(format);
        }
        return isRequested;
    }

    public static void unzipCompiledSource(Path source, Path destination, String orgName, String moduleName, boolean enableIncludesFilter, String includesInCoverage, Set<String> externalExclusionList) throws NoSuchFileException {
        String destJarDir = destination.toString();
        try (JarFile jarFile = new JarFile(source.toFile());){
            Enumeration<JarEntry> enu = jarFile.entries();
            while (enu.hasMoreElements()) {
                JarEntry entry = enu.nextElement();
                File file = new File(destJarDir, entry.getName());
                if (!CodeCoverageUtils.isRequiredFile(entry.getName(), orgName, enableIncludesFilter, includesInCoverage)) continue;
                String classEntry = entry.getName().replace(".class", "").replace("/", ".");
                if (externalExclusionList != null && externalExclusionList.contains(classEntry)) continue;
                if (!file.exists()) {
                    Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
                }
                if (entry.isDirectory()) continue;
                InputStream is = jarFile.getInputStream(entry);
                try {
                    Files.copy(is, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (NoSuchFileException e) {
            String msg = "Unable to generate code coverage for the module " + moduleName + ". Source file does not exist";
            errStream.println(msg);
            throw new NoSuchFileException(msg);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isRequiredFile(String path, String orgName, boolean enableIncludesFilter, String includesInCoverage) {
        return !path.contains("$_init") && !path.contains("META-INF") && !path.contains("/tests/") && (!path.contains("$frame$") || !path.contains("module") && !path.contains(orgName)) && !path.contains("module-info.class") && (!enableIncludesFilter || CodeCoverageUtils.isIncluded(path, includesInCoverage));
    }

    private static String normalizeRegexPattern(String pattern) {
        if (pattern.contains("*")) {
            pattern = pattern.replace("*", ".*");
        }
        return pattern;
    }

    private static boolean isIncluded(String path, String includesInCoverage) {
        boolean isIncluded = false;
        if (includesInCoverage != null) {
            String[] includedPackages;
            for (String packageName : includedPackages = includesInCoverage.split(":")) {
                Pattern pattern = Pattern.compile(CodeCoverageUtils.normalizeRegexPattern(packageName = packageName.replace(".", "/")));
                Matcher matcherStr = pattern.matcher(path);
                if (!matcherStr.find()) continue;
                isIncluded = true;
                break;
            }
        }
        return isIncluded;
    }

    public static void deleteDirectory(File dir) throws IOException {
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (File f : contents) {
                if (Files.isSymbolicLink(f.toPath())) continue;
                CodeCoverageUtils.deleteDirectory(f);
            }
        }
        Files.deleteIfExists(dir.toPath());
    }

    public static void unzipReportResources(InputStream source, File target) throws IOException {
        ZipEntry nextEntry;
        ZipInputStream zipStream = new ZipInputStream(source);
        while ((nextEntry = zipStream.getNextEntry()) != null) {
            if (nextEntry.isDirectory()) continue;
            File nextFile = new File(target, nextEntry.getName());
            File parent = nextFile.getParentFile();
            if (parent != null) {
                Files.createDirectories(parent.toPath(), new FileAttribute[0]);
            }
            try (FileOutputStream targetStream = new FileOutputStream(nextFile);){
                int nextCount;
                int bufferSize = 4096;
                byte[] buffer = new byte[4096];
                while ((nextCount = zipStream.read(buffer)) >= 0) {
                    ((OutputStream)targetStream).write(buffer, 0, nextCount);
                }
            }
        }
    }

    private static Collection<IClassCoverage> modifyClasses(Collection<IClassCoverage> classesList, Package packageInstance) {
        ArrayList<IClassCoverage> modifiedClasses = new ArrayList<IClassCoverage>();
        for (IClassCoverage classCoverage : classesList) {
            if (classCoverage.getSourceFileName() != null && classCoverage.getSourceFileName().endsWith(".bal")) {
                if (classCoverage.getSourceFileName().startsWith("tests/")) continue;
                NormalizedCoverageClass modifiedClassCoverage = new NormalizedCoverageClass(classCoverage, CodeCoverageUtils.normalizeFileName(classCoverage.getPackageName(), packageInstance), CodeCoverageUtils.normalizeFileName(classCoverage.getName(), packageInstance));
                modifiedClasses.add(modifiedClassCoverage);
                continue;
            }
            modifiedClasses.add(classCoverage);
        }
        return modifiedClasses;
    }

    private static Collection<ISourceFileCoverage> modifySourceFiles(Collection<ISourceFileCoverage> sourceFiles, Package packageInstance) {
        ArrayList<ISourceFileCoverage> modifiedSourceFiles = new ArrayList<ISourceFileCoverage>();
        for (ISourceFileCoverage sourcefile : sourceFiles) {
            if (sourcefile.getName().endsWith(".bal")) {
                if (sourcefile.getName().startsWith("tests/")) continue;
                List<ILine> modifiedLines = CodeCoverageUtils.modifyLines(sourcefile);
                PartialCoverageModifiedSourceFile modifiedSourceFile = new PartialCoverageModifiedSourceFile(sourcefile, modifiedLines, CodeCoverageUtils.normalizeFileName(sourcefile.getPackageName(), packageInstance));
                modifiedSourceFiles.add(modifiedSourceFile);
                continue;
            }
            modifiedSourceFiles.add(sourcefile);
        }
        return modifiedSourceFiles;
    }

    private static String normalizeFileName(String fileName, Package packageInstance) {
        String orgName = Utils.encodeNonFunctionIdentifier((String)packageInstance.packageOrg().toString());
        for (Module module : packageInstance.modules()) {
            String packageName = Utils.encodeNonFunctionIdentifier((String)module.moduleName().toString());
            Object sourceRoot = module.project().sourceRoot().getFileName().toString();
            if (!module.isDefaultModule()) {
                sourceRoot = (String)sourceRoot + "/modules/" + module.moduleName().moduleNamePart();
            }
            if (!fileName.contains(orgName + "/" + packageName + "/")) continue;
            orgName = Pattern.quote(orgName);
            packageName = Pattern.quote(packageName);
            String normalizedFileName = fileName.replaceAll("^" + orgName + "/" + packageName + "/.*/", (String)sourceRoot + "/");
            normalizedFileName = normalizedFileName.replaceAll("^" + orgName + "/" + packageName + "/.*", (String)sourceRoot);
            return normalizedFileName;
        }
        return fileName;
    }

    private static List<ILine> modifyLines(ISourceFileCoverage sourcefile) {
        PartialCoverageModifiedLine modifiedLine;
        ILine line;
        ArrayList<ILine> modifiedLines = new ArrayList<ILine>();
        int i = sourcefile.getFirstLine();
        if (i == 0 && ((line = sourcefile.getLine(i)).getInstructionCounter().getTotalCount() > 0 || line.getBranchCounter().getTotalCount() > 0)) {
            i = 1;
            modifiedLine = new PartialCoverageModifiedLine(null, null);
            modifiedLines.add(modifiedLine);
        }
        while (i <= sourcefile.getLastLine()) {
            line = sourcefile.getLine(i);
            modifiedLine = new PartialCoverageModifiedLine(line.getInstructionCounter(), line.getBranchCounter());
            modifiedLines.add(modifiedLine);
            ++i;
        }
        return modifiedLines;
    }

    private static IBundleCoverage getPartialCoverageModifiedBundle(String title, Package packageInstance, List<IClassCoverage> packageNativeClassCoverageList, List<IClassCoverage> packageBalClassCoverageList, List<ISourceFileCoverage> packageSourceCovList) {
        CoverageBuilder packageCoverageBuilder = new CoverageBuilder();
        for (IClassCoverage classCov : packageNativeClassCoverageList) {
            try {
                packageCoverageBuilder.visitCoverage(classCov);
            }
            catch (IllegalStateException exception) {}
        }
        packageBalClassCoverageList.addAll(packageCoverageBuilder.getClasses());
        packageSourceCovList.addAll(packageCoverageBuilder.getSourceFiles());
        return new BundleCoverageImpl(title, CodeCoverageUtils.modifyClasses(packageBalClassCoverageList, packageInstance), CodeCoverageUtils.modifySourceFiles(packageSourceCovList, packageInstance));
    }

    public static void createXMLReport(Project project, List<ExecutionData> packageExecData, List<IClassCoverage> packageNativeClassCovList, List<IClassCoverage> packageBalClassCovList, List<ISourceFileCoverage> packageSourceCovList, List<SessionInfo> packageSessionInfo) throws IOException {
        Target target = new Target(project.targetDir());
        String title = target.getTestsCachePath().resolve("coverage").toFile().getName();
        XMLFormatter xmlFormatter = new XMLFormatter();
        File reportFile = new File(target.getReportPath().resolve(project.currentPackage().packageName().value()).resolve("coverage-report.xml").toString());
        reportFile.getParentFile().mkdirs();
        try (FileOutputStream fileOutputStream = new FileOutputStream(reportFile);){
            IReportVisitor visitor = xmlFormatter.createVisitor((OutputStream)fileOutputStream);
            visitor.visitInfo(packageSessionInfo, packageExecData);
            visitor.visitBundle(CodeCoverageUtils.getPartialCoverageModifiedBundle(title, project.currentPackage(), packageNativeClassCovList, packageBalClassCovList, packageSourceCovList), null);
            visitor.visitEnd();
        }
    }
}

