/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc.plugin;

import io.ballerina.tools.diagnostics.DiagnosticSeverity;

public final class GrpcCompilerPluginConstants {
    public static final String GRPC_SERVICE_DESCRIPTOR_ANNOTATION_NAME = "ServiceDescriptor";
    public static final String GRPC_DESCRIPTOR_ANNOTATION_NAME = "Descriptor";
    public static final String BALLERINA_ORG_NAME = "ballerina";
    public static final String GRPC_PACKAGE_NAME = "grpc";

    private GrpcCompilerPluginConstants() {
    }

    public static enum CompilationErrors {
        UNDEFINED_ANNOTATION("undefined annotation: ", "GRPC_101", DiagnosticSeverity.ERROR),
        RESOURCES_NOT_ALLOWED("resource methods are not allowed inside gRPC services", "GRPC_102", DiagnosticSeverity.ERROR),
        RETURN_WITH_CALLER("only `error?` return type is allowed with the caller", "GRPC_103", DiagnosticSeverity.ERROR),
        MAX_PARAM_COUNT("the maximum number of parameters to a remote function is 2", "GRPC_104", DiagnosticSeverity.ERROR),
        TWO_PARAMS_WITHOUT_CALLER("when there are two parameters to a remote function, the first one must be a caller type", "GRPC_105", DiagnosticSeverity.ERROR),
        INVALID_CALLER_TYPE("expected caller type \"", "GRPC_106", DiagnosticSeverity.ERROR),
        INVALID_SERVICE_NAME("invalid service name", "GRPC_107", DiagnosticSeverity.ERROR);

        private final String error;
        private final String errorCode;
        private final DiagnosticSeverity diagnosticSeverity;

        private CompilationErrors(String error, String errorCode, DiagnosticSeverity diagnosticSeverity) {
            this.error = error;
            this.errorCode = errorCode;
            this.diagnosticSeverity = diagnosticSeverity;
        }

        public String getError() {
            return this.error;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public DiagnosticSeverity getDiagnosticSeverity() {
            return this.diagnosticSeverity;
        }
    }
}

