/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.commons.types;

import io.ballerina.stdlib.graphql.commons.types.DirectiveLocation;
import io.ballerina.stdlib.graphql.commons.types.FederatedEnumValue;
import io.ballerina.stdlib.graphql.commons.types.InputValue;
import io.ballerina.stdlib.graphql.commons.types.ScalarType;
import io.ballerina.stdlib.graphql.commons.types.Type;
import io.ballerina.stdlib.graphql.commons.types.TypeKind;
import java.util.List;

public enum FederatedDirective {
    KEY("key", List.of(FederatedDirective.getFieldsInput(), FederatedDirective.getResolvableInput()), true, List.of(DirectiveLocation.OBJECT, DirectiveLocation.INTERFACE)),
    LINK("link", List.of(FederatedDirective.getUrlInput(), FederatedDirective.getAsInput(), FederatedDirective.getForInput(), FederatedDirective.getImportInput()), true, List.of(DirectiveLocation.SCHEMA));

    private final String name;
    private final List<InputValue> arguments;
    private final boolean repeatable;
    private final List<DirectiveLocation> locations;

    private FederatedDirective(String name, List<InputValue> arguments, boolean repeatable, List<DirectiveLocation> locations) {
        this.name = name;
        this.arguments = arguments;
        this.repeatable = repeatable;
        this.locations = locations;
    }

    public static boolean canImportInLinkDirective(String directiveName) {
        return directiveName.equals(LINK.getName());
    }

    public String getName() {
        return this.name;
    }

    public List<InputValue> getArguments() {
        return this.arguments;
    }

    public List<DirectiveLocation> getLocations() {
        return this.locations;
    }

    private static InputValue getFieldsInput() {
        return new InputValue("fields", new Type(TypeKind.NON_NULL, FederatedDirective.getScalar(ScalarType.FIELD_SET)), null, null);
    }

    private static InputValue getResolvableInput() {
        return new InputValue("resolvable", FederatedDirective.getScalar(ScalarType.BOOLEAN), null, "true");
    }

    private static InputValue getUrlInput() {
        return new InputValue("url", new Type(TypeKind.NON_NULL, FederatedDirective.getScalar(ScalarType.STRING)), null, null);
    }

    private static InputValue getAsInput() {
        return new InputValue("as", FederatedDirective.getScalar(ScalarType.STRING), null, null);
    }

    private static InputValue getForInput() {
        return new InputValue("for", FederatedEnumValue.LINK_PURPOSE.getEnumTypeWithValues(), null, null);
    }

    private static InputValue getImportInput() {
        return new InputValue("import", new Type(TypeKind.LIST, FederatedDirective.getScalar(ScalarType.LINK_IMPORT)), null, null);
    }

    private static Type getScalar(ScalarType scalar) {
        return new Type(scalar.getName(), TypeKind.SCALAR, scalar.getDescription());
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }
}

