/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.CodeModifier;
import io.ballerina.projects.plugins.CodeModifierContext;
import io.ballerina.projects.plugins.ModifierTask;
import io.ballerina.stdlib.graphql.compiler.AnnotationAnalysisTask;
import io.ballerina.stdlib.graphql.compiler.InterceptorAnalysisTask;
import io.ballerina.stdlib.graphql.compiler.ModuleLevelVariableDeclarationAnalysisTask;
import io.ballerina.stdlib.graphql.compiler.ObjectConstructorAnalysisTask;
import io.ballerina.stdlib.graphql.compiler.ServiceDeclarationAnalysisTask;
import io.ballerina.stdlib.graphql.compiler.schema.generator.GraphqlModifierContext;
import io.ballerina.stdlib.graphql.compiler.schema.generator.GraphqlSourceModifier;
import io.ballerina.stdlib.graphql.compiler.service.validator.ListenerValidator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class GraphqlCodeModifier
extends CodeModifier {
    private final Map<String, Object> userData;
    private final Map<DocumentId, GraphqlModifierContext> modifierContextMap = new HashMap<DocumentId, GraphqlModifierContext>();

    public GraphqlCodeModifier(Map<String, Object> userData) {
        this.userData = userData;
        userData.put("modifierContextMap", this.modifierContextMap);
    }

    public void init(CodeModifierContext modifierContext) {
        modifierContext.addSyntaxNodeAnalysisTask((AnalysisTask)new ServiceDeclarationAnalysisTask(this.userData), SyntaxKind.SERVICE_DECLARATION);
        modifierContext.addSyntaxNodeAnalysisTask((AnalysisTask)new ObjectConstructorAnalysisTask(this.userData), SyntaxKind.OBJECT_CONSTRUCTOR);
        modifierContext.addSyntaxNodeAnalysisTask((AnalysisTask)new InterceptorAnalysisTask(), SyntaxKind.CLASS_DEFINITION);
        modifierContext.addSyntaxNodeAnalysisTask((AnalysisTask)new ListenerValidator(), Arrays.asList(SyntaxKind.IMPLICIT_NEW_EXPRESSION, SyntaxKind.EXPLICIT_NEW_EXPRESSION));
        modifierContext.addSyntaxNodeAnalysisTask((AnalysisTask)new AnnotationAnalysisTask(), SyntaxKind.ANNOTATION);
        modifierContext.addSyntaxNodeAnalysisTask((AnalysisTask)new ModuleLevelVariableDeclarationAnalysisTask(this.userData), SyntaxKind.MODULE_VAR_DECL);
        modifierContext.addSourceModifierTask((ModifierTask)new GraphqlSourceModifier(this.modifierContextMap));
        this.userData.put("isAnalysisCompleted", true);
    }
}

