/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.graphql.commons.types.Schema;
import io.ballerina.stdlib.graphql.compiler.CacheConfigContext;
import io.ballerina.stdlib.graphql.compiler.ServiceAnalysisTask;
import io.ballerina.stdlib.graphql.compiler.Utils;
import io.ballerina.stdlib.graphql.compiler.service.InterfaceEntityFinder;
import io.ballerina.stdlib.graphql.compiler.service.validator.ServiceValidator;
import java.util.Map;
import java.util.Optional;

public class ObjectConstructorAnalysisTask
extends ServiceAnalysisTask {
    public ObjectConstructorAnalysisTask(Map<String, Object> nodeMap) {
        super(nodeMap);
    }

    public void perform(SyntaxNodeAnalysisContext context) {
        if (Utils.hasCompilationErrors(context)) {
            return;
        }
        ObjectConstructorExpressionNode node = (ObjectConstructorExpressionNode)context.node();
        if (!this.isGraphQLServiceObjectDeclaration(context.semanticModel(), (NonTerminalNode)context.node())) {
            return;
        }
        InterfaceEntityFinder interfaceEntityFinder = this.getInterfaceEntityFinder(context.semanticModel());
        ServiceValidator serviceValidator = this.getServiceValidator(context, (Node)node, interfaceEntityFinder, new CacheConfigContext(false));
        if (serviceValidator.isErrorOccurred()) {
            return;
        }
        Schema schema = this.generateSchema(context, interfaceEntityFinder, (Node)node, null);
        DocumentId documentId = context.documentId();
        this.addToModifierContextMap(documentId, (Node)node.parent(), schema);
        this.addToModifierContextMap(documentId, (Node)node.parent(), serviceValidator.getCacheConfigContext());
    }

    public boolean isGraphQLServiceObjectDeclaration(SemanticModel semanticModel, NonTerminalNode node) {
        TypeDescriptorNode typeReferenceNode;
        if (node.parent().kind() == SyntaxKind.LOCAL_VAR_DECL) {
            typeReferenceNode = ((VariableDeclarationNode)node.parent()).typedBindingPattern().typeDescriptor();
        } else if (node.parent().kind() == SyntaxKind.MODULE_VAR_DECL) {
            typeReferenceNode = ((ModuleVariableDeclarationNode)node.parent()).typedBindingPattern().typeDescriptor();
        } else if (node.parent().kind() == SyntaxKind.OBJECT_FIELD) {
            typeReferenceNode = ((ObjectFieldNode)node.parent()).typeName();
        } else {
            return false;
        }
        Optional typeReferenceSymbol = semanticModel.symbol((Node)typeReferenceNode);
        return typeReferenceSymbol.isPresent() && io.ballerina.stdlib.graphql.commons.utils.Utils.isGraphqlModuleSymbol((Symbol)typeReferenceSymbol.get());
    }
}

