/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Project;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.graphql.commons.types.Schema;
import io.ballerina.stdlib.graphql.compiler.CacheConfigContext;
import io.ballerina.stdlib.graphql.compiler.FinderContext;
import io.ballerina.stdlib.graphql.compiler.Utils;
import io.ballerina.stdlib.graphql.compiler.schema.generator.GraphqlModifierContext;
import io.ballerina.stdlib.graphql.compiler.schema.generator.SchemaGenerator;
import io.ballerina.stdlib.graphql.compiler.service.InterfaceEntityFinder;
import io.ballerina.stdlib.graphql.compiler.service.validator.ServiceValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class ServiceAnalysisTask
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private final Map<DocumentId, GraphqlModifierContext> modifierContextMap;
    private final Map<Node, Boolean> nodeSubgraphMap;

    public ServiceAnalysisTask(Map<String, Object> userdata) {
        this.modifierContextMap = (Map)userdata.get("modifierContextMap");
        this.nodeSubgraphMap = new HashMap<Node, Boolean>();
    }

    public ServiceValidator getServiceValidator(SyntaxNodeAnalysisContext context, Node node, InterfaceEntityFinder interfaceEntityFinder, CacheConfigContext cacheConfigContext) {
        boolean isSubgraph = ServiceAnalysisTask.isSubgraphService(node, context);
        this.nodeSubgraphMap.put(node, isSubgraph);
        ServiceValidator serviceValidator = new ServiceValidator(context, node, interfaceEntityFinder, isSubgraph, cacheConfigContext);
        serviceValidator.validate();
        return serviceValidator;
    }

    public InterfaceEntityFinder getInterfaceEntityFinder(SemanticModel semanticModel) {
        InterfaceEntityFinder interfaceEntityFinder = new InterfaceEntityFinder();
        interfaceEntityFinder.populateInterfacesAndEntities(semanticModel);
        return interfaceEntityFinder;
    }

    public Schema generateSchema(SyntaxNodeAnalysisContext context, InterfaceEntityFinder interfaceEntityFinder, Node node, String description) {
        boolean isSubgraph = this.nodeSubgraphMap.get(node);
        SemanticModel semanticModel = context.semanticModel();
        Project project = context.currentPackage().project();
        FinderContext finderContext = new FinderContext(semanticModel, project, context.moduleId());
        SchemaGenerator schemaGenerator = new SchemaGenerator(node, interfaceEntityFinder, finderContext, description, isSubgraph);
        return schemaGenerator.generate();
    }

    public void addToModifierContextMap(DocumentId documentId, Node node, Schema schema) {
        if (this.modifierContextMap.containsKey(documentId)) {
            GraphqlModifierContext modifierContext = this.modifierContextMap.get(documentId);
            modifierContext.add(node, schema);
        } else {
            GraphqlModifierContext modifierContext = new GraphqlModifierContext();
            modifierContext.add(node, schema);
            this.modifierContextMap.put(documentId, modifierContext);
        }
    }

    public void addToModifierContextMap(DocumentId documentId, Node node, CacheConfigContext cacheConfigContext) {
        if (this.modifierContextMap.containsKey(documentId)) {
            GraphqlModifierContext modifierContext = this.modifierContextMap.get(documentId);
            modifierContext.add(node, cacheConfigContext);
        } else {
            GraphqlModifierContext modifierContext = new GraphqlModifierContext();
            modifierContext.add(node, cacheConfigContext);
            this.modifierContextMap.put(documentId, modifierContext);
        }
    }

    private static boolean isSubgraphService(Node serviceNode, SyntaxNodeAnalysisContext context) {
        List<Object> annotations = new ArrayList<AnnotationSymbol>();
        if (serviceNode.kind() == SyntaxKind.SERVICE_DECLARATION) {
            ServiceDeclarationSymbol serviceDeclarationSymbol = (ServiceDeclarationSymbol)context.semanticModel().symbol(serviceNode).get();
            annotations = serviceDeclarationSymbol.annotations();
        } else if (serviceNode.kind() == SyntaxKind.OBJECT_CONSTRUCTOR) {
            NodeList annotationNodes = ((ObjectConstructorExpressionNode)serviceNode).annotations();
            annotations = annotationNodes.stream().map(annotationNode -> (AnnotationSymbol)context.semanticModel().symbol((Node)annotationNode).get()).collect(Collectors.toList());
        }
        return Utils.hasSubgraphAnnotation(annotations);
    }
}

