/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler.schema.generator;

import io.ballerina.compiler.api.symbols.Documentable;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.projects.ResolvedPackageDependency;
import io.ballerina.stdlib.graphql.commons.types.LinePosition;
import io.ballerina.stdlib.graphql.commons.types.Position;
import io.ballerina.stdlib.graphql.commons.types.ScalarType;
import io.ballerina.stdlib.graphql.commons.types.Type;
import io.ballerina.stdlib.graphql.commons.types.TypeKind;
import io.ballerina.tools.diagnostics.Location;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class GeneratorUtils {
    public static final String UNION_TYPE_NAME_DELIMITER = "_";
    public static final String MAP_KEY_ARGUMENT_NAME = "key";
    public static final String MAP_KEY_ARGUMENT_DESCRIPTION = "[auto-generated]: The key of the value required from a map";
    public static final String SCHEMA_STRING_FIELD = "schemaString";
    public static final String ENABLED_CACHE_FIELD = "enabled";
    public static final String MAX_SIZE_CACHE_FIELD = "maxSize";
    public static final String FIELD_CACHE_CONFIG_FIELD = "fieldCacheConfig";

    private GeneratorUtils() {
    }

    public static String getTypeName(TypeSymbol typeSymbol) {
        switch (typeSymbol.typeKind()) {
            case STRING: 
            case STRING_CHAR: {
                return ScalarType.STRING.getName();
            }
            case INT: {
                return ScalarType.INT.getName();
            }
            case FLOAT: {
                return ScalarType.FLOAT.getName();
            }
            case BOOLEAN: {
                return ScalarType.BOOLEAN.getName();
            }
            case DECIMAL: {
                return ScalarType.DECIMAL.getName();
            }
        }
        if (typeSymbol.getName().isEmpty()) {
            return null;
        }
        return (String)typeSymbol.getName().get();
    }

    public static String getTypeName(List<TypeSymbol> memberTypes) {
        ArrayList<String> typeNames = new ArrayList<String>();
        for (TypeSymbol typeSymbol : memberTypes) {
            if (typeSymbol.getName().isEmpty()) continue;
            typeNames.add((String)typeSymbol.getName().get());
        }
        return String.join((CharSequence)UNION_TYPE_NAME_DELIMITER, typeNames);
    }

    public static String getDescription(Documentable documentable) {
        if (documentable.documentation().isEmpty()) {
            return null;
        }
        if (((Documentation)documentable.documentation().get()).description().isEmpty()) {
            return null;
        }
        return (String)((Documentation)documentable.documentation().get()).description().get();
    }

    public static String getDeprecationReason(Documentable documentable, boolean isDeprecated) {
        if (!isDeprecated) {
            return null;
        }
        if (documentable.documentation().isEmpty()) {
            return null;
        }
        if (((Documentation)documentable.documentation().get()).deprecatedDescription().isEmpty()) {
            return null;
        }
        return (String)((Documentation)documentable.documentation().get()).deprecatedDescription().get();
    }

    public static Type getWrapperType(Type type, TypeKind typeKind) {
        return new Type(typeKind, type);
    }

    public static Position getTypePosition(Optional<Location> location, Symbol symbol, Project project) {
        if (location.isEmpty()) {
            return null;
        }
        Optional<Path> completePath = GeneratorUtils.getFilePathForSymbol(symbol, project);
        String filePath = completePath.isPresent() ? completePath.get().toAbsolutePath().toString() : location.get().lineRange().fileName();
        return new Position(filePath, new LinePosition(location.get().lineRange().startLine().line(), location.get().lineRange().startLine().offset()), new LinePosition(location.get().lineRange().endLine().line(), location.get().lineRange().endLine().offset()));
    }

    public static Optional<Path> getFilePathForSymbol(Symbol symbol, Project project) {
        String moduleName;
        if (symbol.getLocation().isEmpty() || symbol.getModule().isEmpty()) {
            return Optional.empty();
        }
        String orgName = ((ModuleSymbol)symbol.getModule().get()).id().orgName();
        if (GeneratorUtils.isLangLib(orgName, moduleName = ((ModuleSymbol)symbol.getModule().get()).id().moduleName())) {
            return Optional.empty();
        }
        Collection dependencies = project.currentPackage().getResolution().dependencyGraph().getNodes();
        String sourceFile = ((Location)symbol.getLocation().get()).lineRange().fileName();
        for (ResolvedPackageDependency depNode : dependencies) {
            Package depPackage = depNode.packageInstance();
            if (!depPackage.packageOrg().value().equals(orgName)) continue;
            for (ModuleId moduleId : depPackage.moduleIds()) {
                if (!depPackage.module(moduleId).moduleName().toString().equals(moduleName)) continue;
                Module module = depPackage.module(moduleId);
                for (DocumentId docId : module.documentIds()) {
                    if (!module.document(docId).name().equals(sourceFile)) continue;
                    return module.project().documentPath(docId);
                }
                for (DocumentId docId : module.testDocumentIds()) {
                    if (!module.document(docId).name().equals(sourceFile)) continue;
                    return module.project().documentPath(docId);
                }
            }
        }
        return Optional.empty();
    }

    private static boolean isLangLib(String orgName, String moduleName) {
        return orgName.equals("ballerina") && moduleName.startsWith("lang.");
    }
}

