/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler.schema.generator;

import io.ballerina.stdlib.graphql.commons.types.DirectiveLocation;
import io.ballerina.stdlib.graphql.commons.types.EnumValue;
import io.ballerina.stdlib.graphql.commons.types.Field;
import io.ballerina.stdlib.graphql.commons.types.FieldName;
import io.ballerina.stdlib.graphql.commons.types.InputValue;
import io.ballerina.stdlib.graphql.commons.types.IntrospectionField;
import io.ballerina.stdlib.graphql.commons.types.IntrospectionType;
import io.ballerina.stdlib.graphql.commons.types.ScalarType;
import io.ballerina.stdlib.graphql.commons.types.Schema;
import io.ballerina.stdlib.graphql.commons.types.Type;
import io.ballerina.stdlib.graphql.commons.types.TypeKind;
import io.ballerina.stdlib.graphql.commons.types.TypeName;
import io.ballerina.stdlib.graphql.compiler.schema.generator.GeneratorUtils;

public class IntrospectionTypeCreator {
    private final Schema schema;
    private static final String INCLUDE_DEPRECATED_ARG_NAME = "includeDeprecated";
    private static final String INCLUDE_DEPRECATED_DEFAULT_VALUE = "false";

    public IntrospectionTypeCreator(Schema schema) {
        this.schema = schema;
    }

    public void addIntrospectionTypes() {
        this.addDefaultSchemaTypes();
        this.addFieldsToSchemaType();
        this.addFieldsToTypeType();
        this.addFieldsToFieldType();
        this.addFieldsToInputValueType();
        this.addFieldsToEnumValueType();
        this.addValuesToTypeKindType();
        this.addFieldsToDirectiveType();
        this.addValuesToDirectiveLocationType();
    }

    private void addDefaultSchemaTypes() {
        this.schema.addType(ScalarType.STRING);
        this.schema.addType(ScalarType.BOOLEAN);
        for (IntrospectionType type : IntrospectionType.values()) {
            this.addType(type.getName(), type.getTypeKind(), type.getDescription());
        }
    }

    private void addFieldsToSchemaType() {
        Type schemaType = this.schema.getType(IntrospectionType.SCHEMA.getName());
        schemaType.addField(this.getDescriptionField());
        schemaType.addField(this.getTypesField());
        schemaType.addField(IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.QUERY_TYPE, GeneratorUtils.getWrapperType(this.getTypeType(), TypeKind.NON_NULL)));
        schemaType.addField(IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.MUTATION_TYPE, this.getTypeType()));
        schemaType.addField(IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.SUBSCRIPTION_TYPE, this.getTypeType()));
        schemaType.addField(this.getDirectivesField());
    }

    private void addFieldsToTypeType() {
        Type type = this.schema.getType(IntrospectionType.TYPE.getName());
        type.addField(IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.KIND, GeneratorUtils.getWrapperType(this.schema.getType(TypeName.TYPE_KIND.getName()), TypeKind.NON_NULL)));
        type.addField(IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.NAME, this.getStringType()));
        type.addField(this.getDescriptionField());
        type.addField(this.getFieldsField());
        type.addField(this.getInterfacesField());
        type.addField(this.getPossibleTypesField());
        type.addField(this.getEnumValuesField());
        type.addField(this.getInputFieldsField());
        type.addField(IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.OF_TYPE, this.getTypeType()));
    }

    private void addFieldsToFieldType() {
        Type type = this.schema.getType(IntrospectionType.FIELD.getName());
        type.addField(IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.NAME, this.getNonNullStringType()));
        type.addField(this.getDescriptionField());
        type.addField(this.getArgsField());
        type.addField(IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.TYPE, GeneratorUtils.getWrapperType(this.getTypeType(), TypeKind.NON_NULL)));
        type.addField(this.getIsDeprecatedField());
        type.addField(this.getDeprecationReasonField());
    }

    private void addFieldsToInputValueType() {
        Type type = this.schema.getType(IntrospectionType.INPUT_VALUE.getName());
        type.addField(IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.NAME, this.getNonNullStringType()));
        type.addField(this.getDescriptionField());
        type.addField(IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.TYPE, GeneratorUtils.getWrapperType(this.getTypeType(), TypeKind.NON_NULL)));
        type.addField(IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.DEFAULT_VALUE, this.getStringType()));
    }

    private void addFieldsToEnumValueType() {
        Type type = this.schema.getType(IntrospectionType.ENUM_VALUE.getName());
        type.addField(IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.NAME, this.getNonNullStringType()));
        type.addField(this.getDescriptionField());
        type.addField(this.getIsDeprecatedField());
        type.addField(this.getDeprecationReasonField());
    }

    private void addValuesToTypeKindType() {
        Type typeKindType = this.schema.getType(IntrospectionType.TYPE_KIND.getName());
        for (TypeKind typeKind : TypeKind.values()) {
            typeKindType.addEnumValue(new EnumValue(typeKind.name(), typeKind.getDescription()));
        }
    }

    private void addFieldsToDirectiveType() {
        Type type = this.schema.getType(IntrospectionType.DIRECTIVE.getName());
        type.addField(IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.NAME, this.getNonNullStringType()));
        type.addField(this.getDescriptionField());
        type.addField(this.getLocationsField());
        type.addField(this.getArgsField());
    }

    private void addValuesToDirectiveLocationType() {
        Type directiveLocationType = this.schema.getType(IntrospectionType.DIRECTIVE_LOCATION.getName());
        for (DirectiveLocation location : DirectiveLocation.values()) {
            directiveLocationType.addEnumValue(new EnumValue(location.name(), location.getDescription()));
        }
    }

    private void addType(String name, TypeKind kind, String description) {
        this.schema.addType(name, kind, description);
    }

    private Field getDescriptionField() {
        Type stringType = this.getStringType();
        return IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.DESCRIPTION, stringType);
    }

    private Field getTypesField() {
        Type arrayMemberType = GeneratorUtils.getWrapperType(this.getTypeType(), TypeKind.NON_NULL);
        Type arrayType = GeneratorUtils.getWrapperType(GeneratorUtils.getWrapperType(arrayMemberType, TypeKind.LIST), TypeKind.NON_NULL);
        return IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.TYPES, arrayType);
    }

    private Field getDirectivesField() {
        Type arrayMemberType = GeneratorUtils.getWrapperType(this.getDirectiveType(), TypeKind.NON_NULL);
        Type arrayType = GeneratorUtils.getWrapperType(GeneratorUtils.getWrapperType(arrayMemberType, TypeKind.LIST), TypeKind.NON_NULL);
        return IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.DIRECTIVES, arrayType);
    }

    private Field getFieldsField() {
        Type arrayMemberType = GeneratorUtils.getWrapperType(this.schema.getType(TypeName.FIELD.getName()), TypeKind.NON_NULL);
        Type arrayType = GeneratorUtils.getWrapperType(arrayMemberType, TypeKind.LIST);
        Field field = new Field(FieldName.FIELDS.getName(), arrayType);
        field.addArg(this.getIncludeDeprecatedArg());
        return field;
    }

    private Field getInterfacesField() {
        Type arrayMemberType = GeneratorUtils.getWrapperType(this.getTypeType(), TypeKind.NON_NULL);
        Type arrayType = GeneratorUtils.getWrapperType(arrayMemberType, TypeKind.LIST);
        return IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.INTERFACES, arrayType);
    }

    private Field getPossibleTypesField() {
        Type arrayMemberType = GeneratorUtils.getWrapperType(this.getTypeType(), TypeKind.NON_NULL);
        Type arrayType = GeneratorUtils.getWrapperType(arrayMemberType, TypeKind.LIST);
        return IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.POSSIBLE_TYPES, arrayType);
    }

    private Field getEnumValuesField() {
        Type arrayMemberType = GeneratorUtils.getWrapperType(this.getEnumValueType(), TypeKind.NON_NULL);
        Type arrayType = GeneratorUtils.getWrapperType(arrayMemberType, TypeKind.LIST);
        Field enumValuesField = IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.ENUM_VALUES, arrayType);
        enumValuesField.addArg(this.getIncludeDeprecatedArg());
        return enumValuesField;
    }

    private Field getInputFieldsField() {
        Type arrayMemberType = GeneratorUtils.getWrapperType(this.getInputValueType(), TypeKind.NON_NULL);
        Type arrayType = GeneratorUtils.getWrapperType(arrayMemberType, TypeKind.LIST);
        return IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.INPUT_FIELDS, arrayType);
    }

    private Field getArgsField() {
        Type arrayMemberType = GeneratorUtils.getWrapperType(this.getInputValueType(), TypeKind.NON_NULL);
        Type arrayType = GeneratorUtils.getWrapperType(GeneratorUtils.getWrapperType(arrayMemberType, TypeKind.LIST), TypeKind.NON_NULL);
        return IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.ARGS, arrayType);
    }

    private Field getIsDeprecatedField() {
        Type type = GeneratorUtils.getWrapperType(this.getBooleanType(), TypeKind.NON_NULL);
        return IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.IS_DEPRECATED, type);
    }

    private Field getLocationsField() {
        Type directiveLocationType = this.schema.getType(IntrospectionType.DIRECTIVE_LOCATION.getName());
        Type arrayMemberType = GeneratorUtils.getWrapperType(directiveLocationType, TypeKind.NON_NULL);
        Type arrayType = GeneratorUtils.getWrapperType(GeneratorUtils.getWrapperType(arrayMemberType, TypeKind.LIST), TypeKind.NON_NULL);
        return IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.LOCATIONS, arrayType);
    }

    private Field getDeprecationReasonField() {
        return IntrospectionTypeCreator.getIntrospectionField(IntrospectionField.DEPRECATED_REASON, this.getStringType());
    }

    private InputValue getIncludeDeprecatedArg() {
        return new InputValue(INCLUDE_DEPRECATED_ARG_NAME, this.getBooleanType(), null, INCLUDE_DEPRECATED_DEFAULT_VALUE);
    }

    private Type getNonNullStringType() {
        return GeneratorUtils.getWrapperType(this.getStringType(), TypeKind.NON_NULL);
    }

    private Type getStringType() {
        return this.schema.addType(ScalarType.STRING);
    }

    private Type getBooleanType() {
        return this.schema.addType(ScalarType.BOOLEAN);
    }

    private Type getTypeType() {
        return this.schema.getType(IntrospectionType.TYPE.getName());
    }

    private Type getDirectiveType() {
        return this.schema.getType(IntrospectionType.DIRECTIVE.getName());
    }

    private Type getEnumValueType() {
        return this.schema.getType(IntrospectionType.ENUM_VALUE.getName());
    }

    private Type getInputValueType() {
        return this.schema.getType(IntrospectionType.INPUT_VALUE.getName());
    }

    private static Field getIntrospectionField(IntrospectionField introspectionField, Type type) {
        return new Field(introspectionField.getName(), introspectionField.getDescription(), type);
    }
}

