/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler.service;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.stdlib.graphql.compiler.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InterfaceEntityFinder {
    private final Map<String, List<Symbol>> interfaceImplementations = new HashMap<String, List<Symbol>>();
    private final Map<String, TypeReferenceTypeSymbol> possibleInterfaces = new HashMap<String, TypeReferenceTypeSymbol>();
    private final Map<String, Symbol> entities = new HashMap<String, Symbol>();
    private static final String ENTITY_ANNOTATION = "Entity";

    public void populateInterfacesAndEntities(SemanticModel semanticModel) {
        for (Symbol symbol : semanticModel.moduleSymbols()) {
            if (symbol.getName().isEmpty()) continue;
            if (Utils.isServiceClass(symbol) || Utils.isServiceObjectDefinition(symbol)) {
                this.findPossibleInterfaces(symbol);
            }
            if (!this.isEntity(symbol)) continue;
            String entityName = (String)symbol.getName().get();
            this.entities.put(entityName, symbol);
        }
    }

    public boolean isPossibleInterface(String name) {
        return this.possibleInterfaces.containsKey(name);
    }

    public List<Symbol> getImplementations(String interfaceName) {
        return this.interfaceImplementations.get(interfaceName);
    }

    public Map<String, Symbol> getEntities() {
        return this.entities;
    }

    private void findPossibleInterfaces(Symbol serviceObjectTypeDefinitionOrServiceClass) {
        ObjectTypeSymbol objectTypeSymbol = Utils.getObjectTypeSymbol(serviceObjectTypeDefinitionOrServiceClass);
        for (TypeSymbol typeSymbol : objectTypeSymbol.typeInclusions()) {
            if (!Utils.isServiceObjectReference(typeSymbol) || typeSymbol.getName().isEmpty()) continue;
            String interfaceName = (String)typeSymbol.getName().get();
            this.addPossibleInterface(interfaceName, (TypeReferenceTypeSymbol)typeSymbol);
            this.addInterfaceImplementation(interfaceName, serviceObjectTypeDefinitionOrServiceClass);
        }
    }

    private void addInterfaceImplementation(String interfaceName, Symbol implementation) {
        if (this.interfaceImplementations.containsKey(interfaceName)) {
            List<Symbol> interfaces = this.interfaceImplementations.get(interfaceName);
            if (!interfaces.contains(implementation)) {
                this.interfaceImplementations.get(interfaceName).add(implementation);
            }
        } else {
            ArrayList<Symbol> interfaceClasses = new ArrayList<Symbol>();
            interfaceClasses.add(implementation);
            this.interfaceImplementations.put(interfaceName, interfaceClasses);
        }
    }

    private void addPossibleInterface(String interfaceName, TypeReferenceTypeSymbol objectTypeReference) {
        if (this.possibleInterfaces.containsKey(interfaceName)) {
            return;
        }
        this.possibleInterfaces.put(interfaceName, objectTypeReference);
    }

    private boolean isEntity(Symbol symbol) {
        List annotations;
        if (Utils.isServiceClass(symbol)) {
            annotations = ((ClassSymbol)symbol).annotations();
        } else if (Utils.isRecordTypeDefinition(symbol)) {
            annotations = ((TypeDefinitionSymbol)symbol).annotations();
        } else {
            return false;
        }
        return this.hasEntityAnnotation(annotations);
    }

    private boolean hasEntityAnnotation(List<AnnotationSymbol> annotations) {
        for (AnnotationSymbol annotation : annotations) {
            if (!io.ballerina.stdlib.graphql.commons.utils.Utils.isSubgraphModuleSymbol((Symbol)annotation) || annotation.getName().isEmpty() || !((String)annotation.getName().get()).equals(ENTITY_ANNOTATION)) continue;
            return true;
        }
        return false;
    }
}

