/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler.service.validator;

import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.stdlib.graphql.compiler.FinderContext;
import io.ballerina.stdlib.graphql.compiler.service.validator.EntityAnnotationNodeVisitor;
import java.util.Collection;
import java.util.Optional;

public class EntityAnnotationFinder {
    private final FinderContext context;
    private final AnnotationSymbol annotationSymbol;
    private final String entityName;

    public EntityAnnotationFinder(FinderContext context, AnnotationSymbol annotationSymbol, String entityName) {
        this.context = context;
        this.annotationSymbol = annotationSymbol;
        this.entityName = entityName;
    }

    public Optional<AnnotationNode> find() {
        if (this.annotationSymbol.getName().isEmpty()) {
            return Optional.empty();
        }
        return this.getAnnotationNodeFromModule();
    }

    private Optional<AnnotationNode> getAnnotationNodeFromModule() {
        Module currentModule = this.context.project().currentPackage().module(this.context.moduleId());
        Collection documentIds = currentModule.documentIds();
        EntityAnnotationNodeVisitor directiveVisitor = new EntityAnnotationNodeVisitor(this.context.semanticModel(), this.annotationSymbol, this.entityName);
        for (DocumentId documentId : documentIds) {
            Node rootNode = currentModule.document(documentId).syntaxTree().rootNode();
            rootNode.accept((NodeVisitor)directiveVisitor);
            if (!directiveVisitor.getNode().isPresent()) continue;
            break;
        }
        return directiveVisitor.getNode();
    }
}

