/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler.service.validator;

import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.EnumSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.StreamTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TableTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.PathSegmentList;
import io.ballerina.compiler.api.symbols.resourcepath.ResourcePath;
import io.ballerina.compiler.api.symbols.resourcepath.util.PathSegment;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.ObjectConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.graphql.commons.types.TypeName;
import io.ballerina.stdlib.graphql.commons.utils.TypeUtils;
import io.ballerina.stdlib.graphql.compiler.CacheConfigContext;
import io.ballerina.stdlib.graphql.compiler.FinderContext;
import io.ballerina.stdlib.graphql.compiler.Utils;
import io.ballerina.stdlib.graphql.compiler.diagnostics.CompilationDiagnostic;
import io.ballerina.stdlib.graphql.compiler.service.InterfaceEntityFinder;
import io.ballerina.stdlib.graphql.compiler.service.validator.ResourceConfigAnnotationFinder;
import io.ballerina.stdlib.graphql.compiler.service.validator.ValidatorUtils;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ServiceValidator {
    private final Set<Symbol> visitedClassesAndObjectTypeDefinitions = new HashSet<Symbol>();
    private final Set<String> validatedInputTypesHavingDefaultFields = new HashSet<String>();
    private final List<TypeSymbol> existingInputObjectTypes = new ArrayList<TypeSymbol>();
    private final List<TypeSymbol> existingReturnTypes = new ArrayList<TypeSymbol>();
    private final InterfaceEntityFinder interfaceEntityFinder;
    private final SyntaxNodeAnalysisContext context;
    private final Node serviceNode;
    private int arrayDimension = 0;
    private boolean errorOccurred;
    private boolean hasQueryType;
    private final boolean isSubgraph;
    private TypeSymbol rootInputParameterTypeSymbol;
    private final List<String> currentFieldPath;
    private CacheConfigContext cacheConfigContext;
    private static final String FIELD_PATH_SEPARATOR = ".";
    private static final String PREFETCH_METHOD_PREFIX = "pre";
    private static final String PREFETCH_METHOD_NAME_CONFIG = "prefetchMethodName";
    private static final String KEY = "key";
    private static final String INPUT_OBJECT_FIELD = "input object field";
    private static final String PARAMETER = "parameter";
    private static final String CACHE_CONFIG = "cacheConfig";

    public ServiceValidator(SyntaxNodeAnalysisContext context, Node serviceNode, InterfaceEntityFinder interfaceEntityFinder, boolean isSubgraph, CacheConfigContext cacheConfigContext) {
        this.context = context;
        this.serviceNode = serviceNode;
        this.interfaceEntityFinder = interfaceEntityFinder;
        this.errorOccurred = false;
        this.hasQueryType = false;
        this.currentFieldPath = new ArrayList<String>();
        this.isSubgraph = isSubgraph;
        this.cacheConfigContext = cacheConfigContext;
    }

    public void validate() {
        String modulePrefix = io.ballerina.stdlib.graphql.commons.utils.Utils.getGraphqlModulePrefix((ModulePartNode)this.context.node().syntaxTree().rootNode());
        if (this.serviceNode.kind() == SyntaxKind.SERVICE_DECLARATION) {
            this.validateServiceDeclaration(modulePrefix);
        } else if (this.serviceNode.kind() == SyntaxKind.OBJECT_CONSTRUCTOR) {
            this.validateServiceObject(modulePrefix);
        }
        this.validateEntities();
    }

    private void validateEntities() {
        for (Map.Entry<String, Symbol> entry : this.interfaceEntityFinder.getEntities().entrySet()) {
            AnnotationSymbol entityAnnotationSymbol = Utils.getEntityAnnotationSymbol(entry.getValue());
            if (entityAnnotationSymbol == null) continue;
            FinderContext finderContext = new FinderContext(this.context);
            AnnotationNode annotationNode = Utils.getEntityAnnotationNode(entityAnnotationSymbol, entry.getKey(), finderContext);
            if (annotationNode == null) continue;
            this.validateEntityAnnotation(annotationNode);
        }
    }

    private void validateEntityAnnotation(AnnotationNode entityAnnotation) {
        if (entityAnnotation.annotValue().isEmpty()) {
            return;
        }
        for (MappingFieldNode fieldNode : ((MappingConstructorExpressionNode)entityAnnotation.annotValue().get()).fields()) {
            IdentifierToken fieldNameToken;
            String fieldName;
            if (fieldNode.kind() != SyntaxKind.SPECIFIC_FIELD) {
                this.addDiagnostic(CompilationDiagnostic.PROVIDE_KEY_VALUE_PAIR_FOR_ENTITY_ANNOTATION, (Location)fieldNode.location());
                continue;
            }
            SpecificFieldNode specificFieldNode = (SpecificFieldNode)fieldNode;
            Node fieldNameNode = specificFieldNode.fieldName();
            if (fieldNameNode.kind() != SyntaxKind.IDENTIFIER_TOKEN || !KEY.equals(fieldName = (fieldNameToken = (IdentifierToken)fieldNameNode).text().trim())) continue;
            this.validateKeyField(specificFieldNode);
        }
    }

    private void validateKeyField(SpecificFieldNode specificFieldNode) {
        if (specificFieldNode.valueExpr().isEmpty()) {
            this.addDiagnostic(CompilationDiagnostic.PROVIDE_A_STRING_LITERAL_OR_AN_ARRAY_OF_STRING_LITERALS_FOR_KEY_FIELD, (Location)specificFieldNode.location(), KEY);
            return;
        }
        ExpressionNode keyFieldExpression = (ExpressionNode)specificFieldNode.valueExpr().get();
        if (keyFieldExpression.kind() == SyntaxKind.LIST_CONSTRUCTOR) {
            for (Node expression : ((ListConstructorExpressionNode)keyFieldExpression).expressions()) {
                this.validateKeyFieldValue(expression);
            }
            return;
        }
        this.validateKeyFieldValue((Node)keyFieldExpression);
    }

    public void validateKeyFieldValue(Node expression) {
        if (expression.kind() != SyntaxKind.STRING_LITERAL) {
            this.addDiagnostic(CompilationDiagnostic.PROVIDE_A_STRING_LITERAL_OR_AN_ARRAY_OF_STRING_LITERALS_FOR_KEY_FIELD, (Location)expression.location(), KEY);
        }
    }

    private void validateServiceObject(String modulePrefix) {
        ObjectConstructorExpressionNode objectConstructorExpNode = (ObjectConstructorExpressionNode)this.serviceNode;
        List<Node> serviceMethodNodes = this.getServiceMethodNodes((NodeList<Node>)objectConstructorExpNode.members());
        if (!objectConstructorExpNode.annotations().isEmpty()) {
            this.validateAnnotation(objectConstructorExpNode, modulePrefix);
        }
        this.validateRootServiceMethods(serviceMethodNodes, (Location)objectConstructorExpNode.location());
        if (!this.hasQueryType) {
            this.addDiagnostic(CompilationDiagnostic.MISSING_RESOURCE_FUNCTIONS, (Location)objectConstructorExpNode.location());
        }
        this.validateEntitiesResolverReturnTypes();
    }

    private void validateServiceDeclaration(String modulePrefix) {
        ServiceDeclarationNode node = (ServiceDeclarationNode)this.serviceNode;
        ServiceDeclarationSymbol serviceDeclarationSymbol = (ServiceDeclarationSymbol)this.context.semanticModel().symbol((Node)node).get();
        if (serviceDeclarationSymbol.listenerTypes().size() > 1) {
            this.addDiagnostic(CompilationDiagnostic.INVALID_MULTIPLE_LISTENERS, (Location)node.location());
        }
        this.validateService(modulePrefix);
    }

    public boolean isErrorOccurred() {
        return this.errorOccurred;
    }

    public CacheConfigContext getCacheConfigContext() {
        return this.cacheConfigContext;
    }

    private void validateService(String modulePrefix) {
        ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)this.context.node();
        List<Node> serviceMethodNodes = this.getServiceMethodNodes((NodeList<Node>)serviceDeclarationNode.members());
        if (serviceDeclarationNode.metadata().isPresent()) {
            this.validateAnnotation((MetadataNode)serviceDeclarationNode.metadata().get(), modulePrefix);
        }
        this.validateRootServiceMethods(serviceMethodNodes, (Location)serviceDeclarationNode.location());
        if (!this.hasQueryType) {
            this.addDiagnostic(CompilationDiagnostic.MISSING_RESOURCE_FUNCTIONS, (Location)serviceDeclarationNode.location());
        }
        this.validateEntitiesResolverReturnTypes();
    }

    private void validateAnnotation(MetadataNode metadataNode, String modulePrefix) {
        for (AnnotationNode annotationNode : metadataNode.annotations()) {
            if (!Utils.isGraphqlServiceConfig(annotationNode, modulePrefix)) continue;
            this.validateServiceAnnotation(annotationNode);
        }
    }

    private void validateAnnotation(ObjectConstructorExpressionNode node, String modulePrefix) {
        for (AnnotationNode annotationNode : node.annotations()) {
            if (!Utils.isGraphqlServiceConfig(annotationNode, modulePrefix)) continue;
            this.validateServiceAnnotation(annotationNode);
        }
    }

    private void validateServiceAnnotation(AnnotationNode annotationNode) {
        if (annotationNode.annotValue().isPresent()) {
            for (MappingFieldNode field : ((MappingConstructorExpressionNode)annotationNode.annotValue().get()).fields()) {
                this.validateServiceAnnotationField(field);
            }
        }
    }

    private void validateServiceAnnotationField(MappingFieldNode field) {
        IdentifierToken identifierToken;
        String identifierName;
        SpecificFieldNode specificFieldNode;
        Node fieldName;
        if (field.kind() == SyntaxKind.SPECIFIC_FIELD && (fieldName = (specificFieldNode = (SpecificFieldNode)field).fieldName()).kind() == SyntaxKind.IDENTIFIER_TOKEN && ("schemaString".equals(identifierName = (identifierToken = (IdentifierToken)fieldName).text()) || "fieldCacheConfig".equals(identifierName))) {
            this.addDiagnostic(CompilationDiagnostic.INVALID_MODIFICATION_OF_SERVICE_CONFIG_FIELD, (Location)this.serviceNode.location(), identifierName);
        }
    }

    private List<Node> getServiceMethodNodes(NodeList<Node> serviceMembers) {
        return serviceMembers.stream().filter(this::isServiceMethod).collect(Collectors.toList());
    }

    private boolean isServiceMethod(Node node) {
        if (this.context.semanticModel().symbol(node).isEmpty()) {
            return false;
        }
        Symbol symbol = (Symbol)this.context.semanticModel().symbol(node).get();
        return symbol.kind() == SymbolKind.RESOURCE_METHOD || symbol.kind() == SymbolKind.METHOD;
    }

    private void validateRootServiceMethods(List<Node> serviceMethods, Location location) {
        List<MethodSymbol> methodSymbols = this.getMethodSymbols(serviceMethods);
        for (Node methodNode : serviceMethods) {
            MethodSymbol methodSymbol = (MethodSymbol)this.context.semanticModel().symbol(methodNode).get();
            NodeLocation methodLocation = methodNode.location();
            if (Utils.isRemoteMethod(methodSymbol)) {
                this.currentFieldPath.add(TypeName.MUTATION.getName());
                this.validateRemoteMethod(methodSymbol, (Location)methodLocation);
                this.currentFieldPath.remove(TypeName.MUTATION.getName());
                this.validatePrefetchMethodMapping(methodSymbol, methodSymbols, location);
                continue;
            }
            if (!Utils.isResourceMethod(methodSymbol)) continue;
            this.validateRootServiceResourceMethod((ResourceMethodSymbol)methodSymbol, (Location)methodLocation);
            this.validatePrefetchMethodMapping(methodSymbol, methodSymbols, location);
        }
    }

    private void validatePrefetchMethodMapping(MethodSymbol methodSymbol, List<MethodSymbol> serviceMethods, Location location) {
        String graphqlFieldName = this.getGraphqlFieldName(methodSymbol);
        String prefetchMethodName = this.getDefaultPrefetchMethodName(graphqlFieldName);
        Location methodLocation = ValidatorUtils.getLocation((Symbol)methodSymbol, location);
        boolean hasPrefetchMethodConfig = false;
        if (Utils.hasResourceConfigAnnotation(methodSymbol)) {
            FinderContext finderContext = new FinderContext(this.context);
            ResourceConfigAnnotationFinder resourceConfigAnnotationFinder = new ResourceConfigAnnotationFinder(finderContext, methodSymbol);
            Optional<AnnotationNode> annotation = resourceConfigAnnotationFinder.find();
            boolean bl = hasPrefetchMethodConfig = annotation.isPresent() && this.hasPrefetchMethodNameConfig(annotation.get());
            if (hasPrefetchMethodConfig) {
                prefetchMethodName = this.getPrefetchMethodName(annotation.get());
                if (prefetchMethodName == null) {
                    this.addDiagnostic(CompilationDiagnostic.UNABLE_TO_VALIDATE_PREFETCH_METHOD, (Location)annotation.get().location(), PREFETCH_METHOD_NAME_CONFIG, graphqlFieldName);
                    return;
                }
                if (this.isSubscription(methodSymbol)) {
                    this.addDiagnostic(CompilationDiagnostic.INVALID_USAGE_OF_PREFETCH_METHOD_NAME_CONFIG, (Location)annotation.get().location(), PREFETCH_METHOD_NAME_CONFIG, graphqlFieldName);
                    return;
                }
            }
        }
        if (this.isSubscription(methodSymbol)) {
            return;
        }
        MethodSymbol prefetchMethod = this.findPrefetchMethod(prefetchMethodName, serviceMethods);
        if (prefetchMethod == null) {
            if (hasPrefetchMethodConfig) {
                this.addDiagnostic(CompilationDiagnostic.UNABLE_TO_FIND_PREFETCH_METHOD, methodLocation, prefetchMethodName, graphqlFieldName);
            }
            return;
        }
        this.validatePrefetchMethodSignature(prefetchMethod, methodSymbol, location);
    }

    private boolean isSubscription(MethodSymbol methodSymbol) {
        return Utils.isResourceMethod(methodSymbol) && "subscribe".equals(Utils.getAccessor((ResourceMethodSymbol)methodSymbol));
    }

    private String getGraphqlFieldName(MethodSymbol methodSymbol) {
        return Utils.isResourceMethod(methodSymbol) ? this.getFieldPath((ResourceMethodSymbol)methodSymbol) : methodSymbol.getName().orElse("");
    }

    private String getPrefetchMethodName(AnnotationNode annotation) {
        MappingConstructorExpressionNode mappingConstructorExpressionNode = (MappingConstructorExpressionNode)annotation.annotValue().get();
        for (MappingFieldNode field : mappingConstructorExpressionNode.fields()) {
            IdentifierToken identifierToken;
            String identifierName;
            SpecificFieldNode specificFieldNode;
            Node fieldName;
            if (field.kind() != SyntaxKind.SPECIFIC_FIELD || (fieldName = (specificFieldNode = (SpecificFieldNode)field).fieldName()).kind() != SyntaxKind.IDENTIFIER_TOKEN || !PREFETCH_METHOD_NAME_CONFIG.equals(identifierName = (identifierToken = (IdentifierToken)fieldName).text())) continue;
            return Utils.getStringValue(specificFieldNode);
        }
        return null;
    }

    private void updateCacheConfigContextFromAnnot(AnnotationNode annotation) {
        MappingConstructorExpressionNode mappingConstructorExpressionNode = (MappingConstructorExpressionNode)annotation.annotValue().get();
        for (MappingFieldNode field : mappingConstructorExpressionNode.fields()) {
            boolean enabled;
            IdentifierToken identifierToken;
            String identifierName;
            SpecificFieldNode specificFieldNode;
            Node fieldName;
            if (field.kind() != SyntaxKind.SPECIFIC_FIELD || (fieldName = (specificFieldNode = (SpecificFieldNode)field).fieldName()).kind() != SyntaxKind.IDENTIFIER_TOKEN || !CACHE_CONFIG.equals(identifierName = (identifierToken = (IdentifierToken)fieldName).text()) || !specificFieldNode.valueExpr().isPresent() || !(enabled = Utils.getBooleanValue((MappingConstructorExpressionNode)specificFieldNode.valueExpr().get()))) continue;
            int maxSize = Utils.getMaxSize((MappingConstructorExpressionNode)specificFieldNode.valueExpr().get());
            this.cacheConfigContext.setEnabled(enabled);
            this.cacheConfigContext.setMaxSize(maxSize);
        }
    }

    private boolean hasPrefetchMethodNameConfig(AnnotationNode annotation) {
        if (annotation.annotValue().isEmpty()) {
            return false;
        }
        MappingConstructorExpressionNode mappingConstructorExpressionNode = (MappingConstructorExpressionNode)annotation.annotValue().get();
        for (MappingFieldNode field : mappingConstructorExpressionNode.fields()) {
            SpecificFieldNode specificFieldNode;
            Node fieldName;
            if (field.kind() != SyntaxKind.SPECIFIC_FIELD || (fieldName = (specificFieldNode = (SpecificFieldNode)field).fieldName()).kind() != SyntaxKind.IDENTIFIER_TOKEN) continue;
            IdentifierToken identifierToken = (IdentifierToken)fieldName;
            String identifierName = identifierToken.text();
            return PREFETCH_METHOD_NAME_CONFIG.equals(identifierName);
        }
        return false;
    }

    private boolean hasCacheConfig(AnnotationNode annotation) {
        if (annotation.annotValue().isEmpty()) {
            return false;
        }
        MappingConstructorExpressionNode mappingConstructorExpressionNode = (MappingConstructorExpressionNode)annotation.annotValue().get();
        for (MappingFieldNode field : mappingConstructorExpressionNode.fields()) {
            IdentifierToken identifierToken;
            String identifierName;
            SpecificFieldNode specificFieldNode;
            Node fieldName;
            if (field.kind() != SyntaxKind.SPECIFIC_FIELD || (fieldName = (specificFieldNode = (SpecificFieldNode)field).fieldName()).kind() != SyntaxKind.IDENTIFIER_TOKEN || !CACHE_CONFIG.equals(identifierName = (identifierToken = (IdentifierToken)fieldName).text())) continue;
            return true;
        }
        return false;
    }

    private MethodSymbol findPrefetchMethod(String prefetchMethodName, List<MethodSymbol> serviceMethods) {
        return serviceMethods.stream().filter(method -> method.kind() == SymbolKind.METHOD && !Utils.isRemoteMethod(method) && method.getName().orElse("").equals(prefetchMethodName)).findFirst().orElse(null);
    }

    private void validateEntitiesResolverReturnTypes() {
        if (!this.isSubgraph) {
            return;
        }
        this.currentFieldPath.add(TypeName.QUERY.getName());
        this.currentFieldPath.add("_entities");
        for (Symbol symbol : this.interfaceEntityFinder.getEntities().values()) {
            if (this.existingReturnTypes.contains(symbol)) continue;
            Location location = (Location)symbol.getLocation().get();
            if (symbol.kind() == SymbolKind.CLASS) {
                this.validateReturnTypeClass((ClassSymbol)symbol, location);
                continue;
            }
            if (symbol.kind() != SymbolKind.TYPE_DEFINITION) continue;
            RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)((TypeDefinitionSymbol)symbol).typeDescriptor();
            String recordName = symbol.getName().orElse(recordTypeSymbol.signature());
            this.validateReturnType(recordTypeSymbol, (TypeSymbol)recordTypeSymbol, location, recordName);
        }
        this.currentFieldPath.remove("_entities");
        this.currentFieldPath.remove(TypeName.QUERY.getName());
    }

    private void validateRootServiceResourceMethod(ResourceMethodSymbol methodSymbol, Location location) {
        String accessor;
        String resourceMethodName = this.getFieldPath(methodSymbol);
        Location accessorLocation = ValidatorUtils.getLocation((Symbol)methodSymbol, location);
        if (ValidatorUtils.isReservedFederatedResolverName(resourceMethodName)) {
            this.addDiagnostic(CompilationDiagnostic.INVALID_USE_OF_RESERVED_RESOURCE_PATH, accessorLocation, resourceMethodName);
        }
        if ("subscribe".equals(accessor = Utils.getAccessor(methodSymbol))) {
            this.currentFieldPath.add(TypeName.SUBSCRIPTION.getName());
            this.validateSubscribeResource(methodSymbol, location);
            this.currentFieldPath.remove(TypeName.SUBSCRIPTION.getName());
        } else if ("get".equals(accessor)) {
            this.currentFieldPath.add(TypeName.QUERY.getName());
            this.hasQueryType = true;
            this.validateGetResource(methodSymbol, location);
            this.currentFieldPath.remove(TypeName.QUERY.getName());
        } else {
            this.addDiagnostic(CompilationDiagnostic.INVALID_ROOT_RESOURCE_ACCESSOR, accessorLocation, accessor, resourceMethodName);
        }
    }

    private List<MethodSymbol> getMethodSymbols(List<Node> serviceMembers) {
        return serviceMembers.stream().filter(this::isServiceMethod).map(methodNode -> (MethodSymbol)this.context.semanticModel().symbol(methodNode).get()).collect(Collectors.toList());
    }

    private void validateResourceMethod(ResourceMethodSymbol methodSymbol, Location location) {
        String accessor = Utils.getAccessor(methodSymbol);
        if (!"get".equals(accessor)) {
            Location accessorLocation = ValidatorUtils.getLocation((Symbol)methodSymbol, location);
            this.addDiagnostic(CompilationDiagnostic.INVALID_RESOURCE_FUNCTION_ACCESSOR, accessorLocation, accessor, this.getFieldPath(methodSymbol));
        }
        this.validateGetResource(methodSymbol, ValidatorUtils.getLocation((Symbol)methodSymbol, location));
    }

    private void validateGetResource(ResourceMethodSymbol methodSymbol, Location location) {
        String path = this.getFieldPath(methodSymbol);
        this.currentFieldPath.add(path);
        this.validateResourcePath(methodSymbol, location);
        this.validateMethod((MethodSymbol)methodSymbol, location);
        this.updateCacheConfigContext((MethodSymbol)methodSymbol);
        this.currentFieldPath.remove(path);
    }

    private void updateCacheConfigContext(MethodSymbol methodSymbol) {
        FinderContext finderContext;
        ResourceConfigAnnotationFinder resourceConfigAnnotationFinder;
        Optional<AnnotationNode> annotation;
        if (Utils.hasResourceConfigAnnotation(methodSymbol) && (annotation = (resourceConfigAnnotationFinder = new ResourceConfigAnnotationFinder(finderContext = new FinderContext(this.context), methodSymbol)).find()).isPresent() && this.hasCacheConfig(annotation.get())) {
            this.updateCacheConfigContextFromAnnot(annotation.get());
        }
    }

    private void validateSubscribeResource(ResourceMethodSymbol methodSymbol, Location location) {
        ResourcePath resourcePath = methodSymbol.resourcePath();
        String resourcePathSignature = resourcePath.signature();
        if (resourcePath.kind() == ResourcePath.Kind.PATH_SEGMENT_LIST) {
            PathSegmentList pathSegmentList = (PathSegmentList)resourcePath;
            if (pathSegmentList.list().size() > 1) {
                this.addDiagnostic(CompilationDiagnostic.INVALID_HIERARCHICAL_RESOURCE_PATH, location, resourcePathSignature);
            } else {
                this.validateResourcePathSegment(location, (PathSegment)pathSegmentList.list().get(0));
            }
        } else if (resourcePath.kind() == ResourcePath.Kind.PATH_REST_PARAM) {
            this.addDiagnostic(CompilationDiagnostic.INVALID_PATH_PARAMETERS, location, resourcePathSignature);
        } else {
            this.addDiagnostic(CompilationDiagnostic.INVALID_RESOURCE_PATH, location, resourcePathSignature);
        }
        this.validateSubscriptionMethod(methodSymbol, location);
        this.validateInputParameters((MethodSymbol)methodSymbol, location);
    }

    private void validatePrefetchMethodSignature(MethodSymbol prefetchMethod, MethodSymbol resolverMethod, Location location) {
        Location prefetchMethodLocation = ValidatorUtils.getLocation((Symbol)prefetchMethod, location);
        this.validatePrefetchMethodParams(prefetchMethod, prefetchMethodLocation, resolverMethod);
        this.validatePrefetchMethodReturnType(prefetchMethod, prefetchMethodLocation);
    }

    private void validatePrefetchMethodParams(MethodSymbol prefetchMethod, Location prefetchMethodLocation, MethodSymbol resolverMethod) {
        String prefetchMethodName = prefetchMethod.getName().orElse("");
        HashSet fieldMethodParamSignatures = resolverMethod.typeDescriptor().params().isPresent() ? ((List)resolverMethod.typeDescriptor().params().get()).stream().map(ParameterSymbol::signature).map(String::trim).collect(Collectors.toSet()) : new HashSet();
        ArrayList parameterSymbols = prefetchMethod.typeDescriptor().params().isPresent() ? (List)prefetchMethod.typeDescriptor().params().get() : new ArrayList();
        boolean hasContextParam = false;
        for (ParameterSymbol symbol : parameterSymbols) {
            if (Utils.isContextParameter(symbol.typeDescriptor())) {
                hasContextParam = true;
                continue;
            }
            if (fieldMethodParamSignatures.contains(symbol.signature().trim())) continue;
            this.addDiagnostic(CompilationDiagnostic.INVALID_PARAMETER_IN_PREFETCH_METHOD, prefetchMethodLocation, symbol.signature(), prefetchMethodName, Utils.isResourceMethod(resolverMethod) ? this.getFieldPath((ResourceMethodSymbol)resolverMethod) : resolverMethod.getName().orElse(resolverMethod.signature()));
        }
        if (!hasContextParam) {
            this.addDiagnostic(CompilationDiagnostic.MISSING_GRAPHQL_CONTEXT_PARAMETER, prefetchMethodLocation, prefetchMethod.getName().orElse(prefetchMethod.signature()));
        }
    }

    private void validatePrefetchMethodReturnType(MethodSymbol prefetchMethod, Location prefetchMethodLocation) {
        if (prefetchMethod.typeDescriptor().returnTypeDescriptor().isPresent()) {
            TypeSymbol returnType = (TypeSymbol)prefetchMethod.typeDescriptor().returnTypeDescriptor().get();
            if (returnType.typeKind() == TypeDescKind.NIL) {
                return;
            }
            this.addDiagnostic(CompilationDiagnostic.INVALID_RETURN_TYPE_IN_PREFETCH_METHOD, ValidatorUtils.getLocation((Symbol)returnType, prefetchMethodLocation), returnType.signature(), prefetchMethod.getName().orElse(""));
        }
    }

    private void validateSubscriptionMethod(ResourceMethodSymbol methodSymbol, Location location) {
        if (methodSymbol.typeDescriptor().returnTypeDescriptor().isEmpty()) {
            return;
        }
        TypeSymbol returnTypeSymbol = (TypeSymbol)methodSymbol.typeDescriptor().returnTypeDescriptor().get();
        String returnTypeName = returnTypeSymbol.getName().orElse(returnTypeSymbol.signature());
        String resourceMethodName = this.getFieldPath(methodSymbol);
        if (returnTypeSymbol.typeKind() == TypeDescKind.UNION) {
            List<TypeSymbol> effectiveTypes = Utils.getEffectiveTypes((UnionTypeSymbol)returnTypeSymbol);
            if (effectiveTypes.size() != 1) {
                this.addDiagnostic(CompilationDiagnostic.INVALID_SUBSCRIBE_RESOURCE_RETURN_TYPE, location, returnTypeName, resourceMethodName);
                return;
            }
            returnTypeSymbol = effectiveTypes.get(0);
        }
        if (returnTypeSymbol.typeKind() != TypeDescKind.STREAM) {
            this.addDiagnostic(CompilationDiagnostic.INVALID_SUBSCRIBE_RESOURCE_RETURN_TYPE, location, returnTypeName, resourceMethodName);
        } else {
            String path = this.getFieldPath(methodSymbol);
            this.currentFieldPath.add(path);
            StreamTypeSymbol typeSymbol = (StreamTypeSymbol)returnTypeSymbol;
            this.validateReturnType(typeSymbol.typeParameter(), location);
            this.currentFieldPath.remove(path);
        }
    }

    private void validateRemoteMethod(MethodSymbol methodSymbol, Location location) {
        if (methodSymbol.getName().isEmpty()) {
            return;
        }
        String fieldName = (String)methodSymbol.getName().get();
        this.currentFieldPath.add(fieldName);
        if (ValidatorUtils.isInvalidFieldName(fieldName)) {
            this.addDiagnostic(CompilationDiagnostic.INVALID_FIELD_NAME, location, this.getCurrentFieldPath(), fieldName);
        } else if (ValidatorUtils.isReservedFederatedResolverName(fieldName)) {
            Location methodLocation = ValidatorUtils.getLocation((Symbol)methodSymbol, location);
            this.addDiagnostic(CompilationDiagnostic.INVALID_USE_OF_RESERVED_REMOTE_METHOD_NAME, methodLocation, fieldName);
        }
        this.validateMethod(methodSymbol, location);
        this.currentFieldPath.remove(fieldName);
    }

    private void validateMethod(MethodSymbol methodSymbol, Location location) {
        if (methodSymbol.typeDescriptor().returnTypeDescriptor().isPresent()) {
            TypeSymbol returnTypeSymbol = (TypeSymbol)methodSymbol.typeDescriptor().returnTypeDescriptor().get();
            this.validateReturnType(returnTypeSymbol, location);
        }
        this.validateInputParameters(methodSymbol, location);
    }

    private void validateResourcePath(ResourceMethodSymbol resourceMethodSymbol, Location location) {
        ResourcePath resourcePath = resourceMethodSymbol.resourcePath();
        String resourcePathSignature = resourcePath.signature();
        if (resourcePath.kind() == ResourcePath.Kind.PATH_SEGMENT_LIST) {
            PathSegmentList pathSegmentList = (PathSegmentList)resourcePath;
            for (PathSegment pathSegment : pathSegmentList.list()) {
                this.validateResourcePathSegment(location, pathSegment);
            }
        } else if (resourcePath.kind() == ResourcePath.Kind.PATH_REST_PARAM) {
            this.addDiagnostic(CompilationDiagnostic.INVALID_PATH_PARAMETERS, location, resourcePathSignature);
        } else {
            this.addDiagnostic(CompilationDiagnostic.INVALID_RESOURCE_PATH, location, resourcePathSignature);
        }
    }

    private void validateResourcePathSegment(Location location, PathSegment pathSegment) {
        if (pathSegment.pathSegmentKind() == PathSegment.Kind.NAMED_SEGMENT) {
            String fieldName = pathSegment.signature();
            if (ValidatorUtils.isInvalidFieldName(fieldName)) {
                this.addDiagnostic(CompilationDiagnostic.INVALID_FIELD_NAME, location, this.getCurrentFieldPath(), fieldName);
            }
        } else {
            String pathWithParameters = pathSegment.signature();
            this.addDiagnostic(CompilationDiagnostic.INVALID_PATH_PARAMETERS, location, pathWithParameters);
        }
    }

    private void validateReturnType(TypeSymbol typeSymbol, Location location) {
        switch (typeSymbol.typeKind()) {
            case INT: 
            case INT_SIGNED8: 
            case INT_UNSIGNED8: 
            case INT_SIGNED16: 
            case INT_UNSIGNED16: 
            case INT_SIGNED32: 
            case INT_UNSIGNED32: 
            case STRING: 
            case STRING_CHAR: 
            case BOOLEAN: 
            case DECIMAL: 
            case FLOAT: {
                break;
            }
            case ANY: 
            case ANYDATA: {
                this.addDiagnostic(CompilationDiagnostic.INVALID_RETURN_TYPE_ANY, location, this.getCurrentFieldPath());
                break;
            }
            case UNION: {
                this.validateReturnTypeUnion((UnionTypeSymbol)typeSymbol, location);
                break;
            }
            case ARRAY: {
                this.validateReturnType(((ArrayTypeSymbol)typeSymbol).memberTypeDescriptor(), location);
                break;
            }
            case TYPE_REFERENCE: {
                this.validateReturnTypeReference((TypeReferenceTypeSymbol)typeSymbol, location);
                break;
            }
            case TABLE: {
                this.validateReturnType(((TableTypeSymbol)typeSymbol).rowTypeParameter(), location);
                break;
            }
            case INTERSECTION: {
                this.validateReturnType((IntersectionTypeSymbol)typeSymbol, location);
                break;
            }
            case NIL: {
                this.addDiagnostic(CompilationDiagnostic.INVALID_RETURN_TYPE_NIL, location, this.getCurrentFieldPath());
                break;
            }
            case ERROR: {
                this.addDiagnostic(CompilationDiagnostic.INVALID_RETURN_TYPE_ERROR, location, this.getCurrentFieldPath());
                break;
            }
            case RECORD: {
                this.addDiagnostic(CompilationDiagnostic.INVALID_ANONYMOUS_FIELD_TYPE, location, typeSymbol.signature(), this.getCurrentFieldPath());
                break;
            }
            case OBJECT: {
                this.addDiagnostic(CompilationDiagnostic.INVALID_RETURN_TYPE, location, typeSymbol.signature(), this.getCurrentFieldPath());
                break;
            }
            default: {
                this.addDiagnostic(CompilationDiagnostic.INVALID_RETURN_TYPE, location, typeSymbol.getName().orElse(typeSymbol.typeKind().getName()), this.getCurrentFieldPath());
            }
        }
    }

    private void validateReturnTypeReference(TypeReferenceTypeSymbol typeReferenceTypeSymbol, Location location) {
        SymbolKind symbolKind = typeReferenceTypeSymbol.definition().kind();
        if (symbolKind == SymbolKind.TYPE_DEFINITION) {
            this.validateReturnTypeDefinition(typeReferenceTypeSymbol, location);
        } else if (symbolKind == SymbolKind.CLASS) {
            ClassSymbol classSymbol = (ClassSymbol)typeReferenceTypeSymbol.definition();
            this.validateReturnTypeClass(classSymbol, location);
        } else if (symbolKind == SymbolKind.ENUM) {
            this.validateEnumReturnType((EnumSymbol)typeReferenceTypeSymbol.definition(), location);
        }
    }

    private void validateEnumReturnType(EnumSymbol enumSymbol, Location location) {
        String enumName = (String)enumSymbol.getName().get();
        Location enumLocation = ValidatorUtils.getLocation((Symbol)enumSymbol, location);
        if (ValidatorUtils.isReservedFederatedTypeName(enumName)) {
            this.addDiagnostic(CompilationDiagnostic.INVALID_USE_OF_RESERVED_TYPE_AS_OUTPUT_TYPE, enumLocation, this.getCurrentFieldPath(), enumName);
        }
    }

    private void validateReturnType(IntersectionTypeSymbol typeSymbol, Location location) {
        TypeSymbol effectiveType = Utils.getEffectiveType(typeSymbol);
        if (effectiveType.typeKind() == TypeDescKind.RECORD) {
            this.validateRecordFields((RecordTypeSymbol)effectiveType, location);
        } else {
            this.validateReturnType(effectiveType, location);
        }
    }

    private void validateReturnTypeClass(ClassSymbol classSymbol, Location location) {
        if (classSymbol.getName().isEmpty()) {
            return;
        }
        Location classSymbolLocation = ValidatorUtils.getLocation((Symbol)classSymbol, location);
        if (Utils.isServiceClass((Symbol)classSymbol)) {
            this.validateServiceClassDefinition(classSymbol, classSymbolLocation);
        } else {
            this.addDiagnostic(CompilationDiagnostic.INVALID_RETURN_TYPE_CLASS, classSymbolLocation, classSymbol.getName().get(), this.getCurrentFieldPath());
        }
    }

    private void validateReturnTypeDefinition(TypeReferenceTypeSymbol typeReferenceTypeSymbol, Location location) {
        TypeDefinitionSymbol typeDefinitionSymbol = (TypeDefinitionSymbol)typeReferenceTypeSymbol.definition();
        if (typeReferenceTypeSymbol.typeDescriptor().typeKind() == TypeDescKind.RECORD) {
            RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)typeDefinitionSymbol.typeDescriptor();
            String recordName = typeDefinitionSymbol.getName().orElse(recordTypeSymbol.signature());
            this.validateReturnType(recordTypeSymbol, typeReferenceTypeSymbol.typeDescriptor(), location, recordName);
        } else if (typeReferenceTypeSymbol.typeDescriptor().typeKind() == TypeDescKind.OBJECT) {
            this.validateReturnTypeObject(typeDefinitionSymbol, location);
        } else if (typeReferenceTypeSymbol.typeDescriptor().typeKind() == TypeDescKind.TYPE_REFERENCE) {
            this.addDiagnostic(CompilationDiagnostic.UNSUPPORTED_TYPE_ALIAS, ValidatorUtils.getLocation((Symbol)typeReferenceTypeSymbol, location), typeReferenceTypeSymbol.getName().get(), typeReferenceTypeSymbol.typeDescriptor().getName().get());
        } else if (Utils.isPrimitiveTypeSymbol(typeReferenceTypeSymbol.typeDescriptor())) {
            this.addDiagnostic(CompilationDiagnostic.UNSUPPORTED_TYPE_ALIAS, ValidatorUtils.getLocation((Symbol)typeReferenceTypeSymbol, location), typeReferenceTypeSymbol.getName().get(), typeReferenceTypeSymbol.typeDescriptor().typeKind().getName());
        } else {
            if (typeDefinitionSymbol.getModule().isPresent() && Utils.isValidUuidModule((ModuleSymbol)typeDefinitionSymbol.getModule().get()) && typeDefinitionSymbol.getName().isPresent() && ((String)typeDefinitionSymbol.getName().get()).equals("Uuid")) {
                return;
            }
            this.validateReturnType(typeReferenceTypeSymbol.typeDescriptor(), location);
        }
    }

    private void validateReturnTypeObject(TypeDefinitionSymbol typeDefinitionSymbol, Location location) {
        if (typeDefinitionSymbol.getName().isEmpty()) {
            ObjectTypeSymbol objectTypeSymbol = (ObjectTypeSymbol)typeDefinitionSymbol.typeDescriptor();
            this.addDiagnostic(CompilationDiagnostic.INVALID_RETURN_TYPE, location, objectTypeSymbol.signature(), this.getCurrentFieldPath());
            return;
        }
        String objectTypeName = (String)typeDefinitionSymbol.getName().get();
        if (ValidatorUtils.isReservedFederatedTypeName(objectTypeName)) {
            this.addDiagnostic(CompilationDiagnostic.INVALID_USE_OF_RESERVED_TYPE_AS_OUTPUT_TYPE, location, this.getCurrentFieldPath(), objectTypeName);
        }
        if (!this.interfaceEntityFinder.isPossibleInterface(objectTypeName)) {
            this.addDiagnostic(CompilationDiagnostic.INVALID_RETURN_TYPE, location, objectTypeName, this.getCurrentFieldPath());
            return;
        }
        this.validateInterfaceObjectTypeDefinition(typeDefinitionSymbol, location);
        this.validateInterfaceImplementation(objectTypeName, location);
    }

    private void validateInterfaceObjectTypeDefinition(TypeDefinitionSymbol typeDefinitionSymbol, Location location) {
        if (this.visitedClassesAndObjectTypeDefinitions.contains(typeDefinitionSymbol)) {
            return;
        }
        this.visitedClassesAndObjectTypeDefinitions.add((Symbol)typeDefinitionSymbol);
        boolean resourceMethodFound = false;
        ObjectTypeSymbol objectTypeSymbol = (ObjectTypeSymbol)typeDefinitionSymbol.typeDescriptor();
        if (!objectTypeSymbol.qualifiers().contains(Qualifier.DISTINCT)) {
            String typeName = typeDefinitionSymbol.getName().orElse("$anonymous");
            this.addDiagnostic(CompilationDiagnostic.NON_DISTINCT_INTERFACE, location, typeName);
        }
        ArrayList<MethodSymbol> methodSymbols = new ArrayList<MethodSymbol>(objectTypeSymbol.methods().values());
        for (MethodSymbol methodSymbol : methodSymbols) {
            if (methodSymbol.kind() == SymbolKind.RESOURCE_METHOD) {
                resourceMethodFound = true;
                this.validateResourceMethod((ResourceMethodSymbol)methodSymbol, location);
            } else if (Utils.isRemoteMethod(methodSymbol)) {
                String interfaceName = (String)typeDefinitionSymbol.getName().get();
                String remoteMethodName = methodSymbol.getName().orElse(methodSymbol.signature());
                this.addDiagnostic(CompilationDiagnostic.INVALID_FUNCTION, ValidatorUtils.getLocation((Symbol)methodSymbol, location), interfaceName, remoteMethodName);
            }
            this.validatePrefetchMethodMapping(methodSymbol, methodSymbols, location);
        }
        if (!resourceMethodFound) {
            this.addDiagnostic(CompilationDiagnostic.MISSING_RESOURCE_FUNCTIONS, location);
        }
    }

    private void validateInterfaceImplementation(String interfaceName, Location location) {
        for (Symbol implementation : this.interfaceEntityFinder.getImplementations(interfaceName)) {
            if (implementation.getName().isEmpty()) continue;
            if (implementation.kind() == SymbolKind.CLASS) {
                if (!Utils.isDistinctServiceClass(implementation)) {
                    String implementationName = (String)implementation.getName().get();
                    Location implementationLocation = ValidatorUtils.getLocation(implementation, location);
                    this.addDiagnostic(CompilationDiagnostic.NON_DISTINCT_INTERFACE_IMPLEMENTATION, implementationLocation, implementationName);
                    continue;
                }
                this.validateReturnTypeClass((ClassSymbol)implementation, location);
                continue;
            }
            if (implementation.kind() != SymbolKind.TYPE_DEFINITION) continue;
            this.validateReturnTypeObject((TypeDefinitionSymbol)implementation, location);
        }
    }

    private void validateReturnType(RecordTypeSymbol recordTypeSymbol, TypeSymbol descriptor, Location location, String recordTypeName) {
        if (this.existingReturnTypes.contains(descriptor)) {
            return;
        }
        if (ValidatorUtils.isReservedFederatedTypeName(recordTypeName)) {
            this.addDiagnostic(CompilationDiagnostic.INVALID_USE_OF_RESERVED_TYPE_AS_OUTPUT_TYPE, location, this.getCurrentFieldPath(), recordTypeName);
            return;
        }
        if (this.existingInputObjectTypes.contains(descriptor)) {
            this.addDiagnostic(CompilationDiagnostic.INVALID_RETURN_TYPE_INPUT_OBJECT, location, this.getCurrentFieldPath(), recordTypeName);
            return;
        }
        if (recordTypeSymbol.fieldDescriptors().isEmpty()) {
            this.addDiagnostic(CompilationDiagnostic.INVALID_EMPTY_RECORD_OBJECT_TYPE, location, recordTypeName, this.getCurrentFieldPath());
            return;
        }
        this.existingReturnTypes.add(descriptor);
        this.validateRecordFields(recordTypeSymbol, location);
    }

    private void validateInputParameters(MethodSymbol methodSymbol, Location location) {
        FunctionTypeSymbol functionTypeSymbol = methodSymbol.typeDescriptor();
        if (functionTypeSymbol.params().isPresent()) {
            List parameterSymbols = (List)functionTypeSymbol.params().get();
            for (ParameterSymbol parameter : parameterSymbols) {
                Location inputLocation = ValidatorUtils.getLocation((Symbol)parameter, location);
                if (Utils.isValidGraphqlParameter(parameter.typeDescriptor())) continue;
                if (parameter.annotations().isEmpty()) {
                    this.validateInputParameterType(parameter.typeDescriptor(), inputLocation, Utils.isResourceMethod(methodSymbol));
                }
                if (parameter.paramKind() != ParameterKind.DEFAULTABLE) continue;
                this.validateDefaultParameter(parameter, methodSymbol, inputLocation);
            }
        }
    }

    private void validateDefaultParameter(ParameterSymbol parameter, MethodSymbol methodSymbol, Location parameterLocation) {
        String parameterName = (String)parameter.getName().get();
        FinderContext finderContext = new FinderContext(this.context);
        DefaultableParameterNode parameterNode = Utils.getDefaultableParameterNode(methodSymbol, parameter, finderContext);
        if (parameterNode == null) {
            this.addDiagnostic(CompilationDiagnostic.UNABLE_TO_INFER_DEFAULT_VALUE_AT_COMPILE_TIME, parameterLocation, this.getFieldOrParamString(false), parameterName);
            return;
        }
        this.validateDefaultValueExpression(parameterNode.expression(), parameterName, false);
    }

    private String getFieldOrParamString(boolean isObjectField) {
        return isObjectField ? INPUT_OBJECT_FIELD : PARAMETER;
    }

    private void validateDefaultValueExpression(Node valueExpression, String fieldOrParamName, boolean isObjectField) {
        switch (valueExpression.kind()) {
            case NIL_LITERAL: 
            case NUMERIC_LITERAL: 
            case STRING_LITERAL: 
            case BOOLEAN_LITERAL: {
                return;
            }
            case SIMPLE_NAME_REFERENCE: {
                this.validateDefaultValueExpression((SimpleNameReferenceNode)valueExpression, fieldOrParamName, isObjectField);
                return;
            }
            case MAPPING_CONSTRUCTOR: {
                this.validateDefaultValueExpression((MappingConstructorExpressionNode)valueExpression, fieldOrParamName, isObjectField);
                return;
            }
            case LIST_CONSTRUCTOR: {
                this.validateDefaultValueExpression((ListConstructorExpressionNode)valueExpression, fieldOrParamName, isObjectField);
                return;
            }
        }
        this.addDiagnostic(CompilationDiagnostic.PROVIDE_LITERAL_OR_CONSTRUCTOR_EXPRESSION_FOR_DEFAULT_PARAM, (Location)valueExpression.location(), this.getFieldOrParamString(isObjectField), fieldOrParamName);
    }

    private void validateDefaultValueExpression(SimpleNameReferenceNode nameReferenceNode, String parameterOrFieldName, boolean isObjectField) {
        Optional symbol = this.context.semanticModel().symbol((Node)nameReferenceNode);
        if (symbol.isEmpty()) {
            this.addDiagnostic(CompilationDiagnostic.UNABLE_TO_INFER_DEFAULT_VALUE_AT_COMPILE_TIME, (Location)nameReferenceNode.location(), this.getFieldOrParamString(isObjectField), parameterOrFieldName);
            return;
        }
        if (((Symbol)symbol.get()).kind() != SymbolKind.CONSTANT && ((Symbol)symbol.get()).kind() != SymbolKind.ENUM_MEMBER) {
            this.addDiagnostic(CompilationDiagnostic.PROVIDE_LITERAL_OR_CONSTRUCTOR_EXPRESSION_FOR_DEFAULT_PARAM, (Location)nameReferenceNode.location(), this.getFieldOrParamString(isObjectField), parameterOrFieldName);
        }
    }

    private void validateDefaultValueExpression(MappingConstructorExpressionNode mappingConstructor, String parameterOrFieldName, boolean isObjectField) {
        for (MappingFieldNode field : mappingConstructor.fields()) {
            if (field.kind() != SyntaxKind.SPECIFIC_FIELD) {
                this.addDiagnostic(CompilationDiagnostic.UNABLE_TO_INFER_DEFAULT_VALUE_PROVIDE_KEY_VALUE_PAIR, (Location)field.location(), this.getFieldOrParamString(isObjectField), parameterOrFieldName);
                continue;
            }
            SpecificFieldNode specificFieldNode = (SpecificFieldNode)field;
            if (specificFieldNode.valueExpr().isPresent()) {
                this.validateDefaultValueExpression((Node)specificFieldNode.valueExpr().get(), parameterOrFieldName, isObjectField);
                continue;
            }
            this.addDiagnostic(CompilationDiagnostic.UNABLE_TO_INFER_DEFAULT_VALUE_PROVIDE_KEY_VALUE_PAIR, (Location)field.location(), this.getFieldOrParamString(isObjectField), parameterOrFieldName);
        }
    }

    private void validateDefaultValueExpression(ListConstructorExpressionNode listConstructor, String parameterOrFieldName, boolean isObjectField) {
        for (Node member : listConstructor.expressions()) {
            if (member.kind() == SyntaxKind.SPREAD_MEMBER) {
                this.addDiagnostic(CompilationDiagnostic.UNABLE_TO_INFER_DEFAULT_VALUE_AVOID_USING_SPREAD_OPERATION, (Location)member.location(), this.getFieldOrParamString(isObjectField), parameterOrFieldName);
                continue;
            }
            this.validateDefaultValueExpression(member, parameterOrFieldName, isObjectField);
        }
    }

    private String getDefaultPrefetchMethodName(String graphqlFieldName) {
        return PREFETCH_METHOD_PREFIX + this.uppercaseFirstChar(graphqlFieldName);
    }

    private String uppercaseFirstChar(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] chars = string.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    private void validateInputParameterType(TypeSymbol typeSymbol, Location location, boolean isResourceMethod) {
        if (Utils.isFileUploadParameter(typeSymbol)) {
            String methodName = this.currentFieldPath.get(this.currentFieldPath.size() - 1);
            if (this.arrayDimension > 1) {
                this.addDiagnostic(CompilationDiagnostic.MULTI_DIMENSIONAL_UPLOAD_ARRAY, location, methodName);
            }
            if (isResourceMethod) {
                this.addDiagnostic(CompilationDiagnostic.INVALID_FILE_UPLOAD_IN_RESOURCE_FUNCTION, location, methodName);
            }
        } else {
            this.validateInputType(typeSymbol, location, isResourceMethod);
        }
    }

    private void validateInputType(TypeSymbol typeSymbol, Location location, boolean isResourceMethod) {
        this.setRootInputParameterTypeSymbol(typeSymbol);
        switch (typeSymbol.typeKind()) {
            case INT: 
            case INT_SIGNED8: 
            case INT_UNSIGNED8: 
            case INT_SIGNED16: 
            case INT_UNSIGNED16: 
            case INT_SIGNED32: 
            case INT_UNSIGNED32: 
            case STRING: 
            case STRING_CHAR: 
            case BOOLEAN: 
            case DECIMAL: 
            case FLOAT: {
                break;
            }
            case TYPE_REFERENCE: {
                this.validateInputParameterType((TypeReferenceTypeSymbol)typeSymbol, location, isResourceMethod);
                break;
            }
            case UNION: {
                this.validateInputParameterType((UnionTypeSymbol)typeSymbol, location, isResourceMethod);
                break;
            }
            case ARRAY: {
                this.validateInputParameterType((ArrayTypeSymbol)typeSymbol, location, isResourceMethod);
                break;
            }
            case INTERSECTION: {
                this.validateInputParameterType((IntersectionTypeSymbol)typeSymbol, location, isResourceMethod);
                break;
            }
            case RECORD: {
                this.addDiagnostic(CompilationDiagnostic.INVALID_ANONYMOUS_INPUT_TYPE, location, typeSymbol.signature(), this.getCurrentFieldPath());
                break;
            }
            default: {
                this.addDiagnostic(CompilationDiagnostic.INVALID_INPUT_PARAMETER_TYPE, location, this.rootInputParameterTypeSymbol.signature(), this.getCurrentFieldPath());
            }
        }
        if (this.isRootInputParameterTypeSymbol(typeSymbol)) {
            this.resetRootInputParameterTypeSymbol();
        }
    }

    private void setRootInputParameterTypeSymbol(TypeSymbol typeSymbol) {
        if (this.rootInputParameterTypeSymbol == null) {
            this.rootInputParameterTypeSymbol = typeSymbol;
        }
    }

    private void resetRootInputParameterTypeSymbol() {
        this.rootInputParameterTypeSymbol = null;
    }

    private boolean isRootInputParameterTypeSymbol(TypeSymbol typeSymbol) {
        return this.rootInputParameterTypeSymbol == typeSymbol;
    }

    private void validateInputParameterType(ArrayTypeSymbol arrayTypeSymbol, Location location, boolean isResourceMethod) {
        ++this.arrayDimension;
        TypeSymbol memberTypeSymbol = arrayTypeSymbol.memberTypeDescriptor();
        this.validateInputParameterType(memberTypeSymbol, location, isResourceMethod);
        --this.arrayDimension;
    }

    private void validateInputParameterType(TypeReferenceTypeSymbol typeSymbol, Location location, boolean isResourceMethod) {
        TypeSymbol typeDescriptor = typeSymbol.typeDescriptor();
        Symbol typeDefinition = typeSymbol.definition();
        String typeName = (String)typeDefinition.getName().get();
        if (typeDefinition.kind() == SymbolKind.ENUM) {
            if (ValidatorUtils.isReservedFederatedTypeName(typeName)) {
                this.addDiagnostic(CompilationDiagnostic.INVALID_USE_OF_RESERVED_TYPE_AS_INPUT_TYPE, location, typeName);
            }
        } else if (typeDefinition.kind() == SymbolKind.TYPE_DEFINITION && typeDescriptor.typeKind() == TypeDescKind.RECORD) {
            this.validateInputParameterType((RecordTypeSymbol)typeDescriptor, location, typeName, isResourceMethod);
        } else if (typeDescriptor.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            this.addDiagnostic(CompilationDiagnostic.UNSUPPORTED_TYPE_ALIAS, ValidatorUtils.getLocation((Symbol)typeSymbol, location), typeSymbol.getName().get(), typeDescriptor.getName().get());
        } else if (Utils.isPrimitiveTypeSymbol(typeDescriptor)) {
            this.addDiagnostic(CompilationDiagnostic.UNSUPPORTED_TYPE_ALIAS, ValidatorUtils.getLocation((Symbol)typeSymbol, location), typeSymbol.getName().get(), typeDescriptor.typeKind().getName());
        } else {
            this.validateInputParameterType(typeDescriptor, location, isResourceMethod);
        }
    }

    private void validateInputParameterType(UnionTypeSymbol unionTypeSymbol, Location location, boolean isResourceMethod) {
        boolean foundDataType = false;
        int dataTypeCount = 0;
        for (TypeSymbol memberType : unionTypeSymbol.userSpecifiedMemberTypes()) {
            if (memberType.typeKind() == TypeDescKind.ERROR) {
                this.addDiagnostic(CompilationDiagnostic.INVALID_INPUT_PARAMETER_TYPE, location, TypeDescKind.ERROR.getName(), this.getCurrentFieldPath());
                continue;
            }
            if (memberType.typeKind() == TypeDescKind.NIL) continue;
            foundDataType = true;
            ++dataTypeCount;
            if (memberType.typeKind() == TypeDescKind.SINGLETON) continue;
            this.validateInputParameterType(memberType, location, isResourceMethod);
        }
        if (!foundDataType) {
            this.addDiagnostic(CompilationDiagnostic.INVALID_INPUT_TYPE, location);
        } else if (dataTypeCount > 1) {
            this.addDiagnostic(CompilationDiagnostic.INVALID_INPUT_TYPE_UNION, location);
        }
    }

    private void validateInputParameterType(IntersectionTypeSymbol intersectionTypeSymbol, Location location, boolean isResourceMethod) {
        TypeSymbol effectiveType = Utils.getEffectiveType(intersectionTypeSymbol);
        if (effectiveType.typeKind() == TypeDescKind.RECORD) {
            String typeName = effectiveType.getName().orElse(effectiveType.signature());
            this.validateInputParameterType((RecordTypeSymbol)effectiveType, location, typeName, isResourceMethod);
        } else {
            this.validateInputParameterType(effectiveType, location, isResourceMethod);
        }
    }

    private void validateInputParameterType(RecordTypeSymbol recordTypeSymbol, Location location, String recordTypeName, boolean isResourceMethod) {
        if (this.existingReturnTypes.contains(recordTypeSymbol)) {
            this.addDiagnostic(CompilationDiagnostic.INVALID_RESOURCE_INPUT_OBJECT_PARAM, location, this.getCurrentFieldPath(), recordTypeName);
        } else {
            if (recordTypeSymbol.fieldDescriptors().isEmpty()) {
                this.addDiagnostic(CompilationDiagnostic.INVALID_EMPTY_RECORD_INPUT_TYPE, location, recordTypeName, this.getCurrentFieldPath());
            }
            if (this.existingInputObjectTypes.contains(recordTypeSymbol)) {
                return;
            }
            this.existingInputObjectTypes.add((TypeSymbol)recordTypeSymbol);
            if (ValidatorUtils.isReservedFederatedTypeName(recordTypeName)) {
                this.addDiagnostic(CompilationDiagnostic.INVALID_USE_OF_RESERVED_TYPE_AS_INPUT_TYPE, location, recordTypeName);
            }
            for (RecordFieldSymbol recordFieldSymbol : recordTypeSymbol.fieldDescriptors().values()) {
                boolean isDeprecated = recordFieldSymbol.deprecated();
                if (isDeprecated) {
                    this.addDiagnostic(CompilationDiagnostic.UNSUPPORTED_INPUT_FIELD_DEPRECATION, ValidatorUtils.getLocation((Symbol)recordFieldSymbol, location), recordTypeName);
                }
                this.validateInputType(recordFieldSymbol.typeDescriptor(), location, isResourceMethod);
            }
            if (this.hasDefaultValues(recordTypeSymbol)) {
                this.validateInputObjectDefaultValues(recordTypeSymbol, recordTypeName, location);
            }
        }
    }

    private boolean hasDefaultValues(RecordTypeSymbol recordTypeSymbol) {
        return recordTypeSymbol.fieldDescriptors().values().stream().anyMatch(RecordFieldSymbol::hasDefaultValue);
    }

    private void validateInputObjectDefaultValues(RecordTypeSymbol recordTypeSymbol, String inputObjectTypeName, Location location) {
        if (this.validatedInputTypesHavingDefaultFields.contains(inputObjectTypeName)) {
            return;
        }
        FinderContext finderContext = new FinderContext(this.context);
        TypeDefinitionNode typeDefinitionNode = Utils.getRecordTypeDefinitionNode(recordTypeSymbol, inputObjectTypeName, finderContext);
        if (typeDefinitionNode == null) {
            this.addDiagnostic(CompilationDiagnostic.UNABLE_TO_VALIDATE_DEFAULT_VALUES_OF_INPUT_OBJECT_AT_COMPILE_TIME, location, inputObjectTypeName);
            return;
        }
        for (RecordFieldSymbol recordFieldSymbol : recordTypeSymbol.fieldDescriptors().values()) {
            if (!recordFieldSymbol.hasDefaultValue()) continue;
            this.validateInputObjectDefaultFields(typeDefinitionNode, recordTypeSymbol, recordFieldSymbol, ValidatorUtils.getLocation((Symbol)recordFieldSymbol, location), inputObjectTypeName);
        }
        this.validatedInputTypesHavingDefaultFields.add(inputObjectTypeName);
    }

    private void validateInputObjectDefaultFields(TypeDefinitionNode typeDefNode, RecordTypeSymbol recordTypeSymbol, RecordFieldSymbol recordFieldSymbol, Location location, String inputObjectName) {
        if (recordFieldSymbol.getName().isEmpty()) {
            return;
        }
        RecordFieldWithDefaultValueNode defaultField = Utils.getRecordFieldWithDefaultValueNode((String)recordFieldSymbol.getName().get(), typeDefNode, this.context.semanticModel());
        if (defaultField == null) {
            TypeSymbol includedTypeSymbol;
            ArrayList<TypeSymbol> typeInclusions = new ArrayList<TypeSymbol>(Utils.getTypeInclusions((TypeSymbol)recordTypeSymbol));
            while (!typeInclusions.isEmpty() && (defaultField = this.getRecordFieldFromIncludedRecordType(recordFieldSymbol, includedTypeSymbol = typeInclusions.remove(0))) == null) {
                typeInclusions.addAll(Utils.getTypeInclusions(includedTypeSymbol));
            }
        }
        if (defaultField == null) {
            this.addDiagnostic(CompilationDiagnostic.UNABLE_TO_VALIDATE_DEFAULT_VALUES_OF_INPUT_FIELD_AT_COMPILE_TIME, ValidatorUtils.getLocation((Symbol)recordFieldSymbol, location), recordFieldSymbol.getName().get(), inputObjectName);
            return;
        }
        this.validateDefaultValueExpression((Node)defaultField.expression(), defaultField.fieldName().text(), true);
    }

    private RecordFieldWithDefaultValueNode getRecordFieldFromIncludedRecordType(RecordFieldSymbol recordFieldSymbol, TypeSymbol includedTypeSymbol) {
        TypeSymbol typeDescriptor;
        if (recordFieldSymbol.getName().isEmpty() || includedTypeSymbol.getName().isEmpty()) {
            return null;
        }
        if (includedTypeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE && (typeDescriptor = ((TypeReferenceTypeSymbol)includedTypeSymbol).typeDescriptor()).typeKind() == TypeDescKind.RECORD) {
            FinderContext finderContext = new FinderContext(this.context);
            TypeDefinitionNode recordTypeDefNode = Utils.getRecordTypeDefinitionNode((RecordTypeSymbol)typeDescriptor, (String)includedTypeSymbol.getName().get(), finderContext);
            if (recordTypeDefNode == null) {
                return null;
            }
            return Utils.getRecordFieldWithDefaultValueNode((String)recordFieldSymbol.getName().get(), recordTypeDefNode, this.context.semanticModel());
        }
        return null;
    }

    private void validateServiceClassDefinition(ClassSymbol classSymbol, Location location) {
        if (this.visitedClassesAndObjectTypeDefinitions.contains(classSymbol)) {
            return;
        }
        this.visitedClassesAndObjectTypeDefinitions.add((Symbol)classSymbol);
        String className = (String)classSymbol.getName().get();
        if (ValidatorUtils.isReservedFederatedTypeName(className)) {
            this.addDiagnostic(CompilationDiagnostic.INVALID_USE_OF_RESERVED_TYPE_AS_OUTPUT_TYPE, location, this.getCurrentFieldPath(), className);
        }
        boolean resourceMethodFound = false;
        ArrayList<MethodSymbol> methodSymbols = new ArrayList<MethodSymbol>(classSymbol.methods().values());
        for (MethodSymbol methodSymbol : methodSymbols) {
            if (methodSymbol.kind() == SymbolKind.RESOURCE_METHOD) {
                resourceMethodFound = true;
                this.validateResourceMethod((ResourceMethodSymbol)methodSymbol, location);
            } else if (Utils.isRemoteMethod(methodSymbol)) {
                this.addDiagnostic(CompilationDiagnostic.INVALID_FUNCTION, ValidatorUtils.getLocation((Symbol)methodSymbol, location), className, methodSymbol.getName().get());
            }
            this.validatePrefetchMethodMapping(methodSymbol, methodSymbols, location);
        }
        if (!resourceMethodFound) {
            this.addDiagnostic(CompilationDiagnostic.MISSING_RESOURCE_FUNCTIONS, location);
        }
    }

    private void validateReturnTypeUnion(UnionTypeSymbol unionTypeSymbol, Location location) {
        List<TypeSymbol> effectiveTypes = Utils.getEffectiveTypes(unionTypeSymbol);
        if (effectiveTypes.isEmpty()) {
            this.addDiagnostic(CompilationDiagnostic.INVALID_RETURN_TYPE_ERROR_OR_NIL, location, this.getCurrentFieldPath());
        } else if (effectiveTypes.size() == 1) {
            this.validateReturnType(effectiveTypes.get(0), location);
        } else {
            for (TypeSymbol typeSymbol : effectiveTypes) {
                this.validateUnionTypeMember(typeSymbol, location);
            }
        }
    }

    private void validateUnionTypeMember(TypeSymbol memberType, Location location) {
        if (!Utils.isDistinctServiceReference(memberType)) {
            String memberTypeName = memberType.getName().orElse(memberType.signature());
            this.addDiagnostic(CompilationDiagnostic.INVALID_UNION_MEMBER_TYPE, location, memberTypeName);
        } else {
            this.validateReturnType(memberType, location);
        }
    }

    private void validateRecordFields(RecordTypeSymbol recordTypeSymbol, Location location) {
        Map recordFieldSymbolMap = recordTypeSymbol.fieldDescriptors();
        for (RecordFieldSymbol recordField : recordFieldSymbolMap.values()) {
            if (recordField.getName().isEmpty()) continue;
            String fieldName = (String)recordField.getName().get();
            this.currentFieldPath.add(fieldName);
            if (recordField.typeDescriptor().typeKind() == TypeDescKind.MAP) {
                MapTypeSymbol mapTypeSymbol = (MapTypeSymbol)recordField.typeDescriptor();
                this.validateReturnType(mapTypeSymbol.typeParam(), location);
            } else {
                this.validateReturnType(recordField.typeDescriptor(), location);
            }
            if (ValidatorUtils.isInvalidFieldName(fieldName)) {
                this.addDiagnostic(CompilationDiagnostic.INVALID_FIELD_NAME, location, this.getCurrentFieldPath(), fieldName);
            }
            this.currentFieldPath.remove(fieldName);
        }
    }

    private void addDiagnostic(CompilationDiagnostic compilationDiagnostic, Location location) {
        this.errorOccurred = compilationDiagnostic.getDiagnosticSeverity() == DiagnosticSeverity.ERROR || this.errorOccurred;
        ValidatorUtils.updateContext(this.context, compilationDiagnostic, location);
    }

    private void addDiagnostic(CompilationDiagnostic compilationDiagnostic, Location location, Object ... args) {
        this.errorOccurred = compilationDiagnostic.getDiagnosticSeverity() == DiagnosticSeverity.ERROR || this.errorOccurred;
        ValidatorUtils.updateContext(this.context, compilationDiagnostic, location, args);
    }

    private String getFieldPath(ResourceMethodSymbol methodSymbol) {
        ArrayList<String> pathNames = new ArrayList<String>();
        if (methodSymbol.resourcePath().kind() == ResourcePath.Kind.PATH_SEGMENT_LIST) {
            PathSegmentList pathSegmentList = (PathSegmentList)methodSymbol.resourcePath();
            for (PathSegment pathSegment : pathSegmentList.list()) {
                pathNames.add(pathSegment.signature());
            }
        }
        return String.join((CharSequence)FIELD_PATH_SEPARATOR, pathNames);
    }

    private String getCurrentFieldPath() {
        return String.join((CharSequence)FIELD_PATH_SEPARATOR, this.currentFieldPath.stream().map(TypeUtils::removeEscapeCharacter).toList());
    }
}

