/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.constraint.compiler;

import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.UnaryExpressionNode;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.constraint.compiler.ConstraintCompatibilityMatrix;
import io.ballerina.stdlib.constraint.compiler.ConstraintDiagnosticCodes;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Optional;

public final class ConstraintCompilerPluginUtils {
    private static final ConstraintCompatibilityMatrix matrix = new ConstraintCompatibilityMatrix();

    private ConstraintCompilerPluginUtils() {
    }

    static void validateConstraints(SyntaxNodeAnalysisContext ctx, NodeList<AnnotationNode> annotationNodes, String fieldType, TypeSymbol fieldTypeSymbol) {
        for (AnnotationNode annotationNode : annotationNodes) {
            String[] annotationParts = annotationNode.annotReference().toString().trim().split(":");
            if (!annotationParts[0].equals("constraint")) continue;
            String annotationTag = annotationParts[1];
            ConstraintCompilerPluginUtils.checkAnnotationTagCompatibility(ctx, annotationNode, annotationTag, fieldType, fieldTypeSymbol);
            ConstraintCompilerPluginUtils.checkAnnotationConstraintsAvailability(ctx, annotationNode, annotationTag, fieldType);
            ConstraintCompilerPluginUtils.checkAnnotationConstraintsCompatibility(ctx, annotationNode, annotationTag, fieldType);
            ConstraintCompilerPluginUtils.checkAnnotationConstraintsValidity(ctx, annotationNode, annotationTag);
        }
    }

    private static void checkAnnotationTagCompatibility(SyntaxNodeAnalysisContext ctx, AnnotationNode annotationNode, String annotationTag, String fieldType, TypeSymbol fieldTypeSymbol) {
        if (!matrix.isAnnotationTagCompatibleWithTypeSymbol(ctx, annotationTag, fieldTypeSymbol)) {
            ConstraintCompilerPluginUtils.reportAnnotationTagIncompatibility(ctx, annotationTag, fieldType, annotationNode.location());
        }
    }

    private static void checkAnnotationConstraintsAvailability(SyntaxNodeAnalysisContext ctx, AnnotationNode annotationNode, String annotationTag, String fieldType) {
        Optional value = annotationNode.annotValue();
        if (value.filter(node -> node.fields().size() > 0).isEmpty() && !annotationTag.equals("Date")) {
            ConstraintCompilerPluginUtils.reportConstraintsUnavailability(ctx, annotationTag, fieldType, annotationNode.location());
        }
    }

    private static void checkAnnotationConstraintsCompatibility(SyntaxNodeAnalysisContext ctx, AnnotationNode annotationNode, String annotationTag, String fieldType) {
        Optional value = annotationNode.annotValue();
        if (value.isPresent()) {
            ArrayList<String> constraintsList = new ArrayList<String>();
            SeparatedNodeList constraints = ((MappingConstructorExpressionNode)value.get()).fields();
            for (MappingFieldNode constraint : constraints) {
                SpecificFieldNode node = (SpecificFieldNode)constraint;
                constraintsList.add(node.fieldName().toString().trim());
            }
            if (!matrix.isAnnotationConstraintsCompatible(annotationTag, constraintsList)) {
                ConstraintCompilerPluginUtils.reportConstraintsIncompatibility(ctx, annotationTag, fieldType, annotationNode.location());
            }
        }
    }

    private static void checkAnnotationConstraintsValidity(SyntaxNodeAnalysisContext ctx, AnnotationNode annotationNode, String annotationTag) {
        Optional value = annotationNode.annotValue();
        if (value.isPresent()) {
            SeparatedNodeList constraints = ((MappingConstructorExpressionNode)value.get()).fields();
            for (MappingFieldNode constraint : constraints) {
                SpecificFieldNode node = (SpecificFieldNode)constraint;
                Optional valueExpr = node.valueExpr();
                if (!valueExpr.isPresent()) continue;
                if (valueExpr.get() instanceof BasicLiteralNode || valueExpr.get() instanceof UnaryExpressionNode) {
                    ConstraintCompilerPluginUtils.getValueFromSimpleValueExpressionNode(ctx, annotationTag, node, (ExpressionNode)valueExpr.get());
                    continue;
                }
                if (!(valueExpr.get() instanceof MappingConstructorExpressionNode)) continue;
                ConstraintCompilerPluginUtils.getValueFromMappingConstructor(ctx, annotationTag, node, (ExpressionNode)valueExpr.get());
            }
        }
    }

    private static void getValueFromMappingConstructor(SyntaxNodeAnalysisContext ctx, String annotationTag, SpecificFieldNode node, ExpressionNode valueExpr) {
        MappingConstructorExpressionNode expressionNode = (MappingConstructorExpressionNode)valueExpr;
        SeparatedNodeList fields = expressionNode.fields();
        for (MappingFieldNode field : fields) {
            SpecificFieldNode fieldNode = (SpecificFieldNode)field;
            if (!fieldNode.fieldName().toString().trim().equals("value")) continue;
            Optional fieldExpr = fieldNode.valueExpr();
            fieldExpr.ifPresent(expressionNode1 -> ConstraintCompilerPluginUtils.getValueFromSimpleValueExpressionNode(ctx, annotationTag, node, expressionNode1));
        }
    }

    private static void getValueFromSimpleValueExpressionNode(SyntaxNodeAnalysisContext ctx, String annotationTag, SpecificFieldNode node, ExpressionNode valueExpr) {
        String constraintValue = valueExpr.toString().trim().replaceAll("\n", "").replaceAll("d", "");
        String constraintField = node.fieldName().toString().trim();
        if (!matrix.isAnnotationConstraintsValid(annotationTag, constraintField, constraintValue)) {
            ConstraintCompilerPluginUtils.reportConstraintsInvalidity(ctx, annotationTag, constraintField, node.location());
        }
    }

    private static void reportAnnotationTagIncompatibility(SyntaxNodeAnalysisContext ctx, String annotationTag, String fieldType, NodeLocation nodeLocation) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ConstraintDiagnosticCodes.CONSTRAINT_101.getCode(), String.format(ConstraintDiagnosticCodes.CONSTRAINT_101.getMessage(), annotationTag, fieldType), ConstraintDiagnosticCodes.CONSTRAINT_101.getSeverity());
        ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)nodeLocation, (Object[])new Object[0]));
    }

    private static void reportConstraintsUnavailability(SyntaxNodeAnalysisContext ctx, String annotationTag, String fieldType, NodeLocation nodeLocation) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ConstraintDiagnosticCodes.CONSTRAINT_102.getCode(), String.format(ConstraintDiagnosticCodes.CONSTRAINT_102.getMessage(), annotationTag, fieldType), ConstraintDiagnosticCodes.CONSTRAINT_102.getSeverity());
        ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)nodeLocation, (Object[])new Object[0]));
    }

    private static void reportConstraintsIncompatibility(SyntaxNodeAnalysisContext ctx, String annotationTag, String fieldType, NodeLocation location) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ConstraintDiagnosticCodes.CONSTRAINT_103.getCode(), String.format(ConstraintDiagnosticCodes.CONSTRAINT_103.getMessage(), annotationTag, fieldType), ConstraintDiagnosticCodes.CONSTRAINT_103.getSeverity());
        ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])new Object[0]));
    }

    private static void reportConstraintsInvalidity(SyntaxNodeAnalysisContext ctx, String annotationTag, String field, NodeLocation location) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ConstraintDiagnosticCodes.CONSTRAINT_104.getCode(), String.format(ConstraintDiagnosticCodes.CONSTRAINT_104.getMessage(), field, annotationTag), ConstraintDiagnosticCodes.CONSTRAINT_104.getSeverity());
        ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])new Object[0]));
    }
}

